/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.utils;

import com.bc.ceres.swing.selection.AbstractSelection;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileListSelection
extends AbstractSelection
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor};
    private final List<File> fileList = new ArrayList<File>();

    public FileListSelection(File[] fileList) {
        this.fileList.addAll(Arrays.asList(fileList));
    }

    public File getSelectedValue() {
        return this.fileList.get(0);
    }

    public File[] getSelectedValues() {
        return this.fileList.toArray(new File[this.fileList.size()]);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : flavors) {
            if (!flavor.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.fileList;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return null;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

