/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.utils;

import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.SnapFileChooser;

public class FileFolderUtils {
    public static File GetFilePath(String title, String formatName, String extension, String fileName, String description, boolean isSave) {
        return FileFolderUtils.GetFilePath(title, formatName, extension, fileName, description, isSave, "last_product_save_dir", FileSystemView.getFileSystemView().getRoots()[0].getAbsolutePath());
    }

    public static File GetSaveFilePath(String title, String formatName, String extension, String fileName, String description) {
        return FileFolderUtils.GetFilePath(title, formatName, extension, fileName, description, true, "last_product_save_dir", FileSystemView.getFileSystemView().getRoots()[0].getAbsolutePath());
    }

    public static File GetFilePath(String title, String formatName, String extension, String fileName, String description, boolean isSave, String lastDirPropertyKey, String defaultPath) {
        SnapFileFilter fileFilter = null;
        if (!extension.isEmpty()) {
            fileFilter = new SnapFileFilter(formatName, extension, description);
        }
        File file = null;
        if (isSave) {
            String lastDir = SnapApp.getDefault().getPreferences().get(lastDirPropertyKey, SystemUtils.getUserHomeDir().getPath());
            File currentDir = new File(lastDir);
            SnapFileChooser fileChooser = new SnapFileChooser();
            fileChooser.setCurrentDirectory(currentDir);
            fileChooser.addChoosableFileFilter((FileFilter)new SnapFileFilter(formatName, extension, description));
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setDialogTitle("Save");
            fileChooser.setCurrentFilename(fileName);
            fileChooser.setFileSelectionMode(0);
            int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
            if (result == 0) {
                file = fileChooser.getSelectedFile();
                File currentDirectory = fileChooser.getCurrentDirectory();
                if (currentDirectory != null) {
                    SnapApp.getDefault().getPreferences().put(lastDirPropertyKey, currentDirectory.getPath());
                }
            }
        } else {
            String lastDir = SnapApp.getDefault().getPreferences().get(lastDirPropertyKey, defaultPath);
            file = fileName == null ? FileFolderUtils.showFileOpenDialog(title, false, (FileFilter)fileFilter, lastDir, lastDirPropertyKey) : FileFolderUtils.showFileOpenDialog(title, false, (FileFilter)fileFilter, fileName, lastDirPropertyKey);
        }
        return file == null ? null : FileUtils.ensureExtension((File)file, (String)extension);
    }

    private static File showFileOpenDialog(String title, boolean dirsOnly, FileFilter fileFilter, String currentDir, String lastDirPropertyKey) {
        String lastDirPath;
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setCurrentDirectory(new File(currentDir));
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        int result = fileChooser.showOpenDialog((Component)SnapApp.getDefault().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null && (lastDirPath = fileChooser.getCurrentDirectory().getAbsolutePath()) != null) {
            SnapApp.getDefault().getPreferences().put(lastDirPropertyKey, lastDirPath);
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().isEmpty()) {
                return null;
            }
            return file.getAbsoluteFile();
        }
        return null;
    }
}

