/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

public final class DialogUtils {
    public static void enableComponents(JComponent label, JComponent field, boolean flag) {
        label.setVisible(flag);
        field.setVisible(flag);
    }

    public static void addComponent(JPanel contentPane, GridBagConstraints gbc, JLabel label, JComponent component) {
        gbc.gridx = 0;
        contentPane.add((Component)label, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)component, gbc);
        gbc.gridx = 0;
    }

    public static JLabel addComponent(JPanel contentPane, GridBagConstraints gbc, String text, JComponent component) {
        gbc.gridx = 0;
        JLabel label = new JLabel(text);
        contentPane.add((Component)label, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)component, gbc);
        gbc.gridx = 0;
        return label;
    }

    public static void addInnerPanel(JPanel contentPane, GridBagConstraints gbc, JLabel label, JComponent component1, JComponent component2) {
        contentPane.add((Component)label, gbc);
        JPanel innerPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = DialogUtils.createGridBagConstraints();
        innerPane.add((Component)component1, gbc2);
        gbc2.gridx = 1;
        innerPane.add((Component)component2, gbc2);
        gbc.gridx = 1;
        contentPane.add((Component)innerPane, gbc);
    }

    public static JFormattedTextField createFormattedTextField(NumberFormat numFormat, Object value, PropertyChangeListener propListener) {
        JFormattedTextField field = new JFormattedTextField(numFormat);
        field.setValue(value);
        field.setColumns(10);
        if (propListener != null) {
            field.addPropertyChangeListener("value", propListener);
        }
        return field;
    }

    public static void fillPanel(JPanel panel, GridBagConstraints gbc) {
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
    }

    public static JButton createIconButton(String name, String text, ImageIcon icon, boolean toggle) {
        return DialogUtils.createButton(name, text, icon, null, ButtonStyle.Icon, toggle);
    }

    public static JButton createButton(String name, String text, ImageIcon icon, JPanel panel, ButtonStyle style) {
        return DialogUtils.createButton(name, text, icon, panel, style, false);
    }

    public static JButton createButton(String name, String text, ImageIcon icon, JPanel panel, ButtonStyle style, boolean toggle) {
        JButton button;
        if (icon == null || style == ButtonStyle.TextAndIcon) {
            button = new JButton();
            button.setText(text);
        } else {
            button = style == ButtonStyle.FramedButton ? new JButton() : (JButton)ToolButtonFactory.createButton((Icon)icon, (boolean)toggle);
        }
        button.setName(name);
        button.setIcon(icon);
        if (panel != null) {
            button.setBackground(panel.getBackground());
        }
        button.setToolTipText(text);
        button.setActionCommand(name);
        return button;
    }

    public static GridBagConstraints createGridBagConstraints() {
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets.top = 1;
        gbc.insets.bottom = 1;
        gbc.insets.right = 1;
        gbc.insets.left = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        return gbc;
    }

    public static class TextAreaKeyListener
    implements KeyListener {
        private boolean changedByUser = false;

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.changedByUser = true;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        public boolean isChangedByUser() {
            return this.changedByUser;
        }
    }

    public static class ComponentListPanel
    extends JPanel {
        private final JPanel labelPanel;
        private final JPanel fieldPanel;

        public ComponentListPanel() {
            GridLayout grid = new GridLayout(0, 1);
            grid.setVgap(5);
            this.labelPanel = new JPanel(grid);
            this.fieldPanel = new JPanel(new GridLayout(0, 1));
            this.add((Component)this.labelPanel, "Center");
            this.add((Component)this.fieldPanel, "After");
        }

        public void addComponent(String labelStr, JComponent component) {
            this.labelPanel.add(new JLabel(labelStr));
            this.fieldPanel.add(component);
        }
    }

    public static enum ButtonStyle {
        Text,
        Icon,
        TextAndIcon,
        FramedButton;

    }
}

