/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.ProgressMonitor;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIRegistry;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GPFProcessor;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNodeList;
import org.esa.snap.graphbuilder.rcp.dialogs.support.ProductSetUIHandler;
import org.esa.snap.graphbuilder.rcp.dialogs.support.SubGraphHandler;
import org.esa.snap.rcp.util.Dialogs;

public class GraphExecuter
extends Observable {
    private final GPF gpf;
    private Graph graph;
    private GraphContext graphContext = null;
    private GraphProcessor processor;
    private String graphDescription = "";
    private File lastLoadedGraphFile = null;
    private final GraphNodeList graphNodeList = new GraphNodeList();
    private static final String LAST_GRAPH_PATH = "graphbuilder.last_graph_path";

    public GraphExecuter() {
        this.gpf = GPF.getDefaultInstance();
        if (this.gpf.getOperatorSpiRegistry().getOperatorSpis().isEmpty()) {
            this.gpf.getOperatorSpiRegistry().loadOperatorSpis();
        }
        this.graph = new Graph("Graph");
    }

    public List<GraphNode> GetGraphNodes() {
        return this.graphNodeList.getGraphNodes();
    }

    public GraphNodeList getGraphNodeList() {
        return this.graphNodeList;
    }

    public void ClearGraph() {
        this.graph = null;
        this.graph = new Graph("Graph");
        this.lastLoadedGraphFile = null;
        this.graphNodeList.clear();
    }

    public void setSelectedNode(GraphNode node) {
        if (node == null) {
            return;
        }
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.SELECT_EVENT, node));
        this.clearChanged();
    }

    public Set<String> GetOperatorList() {
        return this.gpf.getOperatorSpiRegistry().getAliases();
    }

    public boolean isOperatorInternal(String alias) {
        OperatorSpiRegistry registry = this.gpf.getOperatorSpiRegistry();
        OperatorSpi operatorSpi = registry.getOperatorSpi(alias);
        OperatorMetadata operatorMetadata = operatorSpi.getOperatorClass().getAnnotation(OperatorMetadata.class);
        return operatorMetadata == null || operatorMetadata.internal();
    }

    public String getOperatorCategory(String alias) {
        OperatorSpiRegistry registry = this.gpf.getOperatorSpiRegistry();
        OperatorSpi operatorSpi = registry.getOperatorSpi(alias);
        OperatorMetadata operatorMetadata = operatorSpi.getOperatorClass().getAnnotation(OperatorMetadata.class);
        if (operatorMetadata != null) {
            return operatorMetadata.category();
        }
        return "";
    }

    public GraphNode addOperator(String opName) {
        String id = opName;
        int cnt = 1;
        while (this.graphNodeList.findGraphNode(id) != null) {
            id = opName + '(' + ++cnt + ')';
        }
        GraphNode newGraphNode = this.createNewGraphNode(this.graph, opName, id);
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.ADD_EVENT, newGraphNode));
        this.clearChanged();
        return newGraphNode;
    }

    static GraphNode createNewGraphNode(Graph graph, GraphNodeList graphNodeList, String opName, String id) {
        Node newNode = new Node(id, opName);
        XppDomElement parameters = new XppDomElement("parameters");
        newNode.setConfiguration((DomElement)parameters);
        graph.addNode(newNode);
        GraphNode newGraphNode = new GraphNode(newNode);
        graphNodeList.add(newGraphNode);
        newGraphNode.setOperatorUI(OperatorUIRegistry.CreateOperatorUI(newGraphNode.getOperatorName()));
        return newGraphNode;
    }

    private GraphNode createNewGraphNode(Graph graph, String opName, String id) {
        Node newNode = new Node(id, opName);
        XppDomElement parameters = new XppDomElement("parameters");
        newNode.setConfiguration((DomElement)parameters);
        graph.addNode(newNode);
        GraphNode newGraphNode = new GraphNode(newNode);
        this.graphNodeList.add(newGraphNode);
        newGraphNode.setOperatorUI(OperatorUIRegistry.CreateOperatorUI(newGraphNode.getOperatorName()));
        this.moveWriterToLast(graph);
        return newGraphNode;
    }

    private void moveWriterToLast(Graph graph) {
        String writeOperatorAlias = OperatorSpi.getOperatorAlias(WriteOp.class);
        GraphNode writerNode = this.graphNodeList.findGraphNode(writeOperatorAlias);
        if (writerNode != null) {
            this.removeNode(writerNode);
            this.graphNodeList.add(writerNode);
            graph.addNode(writerNode.getNode());
        }
    }

    public void removeOperator(GraphNode node) {
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.REMOVE_EVENT, node));
        this.clearChanged();
        this.removeNode(node);
    }

    private void removeNode(GraphNode node) {
        this.graphNodeList.remove(node);
        this.graph.removeNode(node.getID());
    }

    public void autoConnectGraph() {
        List<GraphNode> nodes = this.GetGraphNodes();
        Collections.sort(nodes, new GraphNodePosComparator());
        for (int i = 0; i < nodes.size() - 1; ++i) {
            if (nodes.get(i).HasSources()) continue;
            nodes.get(i).connectOperatorSource(nodes.get(i + 1).getID());
        }
        this.notifyConnection();
    }

    public void notifyConnection() {
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.CONNECT_EVENT, this.graphNodeList.getGraphNodes().get(0)));
        this.clearChanged();
    }

    public void setOperatorParam(String id, String paramName, String value) {
        Node node = this.graph.getNode(id);
        DomElement xml = (DomElement)node.getConfiguration().getChild(paramName);
        if (xml == null) {
            xml = new XppDomElement(paramName);
            node.getConfiguration().addChild(xml);
        }
        xml.setValue(value);
    }

    private void AssignAllParameters() throws GraphException {
        XppDom presentationXML = new XppDom("Presentation");
        XppDom descXML = new XppDom("Description");
        descXML.setValue(this.graphDescription);
        presentationXML.addChild(descXML);
        this.graphNodeList.assignParameters(presentationXML);
        this.graph.setAppData("Presentation", presentationXML);
    }

    public boolean InitGraph() throws GraphException {
        if (this.graphNodeList.isGraphComplete()) {
            this.AssignAllParameters();
            ProductSetUIHandler productSetHandler = new ProductSetUIHandler(this.graph, this.graphNodeList);
            SubGraphHandler subGraphHandler = new SubGraphHandler(this.graph, this.graphNodeList);
            try {
                this.recreateGraphContext();
                this.graphNodeList.updateGraphNodes(this.graphContext);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new GraphException(e.getMessage());
            }
            finally {
                subGraphHandler.restore();
                productSetHandler.restore();
            }
            return true;
        }
        return false;
    }

    private void recreateGraphContext() throws GraphException {
        if (this.graphContext != null) {
            this.graphContext.dispose();
        }
        this.processor = new GraphProcessor();
        this.graphContext = new GraphContext(this.graph);
    }

    public void disposeGraphContext() {
        this.graphContext.dispose();
    }

    public void executeGraph(ProgressMonitor pm) {
        this.processor.executeGraph(this.graphContext, pm);
    }

    public File[] getPotentialOutputFiles() {
        Node[] nodes;
        ArrayList<File> fileList = new ArrayList<File>();
        for (Node n : nodes = this.graph.getNodes()) {
            String filePath;
            DomElement config;
            DomElement fileParam;
            if (!n.getOperatorName().equalsIgnoreCase(OperatorSpi.getOperatorAlias(WriteOp.class)) || (fileParam = (DomElement)(config = n.getConfiguration()).getChild("file")) == null || (filePath = fileParam.getValue()) == null || filePath.isEmpty()) continue;
            File file = new File(filePath);
            fileList.add(file);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public File saveGraph() throws GraphException {
        SnapFileFilter fileFilter;
        File filePath;
        String filename = "myGraph";
        if (this.lastLoadedGraphFile != null) {
            filename = this.lastLoadedGraphFile.getAbsolutePath();
        }
        if ((filePath = Dialogs.requestFileForSave((String)"Save Graph", (boolean)false, (FileFilter)(fileFilter = new SnapFileFilter("XML", "xml", "Graph")), (String)".xml", (String)filename, null, (String)LAST_GRAPH_PATH)) != null) {
            this.writeGraph(filePath.getAbsolutePath());
        }
        return filePath;
    }

    private void writeGraph(String filePath) throws GraphException {
        try (FileWriter fileWriter = new FileWriter(filePath);){
            this.AssignAllParameters();
            GraphIO.write((Graph)this.graph, (Writer)fileWriter);
        }
        catch (Exception e) {
            throw new GraphException("Unable to write graph to " + filePath + '\n' + e.getMessage());
        }
    }

    public String getGraphAsString() throws GraphException, IOException {
        try (StringWriter stringWriter = new StringWriter();){
            this.AssignAllParameters();
            GraphIO.write((Graph)this.graph, (Writer)stringWriter);
        }
        return stringWriter.toString();
    }

    public void loadGraph(File filePath, boolean addUI) throws GraphException {
        try {
            if (filePath == null) {
                return;
            }
            Graph graphFromFile = GPFProcessor.readGraph(new FileReader(filePath), null);
            this.setGraph(graphFromFile, addUI);
            this.lastLoadedGraphFile = filePath;
        }
        catch (Throwable e) {
            throw new GraphException("Unable to load graph " + filePath + '\n' + e.getMessage());
        }
    }

    public void loadGraph(InputStream fileStream, boolean addUI) throws GraphException {
        try {
            if (fileStream == null) {
                return;
            }
            Graph graphFromFile = GPFProcessor.readGraph(new InputStreamReader(fileStream), null);
            this.setGraph(graphFromFile, addUI);
        }
        catch (Throwable e) {
            throw new GraphException("Unable to load graph " + fileStream.toString() + '\n' + e.getMessage());
        }
    }

    public void setGraph(Graph graphFromFile, boolean addUI) throws GraphException {
        if (graphFromFile != null) {
            Node[] nodes;
            XppDom descXML;
            this.graph = graphFromFile;
            this.graphNodeList.clear();
            XppDom presentationXML = this.graph.getApplicationData("Presentation");
            if (presentationXML != null && (descXML = presentationXML.getChild("Description")) != null && descXML.getValue() != null) {
                this.graphDescription = descXML.getValue();
            }
            for (Node n : nodes = this.graph.getNodes()) {
                GraphNode newGraphNode = new GraphNode(n);
                if (presentationXML != null) {
                    newGraphNode.setDisplayParameters(presentationXML);
                }
                this.graphNodeList.add(newGraphNode);
                if (addUI) {
                    OperatorUI ui = OperatorUIRegistry.CreateOperatorUI(newGraphNode.getOperatorName());
                    if (ui == null) {
                        throw new GraphException("Unable to load " + newGraphNode.getOperatorName());
                    }
                    newGraphNode.setOperatorUI(ui);
                }
                this.setChanged();
                this.notifyObservers(new GraphEvent(events.ADD_EVENT, newGraphNode));
                this.clearChanged();
            }
        }
    }

    public String getGraphDescription() {
        return this.graphDescription;
    }

    public void setGraphDescription(String text) {
        this.graphDescription = text;
    }

    public List<File> getProductsToOpenInDAT() {
        Node[] nodes;
        ArrayList<File> fileList = new ArrayList<File>(2);
        for (Node n : nodes = this.graph.getNodes()) {
            String filePath;
            DomElement config;
            DomElement fileParam;
            if (!n.getOperatorName().equalsIgnoreCase(OperatorSpi.getOperatorAlias(WriteOp.class)) || (fileParam = (DomElement)(config = n.getConfiguration()).getChild("file")) == null || (filePath = fileParam.getValue()) == null || filePath.isEmpty()) continue;
            File file = new File(filePath);
            if (file.exists()) {
                fileList.add(file);
                continue;
            }
            DomElement formatParam = (DomElement)config.getChild("formatName");
            String format = formatParam.getValue();
            String ext = ReaderUtils.findExtensionForFormat((String)format);
            File newFile = new File(file.getAbsolutePath() + ext);
            if (newFile.exists()) {
                fileList.add(newFile);
                continue;
            }
            String name = FileUtils.getFilenameWithoutExtension((File)file);
            newFile = new File(name + ext);
            if (!newFile.exists()) continue;
            fileList.add(newFile);
        }
        return fileList;
    }

    public static void setGraphIO(GraphExecuter graphEx, String readID, File readPath, String writeID, File writePath, String format) {
        GraphNode writeNode;
        GraphNode readNode = graphEx.getGraphNodeList().findGraphNode(readID);
        if (readNode != null) {
            graphEx.setOperatorParam(readNode.getID(), "file", readPath.getAbsolutePath());
        }
        if (writeID != null && (writeNode = graphEx.getGraphNodeList().findGraphNode(writeID)) != null) {
            graphEx.setOperatorParam(writeNode.getID(), "formatName", format);
            graphEx.setOperatorParam(writeNode.getID(), "file", writePath.getAbsolutePath());
        }
    }

    static class GraphNodePosComparator
    implements Comparator<GraphNode> {
        GraphNodePosComparator() {
        }

        @Override
        public int compare(GraphNode o1, GraphNode o2) {
            double h2;
            double x1 = o1.getPos().getX();
            double y1 = o1.getPos().getY();
            double x2 = o2.getPos().getX();
            double y2 = o2.getPos().getY();
            double h1 = FastMath.hypot((double)x1, (double)y1);
            if (h1 > (h2 = FastMath.hypot((double)x2, (double)y2))) {
                return -1;
            }
            if (h1 < h2) {
                return 1;
            }
            return 0;
        }
    }

    public static class GraphEvent {
        private final events eventType;
        private final Object data;

        GraphEvent(events type, Object d) {
            this.eventType = type;
            this.data = d;
        }

        public Object getData() {
            return this.data;
        }

        public events getEventType() {
            return this.eventType;
        }
    }

    public static enum events {
        ADD_EVENT,
        REMOVE_EVENT,
        SELECT_EVENT,
        CONNECT_EVENT;

    }
}

