/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.param.ParamChangeEvent;
import org.esa.snap.core.param.ParamChangeListener;
import org.esa.snap.core.param.ParamProperties;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.product.ProductExpressionPane;

public class BandMathsOpUI
extends BaseOperatorUI {
    private static final String _PARAM_NAME_BAND = "targetBand";
    private Parameter paramBand = null;
    private Parameter paramBandType = null;
    private Parameter paramBandUnit = null;
    private Parameter paramNoDataValue = null;
    private Parameter paramExpression = null;
    private Product targetProduct = null;
    private Band targetBand = null;
    private ProductNodeList<Product> productsList = null;
    private JButton editExpressionButton = null;
    private JComponent panel = null;
    private String errorText = "";
    private AppContext appContext;
    private BandMathsOp.BandDescriptor bandDesc = new BandMathsOp.BandDescriptor();

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.appContext = appContext;
        this.initializeOperatorUI(operatorName, parameterMap);
        this.initVariables();
        this.panel = this.createUI();
        this.initParameters();
        return this.panel;
    }

    @Override
    public void initParameters() {
        Object[] bandDescriptors = (Object[])this.paramMap.get("targetBands");
        if (bandDescriptors == null) {
            bandDescriptors = (Object[])this.paramMap.get("targetBandDescriptors");
        }
        if (bandDescriptors != null && bandDescriptors.length > 0) {
            this.bandDesc = (BandMathsOp.BandDescriptor)bandDescriptors[0];
            this.bandDesc.type = "float32";
            try {
                this.paramBand.setValueAsText(this.bandDesc.name);
                this.paramBandType.setValueAsText(this.bandDesc.type);
                this.paramBandUnit.setValueAsText(this.bandDesc.unit);
                this.paramNoDataValue.setValueAsText(String.valueOf(this.bandDesc.noDataValue));
                this.paramExpression.setValueAsText(this.bandDesc.expression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            this.targetProduct = this.sourceProducts[0];
            this.targetBand = new Band(this.bandDesc.name, 30, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
            this.targetBand.setDescription("");
            this.productsList = new ProductNodeList();
            for (Product prod : this.sourceProducts) {
                this.productsList.add((ProductNode)prod);
            }
        } else {
            this.targetProduct = null;
            this.targetBand = null;
        }
        this.updateUIState(this.paramBand.getName());
    }

    @Override
    public UIValidation validateParameters() {
        if (this.targetProduct != null && !this.isValidExpression()) {
            return new UIValidation(UIValidation.State.ERROR, "Expression is invalid. " + this.errorText);
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        this.bandDesc.name = this.paramBand.getValueAsText();
        this.bandDesc.type = this.paramBandType.getValueAsText();
        this.bandDesc.unit = this.paramBandUnit.getValueAsText();
        String noDataValueStr = this.paramNoDataValue.getValueAsText();
        this.bandDesc.noDataValue = noDataValueStr.isEmpty() ? 0.0 : Double.parseDouble(noDataValueStr);
        this.bandDesc.expression = this.paramExpression.getValueAsText();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{this.bandDesc};
        this.paramMap.put("targetBandDescriptors", bandDescriptors);
    }

    private void initVariables() {
        ParamChangeListener paramChangeListener = this.createParamChangeListener();
        BandMathsOp.BandDescriptor[] bandDescriptors = (BandMathsOp.BandDescriptor[])this.paramMap.get("targetBandDescriptors");
        if (bandDescriptors != null && bandDescriptors.length > 0) {
            this.bandDesc = bandDescriptors[1];
        } else {
            this.bandDesc.name = "newVirtualBand";
            this.bandDesc.type = "float32";
        }
        this.paramBand = new Parameter(_PARAM_NAME_BAND, (Object)this.bandDesc.name);
        this.paramBand.getProperties().setValueSetBound(false);
        this.paramBand.getProperties().setLabel("Target Band");
        this.paramBand.addParamChangeListener(paramChangeListener);
        this.paramBandType = new Parameter("bandType", (Object)this.bandDesc.type);
        this.paramBandType.getProperties().setValueSetBound(false);
        this.paramBandType.getProperties().setLabel("Target Band Type");
        this.paramBandType.addParamChangeListener(paramChangeListener);
        this.paramBandUnit = new Parameter("bandUnit", (Object)this.bandDesc.unit);
        this.paramBandUnit.getProperties().setValueSetBound(false);
        this.paramBandUnit.getProperties().setLabel("Band Unit");
        this.paramBandUnit.addParamChangeListener(paramChangeListener);
        this.paramNoDataValue = new Parameter("bandNodataValue", (Object)this.bandDesc.noDataValue);
        this.paramNoDataValue.getProperties().setValueSetBound(false);
        this.paramNoDataValue.getProperties().setLabel("No-Data Value");
        this.paramNoDataValue.addParamChangeListener(paramChangeListener);
        this.paramExpression = new Parameter("arithmetikExpr", (Object)this.bandDesc.expression);
        this.paramExpression.getProperties().setLabel("Expression");
        this.paramExpression.getProperties().setDescription("Arithmetic expression");
        this.paramExpression.getProperties().setNumRows(5);
        this.setArithmetikValues();
    }

    private JComponent createUI() {
        this.editExpressionButton = new JButton("Edit Expression...");
        this.editExpressionButton.setName("editExpressionButton");
        this.editExpressionButton.addActionListener(this.createEditExpressionButtonListener());
        JPanel gridPanel = GridBagUtils.createPanel();
        int line = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        ++line;
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBand.getEditor().getLabelComponent(), (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBand.getEditor().getComponent(), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBandType.getEditor().getLabelComponent(), (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBandType.getEditor().getComponent(), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBandUnit.getEditor().getLabelComponent(), (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramBandUnit.getEditor().getComponent(), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramNoDataValue.getEditor().getLabelComponent(), (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramNoDataValue.getEditor().getComponent(), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramExpression.getEditor().getLabelComponent(), (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=NORTHWEST");
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.paramExpression.getEditor().getComponent(), (GridBagConstraints)gbc, (String)"weightx=1, weighty=1, insets.top=3, gridwidth=2, fill=BOTH, anchor=WEST");
        gbc.gridy = line;
        GridBagUtils.addToPanel((JPanel)gridPanel, (Component)this.editExpressionButton, (GridBagConstraints)gbc, (String)"weighty=0, insets.top=3, gridwidth=3, fill=NONE, anchor=EAST");
        return gridPanel;
    }

    private void setArithmetikValues() {
        ParamProperties props = this.paramExpression.getProperties();
        props.setPropertyValue("compatibleProductsForBandArithmethik", (Object)this.getCompatibleProducts());
        props.setPropertyValue("selectedProductForBandArithmethik", (Object)this.targetProduct);
    }

    private ParamChangeListener createParamChangeListener() {
        return new ParamChangeListener(){

            public void parameterValueChanged(ParamChangeEvent event) {
                BandMathsOpUI.this.updateUIState(event.getParameter().getName());
            }
        };
    }

    private Product[] getCompatibleProducts() {
        if (this.targetProduct == null) {
            return null;
        }
        Vector<Product> compatibleProducts = new Vector<Product>();
        compatibleProducts.add(this.targetProduct);
        float geolocationEps = 180.0f;
        Debug.trace((String)"BandArithmetikDialog.geolocationEps = 180.0");
        Debug.trace((String)"BandArithmetikDialog.getCompatibleProducts:");
        Debug.trace((String)("  comparing: " + this.targetProduct.getName()));
        for (int i = 0; i < this.productsList.size(); ++i) {
            Product product = (Product)this.productsList.getAt(i);
            if (this.targetProduct == product) continue;
            Debug.trace((String)("  with:      " + product.getDisplayName()));
            boolean compatibleProduct = this.targetProduct.isCompatibleProduct(product, 180.0f);
            Debug.trace((String)("  result:    " + compatibleProduct));
            if (!compatibleProduct) continue;
            compatibleProducts.add(product);
        }
        return compatibleProducts.toArray(new Product[compatibleProducts.size()]);
    }

    private ActionListener createEditExpressionButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductExpressionPane pep = ProductExpressionPane.createGeneralExpressionPane((Product[])BandMathsOpUI.this.getCompatibleProducts(), (Product)BandMathsOpUI.this.targetProduct, (PropertyMap)BandMathsOpUI.this.appContext.getPreferences());
                pep.setCode(BandMathsOpUI.this.paramExpression.getValueAsText());
                int status = pep.showModalDialog(SwingUtilities.getWindowAncestor(BandMathsOpUI.this.panel), "Arithmetic Expression Editor");
                if (status == 1) {
                    BandMathsOpUI.this.paramExpression.setValue((Object)pep.getCode(), null);
                    Debug.trace((String)("BandArithmetikDialog: expression is: " + pep.getCode()));
                    ((BandMathsOpUI)BandMathsOpUI.this).bandDesc.expression = BandMathsOpUI.this.paramExpression.getValueAsText();
                }
                pep.dispose();
                pep = null;
            }
        };
    }

    private boolean isValidExpression() {
        this.errorText = "";
        Product[] products = this.getCompatibleProducts();
        if (products == null || products.length == 0) {
            return false;
        }
        String expression = this.paramExpression.getValueAsText();
        if (expression == null || expression.length() == 0) {
            return false;
        }
        try {
            BandArithmetic.parseExpression((String)expression, (Product[])products, (int)0);
        }
        catch (ParseException e) {
            this.errorText = e.getMessage();
            return false;
        }
        return true;
    }

    private void updateUIState(String parameterName) {
        if (parameterName == null) {
            return;
        }
        if (parameterName.equals(_PARAM_NAME_BAND)) {
            boolean b = this.targetProduct != null;
            this.paramExpression.setUIEnabled(b);
            this.editExpressionButton.setEnabled(b);
            this.paramBand.setUIEnabled(b);
            this.paramBandType.setUIEnabled(b);
            this.paramBandUnit.setUIEnabled(b);
            this.paramNoDataValue.setUIEnabled(b);
            if (b) {
                this.setArithmetikValues();
            }
            String selectedBandName = this.paramBand.getValueAsText();
            if (b && selectedBandName != null && selectedBandName.length() > 0) {
                this.targetBand = this.targetProduct.getBand(selectedBandName);
            }
        }
    }
}

