/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.main.CommandLineUsage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CommandLineUsageTest {
    static final FooOpSpi FOO_OP_SPI = new FooOpSpi();

    @BeforeClass
    public static void setupTest() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)FOO_OP_SPI);
    }

    @AfterClass
    public static void tearDownTest() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)FOO_OP_SPI);
    }

    @Test
    public void testOperatorUsageText() throws NoSuchFieldException {
        String usageText = CommandLineUsage.getUsageTextForOperator((String)"FooOp");
        Assert.assertEquals((Object)"Usage:\n  gpt FooOp [options] \n\n\nSource Options:\n  -Sinput1=<file>    Sets source 'input1' to <filepath>.\n                     This is a mandatory source.\n  -Sinput2=<file>    Sets source 'input2' to <filepath>.\n                     This is a mandatory source.\n\nParameter Options:\n  -Py=<string>    Sets parameter 'y' to <string>.\n  -Pz=<float>     Sets parameter 'z' to <float>.\n\nGraph XML Format:\n  <graph id=\"someGraphId\">\n    <version>1.0</version>\n    <node id=\"someNodeId\">\n      <operator>FooOp</operator>\n      <sources>\n        <input1>${input1}</input1>\n        <input2>${input2}</input2>\n      </sources>\n      <parameters>\n        <z>float</z>\n        <y>string</y>\n        <bar>\n          <c>float</c>\n          <b>string</b>\n        </bar>\n      </parameters>\n    </node>\n  </graph>\n", (Object)usageText);
    }

    static class Bar {
        @Parameter(alias="c")
        float a;
        String b;
        final double notMe1 = 0.42;
        static String notMe2;
        transient int notMe3;

        Bar() {
        }
    }

    static class FooOp
    extends Operator {
        @SourceProduct(alias="input1")
        Product sourceProduct1;
        @SourceProduct(alias="input2")
        Product sourceProduct2;
        @Parameter(alias="z")
        float x;
        @Parameter
        String y;
        @Parameter
        Bar bar;
        @Parameter
        @Deprecated
        float baz;

        FooOp() {
        }

        public void initialize() throws OperatorException {
        }
    }

    public static class FooOpSpi
    extends OperatorSpi {
        public FooOpSpi() {
            super(FooOp.class);
        }
    }
}

