/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.bc.ceres.binding.dom.DomElement;
import com.sun.media.jai.util.SunTileScheduler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.TileScheduler;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.main.CommandLineContext;
import org.esa.snap.core.gpf.main.CommandLineTool;

public class CommandLineToolGraphTest
extends TestCase {
    private GraphCommandLineContext context;
    private CommandLineTool clTool;
    private TileScheduler jaiTileScheduler;
    private static final TestOps.Op2.Spi OP2_SPI = new TestOps.Op2.Spi();
    private static final TestOps.Op3.Spi OP3_SPI = new TestOps.Op3.Spi();
    private static final TestOps.OpImplementingOutput.Spi OUTPUT_OP_SPI = new TestOps.OpImplementingOutput.Spi();

    protected void setUp() throws Exception {
        this.context = new GraphCommandLineContext();
        this.clTool = new CommandLineTool((CommandLineContext)this.context);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP2_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP3_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OUTPUT_OP_SPI);
        JAI jai = JAI.getDefaultInstance();
        this.jaiTileScheduler = jai.getTileScheduler();
        SunTileScheduler tileScheduler = new SunTileScheduler();
        tileScheduler.setParallelism(Runtime.getRuntime().availableProcessors());
        jai.setTileScheduler((TileScheduler)tileScheduler);
    }

    protected void tearDown() throws Exception {
        JAI.getDefaultInstance().setTileScheduler(this.jaiTileScheduler);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP2_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP3_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OUTPUT_OP_SPI);
    }

    public void testGraphUsageMessage() throws Exception {
        String[] args = new String[]{"-h", "graph.xml"};
        this.clTool.run(args);
        String message = this.context.m;
        CommandLineToolGraphTest.assertNotNull((Object)message);
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("Usage:"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("Source Options:"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("sourceProduct1"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("First source product"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("sourceProduct2"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("Parameter Options:"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("threshold"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("Threshold value"));
        CommandLineToolGraphTest.assertTrue((boolean)message.contains("expression"));
    }

    public void testGraphOnly() throws Exception {
        this.testGraph(new String[]{"graph.xml"}, 3, "g=graph.xml;e=chain1;", "${sourceProduct}", null, "${sourceProduct2}", null, "WriteOp@node2", "target.dim", "BEAM-DIMAP", "${threshold}", "${expression}");
    }

    public void testGraphWithParameters() throws Exception {
        this.testGraph(new String[]{"graph.xml", "-Pexpression=a+b/c", "-Pthreshold=2.5"}, 3, "g=graph.xml;e=chain1;", "${sourceProduct}", null, "${sourceProduct2}", null, "WriteOp@node2", "target.dim", "BEAM-DIMAP", "2.5", "a+b/c");
    }

    public void testGraphWithParametersAndSourceArgs() throws Exception {
        this.testGraph(new String[]{"graph.xml", "-Pexpression=a+b/c", "-Pthreshold=2.5", "ernie.dim", "idefix.dim"}, 5, "g=graph.xml;e=chain1;", "ReadOp@sourceProduct", "ernie.dim", "ReadOp@sourceProduct.2", "idefix.dim", "WriteOp@node2", "target.dim", "BEAM-DIMAP", "2.5", "a+b/c");
    }

    public void testGraphWithParametersAndSourceOptions() throws Exception {
        this.testGraph(new String[]{"graph.xml", "-Pexpression=a+b/c", "-Pthreshold=2.5", "-SsourceProduct=ernie.dim", "-SsourceProduct2=idefix.dim"}, 5, "g=graph.xml;e=chain1;", "ReadOp@sourceProduct", "ernie.dim", "ReadOp@sourceProduct2", "idefix.dim", "WriteOp@node2", "target.dim", "BEAM-DIMAP", "2.5", "a+b/c");
    }

    public void testGraphWithParametersFileOption() throws Exception {
        this.testGraph(new String[]{"graph.xml", "-p", "paramFile.properties", "-SsourceProduct=ernie.dim", "-SsourceProduct2=idefix.dim"}, 5, "g=graph.xml;e=chain1;", "ReadOp@sourceProduct", "ernie.dim", "ReadOp@sourceProduct2", "idefix.dim", "WriteOp@node2", "target.dim", "BEAM-DIMAP", "-0.5125", "sqrt(x*x + y*y)");
    }

    public void testGraphWithParametersFileOptionIsOverwrittenByOption() throws Exception {
        this.testGraph(new String[]{"graph.xml", "-p", "paramFile.properties", "-Pexpression=atan(y/x)", "-SsourceProduct=ernie.dim", "-SsourceProduct2=idefix.dim"}, 5, "g=graph.xml;e=chain1;", "ReadOp@sourceProduct", "ernie.dim", "ReadOp@sourceProduct2", "idefix.dim", "WriteOp@node2", "target.dim", "BEAM-DIMAP", "-0.5125", "atan(y/x)");
    }

    public void testGraphWithOpImplementingOutputInterface() throws Exception {
        String[] args = new String[]{"graphWithOutput.xml"};
        this.clTool.run(args);
        CommandLineToolGraphTest.assertEquals((int)0, (int)this.context.writeProductCounter);
    }

    private void testGraph(String[] args, int expectedNodeCount, String expectedLog, String expectedSourceNodeId1, String expectedSourceFilepath1, String expectedSourceNodeId2, String expectedSourceFilepath2, String expectedTargetNodeId, String expectedTargetFilepath, String expectedTargetFormat, String expectedThreshold, String expectedExpression) throws Exception {
        this.clTool.run(args);
        CommandLineToolGraphTest.assertEquals((String)expectedLog, (String)this.context.logString);
        Graph executedGraph = this.context.executedGraph;
        CommandLineToolGraphTest.assertNotNull((Object)executedGraph);
        CommandLineToolGraphTest.assertEquals((int)expectedNodeCount, (int)executedGraph.getNodeCount());
        Node node1 = executedGraph.getNode("node1");
        CommandLineToolGraphTest.assertEquals((String)expectedSourceNodeId1, (String)node1.getSource(0).getSourceNodeId());
        CommandLineToolGraphTest.assertEquals((String)expectedThreshold, (String)((DomElement)node1.getConfiguration().getChild("threshold")).getValue());
        Node node2 = executedGraph.getNode("node2");
        CommandLineToolGraphTest.assertEquals((String)"node1", (String)node2.getSource(0).getSourceNodeId());
        CommandLineToolGraphTest.assertEquals((String)expectedSourceNodeId2, (String)node2.getSource(1).getSourceNodeId());
        CommandLineToolGraphTest.assertEquals((String)expectedExpression, (String)((DomElement)node2.getConfiguration().getChild("expression")).getValue());
        if (expectedSourceFilepath1 != null) {
            Node generatedReaderNode1 = executedGraph.getNode(expectedSourceNodeId1);
            CommandLineToolGraphTest.assertNotNull((Object)generatedReaderNode1);
            CommandLineToolGraphTest.assertEquals((String)expectedSourceFilepath1, (String)((DomElement)generatedReaderNode1.getConfiguration().getChild("file")).getValue());
        }
        if (expectedSourceFilepath2 != null) {
            Node generatedReaderNode2 = executedGraph.getNode(expectedSourceNodeId2);
            CommandLineToolGraphTest.assertNotNull((Object)generatedReaderNode2);
            CommandLineToolGraphTest.assertEquals((String)expectedSourceFilepath2, (String)((DomElement)generatedReaderNode2.getConfiguration().getChild("file")).getValue());
        }
        Node generatedWriterNode = executedGraph.getNode(expectedTargetNodeId);
        CommandLineToolGraphTest.assertNotNull((Object)generatedWriterNode);
        CommandLineToolGraphTest.assertEquals((String)"node2", (String)generatedWriterNode.getSource(0).getSourceNodeId());
        DomElement parameters = generatedWriterNode.getConfiguration();
        CommandLineToolGraphTest.assertNotNull((Object)parameters);
        CommandLineToolGraphTest.assertNotNull((String)expectedTargetFilepath, (Object)((DomElement)parameters.getChild("file")).getValue());
        CommandLineToolGraphTest.assertNotNull((String)expectedTargetFormat, (Object)((DomElement)parameters.getChild("formatName")).getValue());
    }

    private static class GraphCommandLineContext
    implements CommandLineContext {
        public String logString = "";
        private int readProductCounter;
        private int writeProductCounter;
        public Graph executedGraph;
        private String m = "";

        public Product readProduct(String productFilepath) throws IOException {
            this.logString = this.logString + "s" + this.readProductCounter + "=" + productFilepath + ";";
            ++this.readProductCounter;
            return new Product("P", "T", 10, 10);
        }

        public void writeProduct(Product targetProduct, String filePath, String formatName, boolean clearCacheAfterRowWrite) throws IOException {
            this.logString = this.logString + "t" + this.writeProductCounter + "=" + filePath + ";";
            ++this.writeProductCounter;
        }

        public Graph readGraph(String filepath, Map<String, String> templateVariables) throws IOException, GraphException {
            String xml;
            this.logString = this.logString + "g=" + filepath + ";";
            if ("graph.xml".equals(filepath)) {
                xml = "<graph id=\"chain1\"><version>1.0</version>\n<header>\n<target refid=\"node2\"/>\n<source name=\"sourceProduct1\" description=\"First source product\"/>\n<source name=\"sourceProduct2\"/>\n<parameter name=\"threshold\" type=\"double\" description=\"Threshold value\"/>\n<parameter name=\"expression\" type=\"String\"/>\n</header>\n<node id=\"node1\">  <operator>org.esa.snap.core.gpf.TestOps$Op2$Spi</operator>\n  <sources>\n    <input>${sourceProduct}</input>\n  </sources>\n  <parameters>\n    <threshold>${threshold}</threshold>\n  </parameters>\n</node><node id=\"node2\">  <operator>org.esa.snap.core.gpf.TestOps$Op3$Spi</operator>\n  <sources>\n    <input1 refid=\"node1\"/>\n    <input2>${sourceProduct2}</input2>\n  </sources>\n  <parameters>\n    <expression>${expression}</expression>\n  </parameters>\n</node></graph>";
            } else if ("graphWithOutput.xml".equals(filepath)) {
                xml = "<graph id=\"chain1\"><version>1.0</version>\n<node id=\"node1\">  <operator>org.esa.snap.core.gpf.TestOps$OpImplementingOutput$Spi</operator>\n</node></graph>";
            } else {
                throw new IllegalArgumentException("Path to graph file must be either 'graph.xml' or 'graphWithOutput.xml'");
            }
            return GraphIO.read((Reader)new StringReader(xml), templateVariables);
        }

        public void executeGraph(Graph graph, GraphProcessingObserver observer) throws GraphException {
            this.logString = this.logString + "e=" + graph.getId() + ";";
            this.executedGraph = graph;
        }

        public Reader createReader(String fileName) throws FileNotFoundException {
            return new StringReader("expression=sqrt(x*x + y*y)\nthreshold=-0.5125");
        }

        public Writer createWriter(String fileName) throws IOException {
            return new StringWriter();
        }

        public String[] list(String path) throws IOException {
            return new String[0];
        }

        public void print(String m) {
            this.m = this.m + m;
        }

        public Logger getLogger() {
            return Logger.getLogger("test");
        }

        public boolean fileExists(String fileName) {
            return false;
        }

        public boolean isFile(String path) {
            return true;
        }
    }
}

