/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.esa.snap.core.image.BandOpImage;

class TestOpImage
extends BandOpImage {
    private HashMap<Rectangle, TileImpl> tileMap = new HashMap(4);

    public TestOpImage(Band band) {
        super(band);
    }

    public synchronized int getTileCount() {
        return this.tileMap.size();
    }

    public synchronized TileImpl getTile(Rectangle rect) {
        return this.tileMap.get(rect);
    }

    protected synchronized void computeRect(PlanarImage[] planarImages, WritableRaster writableRaster, Rectangle rectangle) {
        int x1 = writableRaster.getMinX();
        int x2 = writableRaster.getMinX() + writableRaster.getWidth() - 1;
        int y1 = writableRaster.getMinY();
        int y2 = writableRaster.getMinY() + writableRaster.getHeight() - 1;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                double sample = TestOpImage.getSampleDouble(x, y);
                writableRaster.setSample(x, y, 0, sample);
            }
        }
        this.tileMap.put(rectangle, new TileImpl(this.getRasterDataNode(), writableRaster, rectangle));
    }

    public static double getSampleDouble(int x, int y) {
        return 10.0 * (double)x + (double)y + 0.5;
    }
}

