/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.internal.AbstractTileImageTileTest;
import org.esa.snap.core.gpf.internal.TestOpImage;
import org.esa.snap.core.gpf.internal.TileImpl;

public class SingleTileImageTileTest
extends AbstractTileImageTileTest {
    static final int IMAGE_W = 4;
    static final int IMAGE_H = 5;
    private TestOpImage imageFLOAT32;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.imageFLOAT32 = this.getImage("B_FLOAT32");
    }

    @Override
    public int getTileCount() {
        return 1;
    }

    @Override
    public Dimension getImageSize() {
        return new Dimension(4, 5);
    }

    @Override
    public Dimension getTileSize() {
        return new Dimension(4, 5);
    }

    public void testThatImageIsNotTiled() {
        SingleTileImageTileTest.assertEquals((int)1, (int)this.imageFLOAT32.getTileCount());
        SingleTileImageTileTest.assertEquals((int)4, (int)this.imageFLOAT32.getSampleModel().getWidth());
        SingleTileImageTileTest.assertEquals((int)5, (int)this.imageFLOAT32.getSampleModel().getHeight());
    }

    public void testFullTile() {
        Rectangle expectedRect = new Rectangle(4, 5);
        TileImpl tile = this.imageFLOAT32.getTile(expectedRect);
        SingleTileImageTileTest.assertNotNull((Object)tile);
        SingleTileImageTileTest.assertSame((Object)this.getBand("B_FLOAT32"), (Object)tile.getRasterDataNode());
        this.testTileStructure(tile, expectedRect, 0, 4, true);
        this.testOnlySamplesFloatAccessible(tile);
        SingleTileImageTileTest.assertEquals((double)0.5, (double)tile.getSampleDouble(0, 0), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)1.5, (double)tile.getSampleDouble(0, 1), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)2.5, (double)tile.getSampleDouble(0, 2), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)3.5, (double)tile.getSampleDouble(0, 3), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)10.5, (double)tile.getSampleDouble(1, 0), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)20.5, (double)tile.getSampleDouble(2, 0), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)30.5, (double)tile.getSampleDouble(3, 0), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)11.5, (double)tile.getSampleDouble(1, 1), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)22.5, (double)tile.getSampleDouble(2, 2), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)33.5, (double)tile.getSampleDouble(3, 3), (double)1.0E-5);
        this.testFloat32RawSampleIO(tile, 0, 0);
        this.testFloat32RawSampleIO(tile, 0, 4);
        this.testFloat32RawSampleIO(tile, 3, 0);
        this.testFloat32RawSampleIO(tile, 3, 4);
        this.testFloat32RawSampleIO(tile, 2, 2);
    }

    public void testChildTile() {
        boolean CHILD_X = true;
        int CHILD_Y = 2;
        int CHILD_W = 2;
        int CHILD_H = 3;
        Rectangle expectedRect = new Rectangle(1, 2, 2, 3);
        Raster childRaster = this.getImageData(this.imageFLOAT32, expectedRect);
        TileImpl tile = new TileImpl((RasterDataNode)this.getBand("B_FLOAT32"), childRaster, expectedRect, false);
        SingleTileImageTileTest.assertSame((Object)this.getBand("B_FLOAT32"), (Object)tile.getRasterDataNode());
        this.testTileStructure(tile, expectedRect, 9, 4, false);
        this.testOnlySamplesFloatAccessible(tile);
        SingleTileImageTileTest.assertEquals((double)12.5, (double)tile.getSampleDouble(1, 2), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)22.5, (double)tile.getSampleDouble(2, 2), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)13.5, (double)tile.getSampleDouble(1, 3), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)23.5, (double)tile.getSampleDouble(2, 3), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)14.5, (double)tile.getSampleDouble(1, 4), (double)1.0E-5);
        SingleTileImageTileTest.assertEquals((double)24.5, (double)tile.getSampleDouble(2, 4), (double)1.0E-5);
        this.testFloat32RawSampleIO(tile, 1, 2);
        this.testFloat32RawSampleIO(tile, 2, 2);
        this.testFloat32RawSampleIO(tile, 1, 3);
        this.testFloat32RawSampleIO(tile, 2, 3);
        this.testFloat32RawSampleIO(tile, 1, 4);
        this.testFloat32RawSampleIO(tile, 2, 4);
    }
}

