/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.internal.SampleConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SampleConverterFactoryFLOAT32Test {
    private static Band band;
    private double maxRawValue;
    private double minRawValue;

    @Before
    public void beforeTest() {
        band = new Band("n", 30, 1, 1);
        band.setRasterData(band.createCompatibleRasterData());
        this.maxRawValue = 3.4028234663852886E38;
        this.minRawValue = -3.4028234663852886E38;
    }

    @Test
    public void testToGeoPhysical_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)this.maxRawValue, (double)sampleConverter.toGeoPhysical(this.maxRawValue), (double)1.0E-6);
        Assert.assertEquals((double)-356.0, (double)sampleConverter.toGeoPhysical(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)16.0, (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)this.minRawValue, (double)sampleConverter.toGeoPhysical(this.minRawValue), (double)1.0E-6);
    }

    @Test
    public void testToGeoPhysical_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)(this.maxRawValue * scalingFactor), (double)sampleConverter.toGeoPhysical(this.maxRawValue), (double)1.0E-6);
        Assert.assertEquals((double)(-356.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)(0.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)(16.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)(this.minRawValue * scalingFactor), (double)sampleConverter.toGeoPhysical(this.minRawValue), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)this.maxRawValue, (double)sampleConverter.toRaw(this.maxRawValue), (double)1.0E-6);
        Assert.assertEquals((double)-356.0, (double)sampleConverter.toRaw(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)10.8, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)this.minRawValue, (double)sampleConverter.toRaw(this.minRawValue), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)(this.maxRawValue / 1.1), (double)sampleConverter.toRaw(this.maxRawValue), (double)1.0E-6);
        Assert.assertEquals((double)-323.6363636363636, (double)sampleConverter.toRaw(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)9.818181818181818, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)(this.minRawValue / 1.1), (double)sampleConverter.toRaw(this.minRawValue), (double)1.0E-6);
    }
}

