/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperatorExecutorTest {
    private TileScheduler defaultTileScheduler;
    private RecordingTileScheduler recordingTileScheduler;

    @Before
    public void setUp() throws Exception {
        this.defaultTileScheduler = JAI.getDefaultInstance().getTileScheduler();
        this.recordingTileScheduler = new RecordingTileScheduler(this.defaultTileScheduler);
        JAI.getDefaultInstance().setTileScheduler((TileScheduler)this.recordingTileScheduler);
    }

    @After
    public void tearDown() throws Exception {
        JAI.getDefaultInstance().setTileScheduler(this.defaultTileScheduler);
    }

    @Test
    public void testOneTile() {
        Product sourceProduct = this.createSourceProduct();
        TestOP op = new TestOP(sourceProduct);
        OperatorExecutor operatorExecutor = OperatorExecutor.create((Operator)op);
        operatorExecutor.execute(ProgressMonitor.NULL);
        Assert.assertEquals((long)3L, (long)this.recordingTileScheduler.recordedCalls.size());
        Assert.assertEquals((Object)"getParallelism", (Object)this.recordingTileScheduler.recordedCalls.get(0));
        Assert.assertEquals((Object)"scheduleTiles", (Object)this.recordingTileScheduler.recordedCalls.get(1));
        Assert.assertEquals((Object)"scheduleTile", (Object)this.recordingTileScheduler.recordedCalls.get(2));
        Assert.assertEquals((long)1L, (long)this.recordingTileScheduler.requestedTileIndices.size());
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(0));
    }

    @Test
    public void testManyTilesOneBand() {
        Product sourceProduct = this.createSourceProduct();
        sourceProduct.setPreferredTileSize(50, 50);
        TestOP op = new TestOP(sourceProduct);
        OperatorExecutor operatorExecutor = OperatorExecutor.create((Operator)op);
        operatorExecutor.execute(ProgressMonitor.NULL);
        Assert.assertEquals((long)9L, (long)this.recordingTileScheduler.recordedCalls.size());
        Assert.assertEquals((long)4L, (long)this.recordingTileScheduler.requestedTileIndices.size());
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(0));
        Assert.assertEquals((Object)new Point(1, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(1));
        Assert.assertEquals((Object)new Point(0, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(2));
        Assert.assertEquals((Object)new Point(1, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(3));
    }

    @Test
    public void testManyTilesTwoBands() {
        Product sourceProduct = this.createSourceProduct();
        Band bandB = sourceProduct.addBand("b", 10);
        bandB.setRasterData(OperatorExecutorTest.createDataFor(bandB));
        bandB.setSynthetic(true);
        sourceProduct.setPreferredTileSize(50, 50);
        TestOP op = new TestOP(sourceProduct);
        OperatorExecutor operatorExecutor = OperatorExecutor.create((Operator)op);
        operatorExecutor.execute(ProgressMonitor.NULL);
        Assert.assertEquals((long)17L, (long)this.recordingTileScheduler.recordedCalls.size());
        Assert.assertEquals((long)8L, (long)this.recordingTileScheduler.requestedTileIndices.size());
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(0));
        Assert.assertEquals((Object)new Point(1, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(1));
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(2));
        Assert.assertEquals((Object)new Point(1, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(3));
        Assert.assertEquals((Object)new Point(0, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(4));
        Assert.assertEquals((Object)new Point(1, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(5));
        Assert.assertEquals((Object)new Point(0, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(6));
        Assert.assertEquals((Object)new Point(1, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(7));
    }

    @Test
    public void testManyTilesTwoBands_ColumnBandOrder() {
        Product sourceProduct = this.createSourceProduct();
        Band bandB = sourceProduct.addBand("b", 10);
        bandB.setRasterData(OperatorExecutorTest.createDataFor(bandB));
        bandB.setSynthetic(true);
        sourceProduct.setPreferredTileSize(50, 50);
        TestOP op = new TestOP(sourceProduct);
        OperatorExecutor operatorExecutor = OperatorExecutor.create((Operator)op);
        operatorExecutor.execute(OperatorExecutor.ExecutionOrder.SCHEDULE_ROW_COLUMN_BAND, ProgressMonitor.NULL);
        Assert.assertEquals((long)13L, (long)this.recordingTileScheduler.recordedCalls.size());
        Assert.assertEquals((long)4L, (long)this.recordingTileScheduler.requestedTileIndices.size());
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(0));
        Assert.assertEquals((Object)new Point(1, 0), (Object)this.recordingTileScheduler.requestedTileIndices.get(1));
        Assert.assertEquals((Object)new Point(0, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(2));
        Assert.assertEquals((Object)new Point(1, 1), (Object)this.recordingTileScheduler.requestedTileIndices.get(3));
    }

    private Product createSourceProduct() {
        Product product = new Product("source", "source", 100, 100);
        Band bandA = product.addBand("a", 10);
        bandA.setRasterData(OperatorExecutorTest.createDataFor(bandA));
        bandA.setSynthetic(true);
        return product;
    }

    private static ProductData createDataFor(Band dataBand) {
        int width = dataBand.getRasterWidth();
        int height = dataBand.getRasterHeight();
        ProductData data = ProductData.createInstance((int)dataBand.getDataType(), (int)(width * height));
        for (int y = 0; y < height; ++y) {
            int line = y * width;
            for (int x = 0; x < width; ++x) {
                data.setElemIntAt(line + x, x * y);
            }
        }
        return data;
    }

    private class TestOP
    extends Operator {
        @SourceProduct
        Product source;

        public TestOP(Product source) {
            this.source = source;
        }

        public void initialize() throws OperatorException {
            Product targetProduct = new Product("target", "target", 100, 100);
            for (Band srcBand : this.source.getBands()) {
                Band band = targetProduct.addBand(srcBand.getName(), srcBand.getDataType());
                band.setSourceImage(srcBand.getSourceImage());
            }
            this.setTargetProduct(targetProduct);
        }
    }

    private class RecordingTileScheduler
    implements TileScheduler {
        TileScheduler delegate;
        List<String> recordedCalls = Collections.synchronizedList(new ArrayList());
        List<Point> requestedTileIndices = Collections.synchronizedList(new ArrayList());

        RecordingTileScheduler(TileScheduler delegate) {
            this.delegate = delegate;
        }

        public void cancelTiles(TileRequest request, Point[] tileIndices) {
            this.recordedCalls.add("cancelTiles");
            this.delegate.cancelTiles(request, tileIndices);
        }

        public int getParallelism() {
            this.recordedCalls.add("getParallelism");
            return this.delegate.getParallelism();
        }

        public int getPrefetchParallelism() {
            this.recordedCalls.add("getPrefetchParallelism");
            return this.delegate.getPrefetchParallelism();
        }

        public int getPrefetchPriority() {
            this.recordedCalls.add("getPrefetchPriority");
            return this.delegate.getPrefetchPriority();
        }

        public int getPriority() {
            this.recordedCalls.add("getPriority");
            return this.delegate.getPriority();
        }

        public void prefetchTiles(PlanarImage target, Point[] tileIndices) {
            this.recordedCalls.add("prefetchTiles");
            this.delegate.prefetchTiles(target, tileIndices);
        }

        public Raster scheduleTile(OpImage target, int tileX, int tileY) {
            this.recordedCalls.add("scheduleTile");
            return this.delegate.scheduleTile(target, tileX, tileY);
        }

        public Raster[] scheduleTiles(OpImage target, Point[] tileIndices) {
            this.recordedCalls.add("scheduleTiles");
            return this.delegate.scheduleTiles(target, tileIndices);
        }

        public TileRequest scheduleTiles(PlanarImage target, Point[] tileIndices, TileComputationListener[] tileListeners) {
            this.recordedCalls.add("scheduleTiles");
            this.requestedTileIndices.addAll(Arrays.asList(tileIndices));
            return this.delegate.scheduleTiles(target, tileIndices, tileListeners);
        }

        public void setParallelism(int parallelism) {
            this.recordedCalls.add("setParallelism");
            this.delegate.setParallelism(parallelism);
        }

        public void setPrefetchParallelism(int parallelism) {
            this.recordedCalls.add("setPrefetchParallelism");
            this.delegate.setPrefetchParallelism(parallelism);
        }

        public void setPrefetchPriority(int priority) {
            this.recordedCalls.add("setPrefetchPriority");
            this.delegate.setPrefetchPriority(priority);
        }

        public void setPriority(int priority) {
            this.recordedCalls.add("setPriority");
            this.delegate.setPriority(priority);
        }
    }
}

