/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.internal.AbstractTileImageTileTest;
import org.esa.snap.core.gpf.internal.TestOpImage;
import org.esa.snap.core.gpf.internal.TileImpl;

public class MultiTileImageTileTest
extends AbstractTileImageTileTest {
    static final int IMAGE_W = 10;
    static final int IMAGE_H = 12;
    static final int TILE_SIZE = 6;
    private TestOpImage imageFLOAT32;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.imageFLOAT32 = this.getImage("B_FLOAT32");
    }

    @Override
    public int getTileCount() {
        return 4;
    }

    @Override
    public Dimension getImageSize() {
        return new Dimension(10, 12);
    }

    @Override
    public Dimension getTileSize() {
        return new Dimension(6, 6);
    }

    public void testThatImageIsTiled() {
        MultiTileImageTileTest.assertEquals((int)6, (int)this.imageFLOAT32.getSampleModel().getWidth());
        MultiTileImageTileTest.assertEquals((int)6, (int)this.imageFLOAT32.getSampleModel().getHeight());
        MultiTileImageTileTest.assertEquals((int)4, (int)this.imageFLOAT32.getTileCount());
    }

    public void testTargetTile00() {
        this.testTargetTile(new Rectangle(0, 0, 6, 6));
    }

    public void testTargetTile10() {
        this.testTargetTile(new Rectangle(6, 0, 4, 6));
    }

    public void testTargetTile01() {
        this.testTargetTile(new Rectangle(0, 6, 6, 6));
    }

    public void testTargetTile11() {
        this.testTargetTile(new Rectangle(6, 6, 4, 6));
    }

    private void testTargetTile(Rectangle expectedRect) {
        TileImpl tile = this.imageFLOAT32.getTile(expectedRect);
        MultiTileImageTileTest.assertNotNull((Object)tile);
        MultiTileImageTileTest.assertSame((Object)this.getBand("B_FLOAT32"), (Object)tile.getRasterDataNode());
        this.testTileStructure(tile, expectedRect, 0, 6, true);
        this.testOnlySamplesFloatAccessible(tile);
        int x0 = tile.getMinX();
        int y0 = tile.getMinY();
        this.testIndexOutOfBoundsException(tile, x0 - 1, y0);
        this.testIndexOutOfBoundsException(tile, x0, y0 - 1);
        this.testIndexOutOfBoundsException(tile, x0 + 6, y0);
        this.testIndexOutOfBoundsException(tile, x0, y0 + 6);
        this.testFloatSample32IO(tile, x0, y0);
        this.testFloatSample32IO(tile, x0 + 3, y0);
        this.testFloatSample32IO(tile, x0, y0 + 3);
        this.testFloatSample32IO(tile, x0 + 3, y0 + 3);
        this.testFloat32RawSampleIO(tile, x0, y0);
        this.testFloat32RawSampleIO(tile, x0 + 3, y0);
        this.testFloat32RawSampleIO(tile, x0, y0 + 3);
        this.testFloat32RawSampleIO(tile, x0 + 3, y0 + 3);
    }

    public void testSourceTileIsContainedInImageTile00() {
        int CHILD_X = 2;
        int CHILD_Y = 3;
        int CHILD_W = 4;
        int CHILD_H = 2;
        Rectangle expectedRect = new Rectangle(2, 3, 4, 2);
        Raster raster = this.getImageData(this.imageFLOAT32, expectedRect);
        TileImpl tile = new TileImpl((RasterDataNode)this.getBand("B_FLOAT32"), raster);
        MultiTileImageTileTest.assertSame((Object)this.getBand("B_FLOAT32"), (Object)tile.getRasterDataNode());
        this.testOnlySamplesFloatAccessible(tile);
        this.testTileStructure(tile, expectedRect, 20, 6, false);
    }

    public void testSourceTileIsNotContainedInAnyImageTile() {
        int CHILD_X = 5;
        int CHILD_Y = 3;
        int CHILD_W = 4;
        int CHILD_H = 7;
        Rectangle expectedRect = new Rectangle(5, 3, 4, 7);
        Raster raster = this.getImageData(this.imageFLOAT32, expectedRect);
        TileImpl tile = new TileImpl((RasterDataNode)this.getBand("B_FLOAT32"), raster);
        MultiTileImageTileTest.assertSame((Object)this.getBand("B_FLOAT32"), (Object)tile.getRasterDataNode());
        this.testOnlySamplesFloatAccessible(tile);
        this.testTileStructure(tile, expectedRect, 0, 4, false);
    }

    private void testIndexOutOfBoundsException(TileImpl tile, int x, int y) {
        try {
            tile.getSampleDouble(x, y);
            MultiTileImageTileTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            tile.setSample(x, y, 0.0);
            MultiTileImageTileTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

