/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.util.HashMap;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.internal.TestOpImage;
import org.esa.snap.core.gpf.internal.TileImpl;

public abstract class AbstractTileImageTileTest
extends TestCase {
    private Product product;
    private HashMap<String, TestOpImage> imageMap;

    protected void setUp() throws Exception {
        Dimension imageSize = this.getImageSize();
        Dimension tileSize = this.getTileSize();
        this.product = new Product("N", "T", imageSize.width, imageSize.height);
        this.product.setPreferredTileSize(tileSize.width, tileSize.height);
        this.product.addBand("B_INT8", 10);
        this.product.addBand("B_UINT8", 20);
        this.product.addBand("B_INT16", 10);
        this.product.addBand("B_UINT16", 20);
        this.product.addBand("B_INT32", 10);
        this.product.addBand("B_UINT32", 20);
        this.product.addBand("B_FLOAT32", 30);
        this.product.addBand("B_FLOAT64", 31);
        this.imageMap = new HashMap();
    }

    protected void tearDown() throws Exception {
        for (TestOpImage testOpImage : this.imageMap.values()) {
            testOpImage.dispose();
        }
        this.imageMap.clear();
        this.product.dispose();
        this.product = null;
    }

    public abstract Dimension getImageSize();

    public abstract Dimension getTileSize();

    public abstract int getTileCount();

    public Product getProduct() {
        return this.product;
    }

    public Band getBand(String name) {
        return this.product.getBand(name);
    }

    public TestOpImage getImage(String name) {
        Band band = this.getBand(name);
        AbstractTileImageTileTest.assertNotNull((Object)band);
        TestOpImage image = this.imageMap.get(name);
        if (image == null) {
            image = new TestOpImage(band);
            Raster[] rasters = image.getTiles();
            AbstractTileImageTileTest.assertNotNull((Object)rasters);
            AbstractTileImageTileTest.assertEquals((int)this.getTileCount(), (int)rasters.length);
            this.imageMap.put(name, image);
            Dimension tileSize = this.getTileSize();
            AbstractTileImageTileTest.assertEquals((int)tileSize.width, (int)image.getSampleModel().getWidth());
            AbstractTileImageTileTest.assertEquals((int)tileSize.height, (int)image.getSampleModel().getHeight());
        }
        return image;
    }

    protected void testTileStructure(TileImpl tile, Rectangle expectedRect, int expectedScanlineOffset, int expectedScanlineStride, boolean expectedTarget) {
        AbstractTileImageTileTest.assertEquals((Object)expectedRect, (Object)tile.getRectangle());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.x, (int)tile.getMinX());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.y, (int)tile.getMinY());
        AbstractTileImageTileTest.assertEquals((int)(expectedRect.x + expectedRect.width - 1), (int)tile.getMaxX());
        AbstractTileImageTileTest.assertEquals((int)(expectedRect.y + expectedRect.height - 1), (int)tile.getMaxY());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.width, (int)tile.getWidth());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.height, (int)tile.getHeight());
        AbstractTileImageTileTest.assertEquals((int)expectedScanlineStride, (int)tile.getScanlineStride());
        AbstractTileImageTileTest.assertEquals((int)expectedScanlineOffset, (int)tile.getScanlineOffset());
        AbstractTileImageTileTest.assertEquals((boolean)expectedTarget, (boolean)tile.isTarget());
    }

    protected Raster getImageData(TestOpImage image, Rectangle expectedRect) {
        Raster raster = image.getData(expectedRect);
        AbstractTileImageTileTest.assertEquals((int)expectedRect.x, (int)raster.getMinX());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.y, (int)raster.getMinY());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.width, (int)raster.getWidth());
        AbstractTileImageTileTest.assertEquals((int)expectedRect.height, (int)raster.getHeight());
        return raster;
    }

    protected void testOnlySamplesFloatAccessible(TileImpl tile) {
        AbstractTileImageTileTest.assertNull((Object)tile.getDataBufferByte());
        AbstractTileImageTileTest.assertNull((Object)tile.getDataBufferShort());
        AbstractTileImageTileTest.assertNull((Object)tile.getDataBufferInt());
        AbstractTileImageTileTest.assertNotNull((Object)tile.getDataBufferFloat());
        AbstractTileImageTileTest.assertNull((Object)tile.getDataBufferDouble());
    }

    protected void testFloatSample32IO(TileImpl tile, int x0, int y0) {
        tile.setSample(x0, y0, false);
        AbstractTileImageTileTest.assertEquals((boolean)false, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)0, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)0.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((double)0.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, true);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)1, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)1.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((double)1.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, 1234);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)1234, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)1234.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((double)1234.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, 67.89f);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)67, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)67.89f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((double)67.89, (double)tile.getSampleDouble(x0, y0), (double)1.0E-5);
        tile.setSample(x0, y0, 12.34567890123);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)12, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)12.345679f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((double)12.345679, (double)tile.getSampleDouble(x0, y0), (double)1.0E-5);
    }

    protected void testFloat64IO(TileImpl tile, int x0, int y0) {
        tile.setSample(x0, y0, false);
        AbstractTileImageTileTest.assertEquals((boolean)false, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)0, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)0.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-10f);
        AbstractTileImageTileTest.assertEquals((double)0.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, true);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)1, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)1.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-10f);
        AbstractTileImageTileTest.assertEquals((double)1.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, 1234);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)1234, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)1234.0f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-10f);
        AbstractTileImageTileTest.assertEquals((double)1234.0, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, 67.89f);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)68, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)67.89f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-10f);
        AbstractTileImageTileTest.assertEquals((double)67.89, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
        tile.setSample(x0, y0, 12.34567890123);
        AbstractTileImageTileTest.assertEquals((boolean)true, (boolean)tile.getSampleBoolean(x0, y0));
        AbstractTileImageTileTest.assertEquals((int)12, (int)tile.getSampleInt(x0, y0));
        AbstractTileImageTileTest.assertEquals((float)12.3456f, (float)tile.getSampleFloat(x0, y0), (float)1.0E-10f);
        AbstractTileImageTileTest.assertEquals((double)12.34567890123, (double)tile.getSampleDouble(x0, y0), (double)1.0E-10);
    }

    protected void testFloat32RawSampleIO(TileImpl tile, int x, int y) {
        ProductData samplesGeneric = tile.getDataBuffer();
        AbstractTileImageTileTest.assertNotNull((Object)samplesGeneric);
        float[] samplesFloat = tile.getDataBufferFloat();
        AbstractTileImageTileTest.assertNotNull((Object)samplesFloat);
        AbstractTileImageTileTest.assertSame((Object)samplesFloat, (Object)samplesGeneric.getElems());
        int lineOffset = tile.getScanlineOffset();
        int lineStride = tile.getScanlineStride();
        int index = lineOffset + (y - tile.getMinY()) * lineStride + (x - tile.getMinX());
        AbstractTileImageTileTest.assertTrue((index >= 0 ? 1 : 0) != 0);
        AbstractTileImageTileTest.assertTrue((index < samplesFloat.length ? 1 : 0) != 0);
        AbstractTileImageTileTest.assertTrue((index < samplesGeneric.getNumElems() ? 1 : 0) != 0);
        AbstractTileImageTileTest.assertEquals((int)index, (int)tile.getDataBufferIndex(x, y));
        samplesFloat[index] = 1234.56f;
        AbstractTileImageTileTest.assertEquals((float)1234.56f, (float)samplesFloat[index], (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)1234.56f, (float)samplesGeneric.getElemFloatAt(index), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)1234.56f, (float)tile.getSampleFloat(x, y), (float)1.0E-5f);
        samplesGeneric.setElemFloatAt(index, 213.536f);
        AbstractTileImageTileTest.assertEquals((float)213.536f, (float)samplesFloat[index], (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)213.536f, (float)samplesGeneric.getElemFloatAt(index), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)213.536f, (float)tile.getSampleFloat(x, y), (float)1.0E-5f);
        samplesGeneric.setElemIntAt(index, 707);
        AbstractTileImageTileTest.assertEquals((float)707.0f, (float)samplesFloat[index], (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)707.0f, (float)samplesGeneric.getElemFloatAt(index), (float)1.0E-5f);
        AbstractTileImageTileTest.assertEquals((float)707.0f, (float)tile.getSampleFloat(x, y), (float)1.0E-5f);
    }
}

