/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;

public class TargetProductAnnotationValidationTest
extends TestCase {
    private OperatorSpi notInitTargetProductOpSPI;

    protected void setUp() throws Exception {
        this.notInitTargetProductOpSPI = new NotInitOutputOperator.Spi();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(this.notInitTargetProductOpSPI);
    }

    protected void tearDown() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi(this.notInitTargetProductOpSPI);
    }

    public void testTargetProductIsSetByAnnotation() throws GraphException {
        Graph graph = new Graph("graph");
        Node node = new Node("OutputNotSet", this.notInitTargetProductOpSPI.getOperatorAlias());
        graph.addNode(node);
        GraphContext graphContext = new GraphContext(graph);
        NodeContext nodeContext = graphContext.getNodeContext(node);
        NotInitOutputOperator notInitOutputOperator = (NotInitOutputOperator)nodeContext.getOperator();
        TargetProductAnnotationValidationTest.assertNotNull((String)"Output of operator is null", (Object)notInitOutputOperator.output);
        TargetProductAnnotationValidationTest.assertSame((Object)nodeContext.getTargetProduct(), (Object)notInitOutputOperator.output);
    }

    @OperatorMetadata(alias="NotInitOutputOperator")
    public static class NotInitOutputOperator
    extends Operator {
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(NotInitOutputOperator.class);
            }
        }
    }
}

