/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;

public class SourceProductsAnnotationValidationTest
extends TestCase {
    private OperatorSpi someOpSpi;
    private OperatorSpi twoSourcesOpSpi;
    private OperatorSpi anySourcesOpSpi;
    private OptSourcesOp.Spi optSourcesOpSpi;

    protected void setUp() throws Exception {
        this.someOpSpi = new InputOp.Spi();
        this.twoSourcesOpSpi = new TwoSourcesOp.Spi();
        this.anySourcesOpSpi = new AnySourcesOp.Spi();
        this.optSourcesOpSpi = new OptSourcesOp.Spi();
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.addOperatorSpi(this.someOpSpi);
        registry.addOperatorSpi(this.twoSourcesOpSpi);
        registry.addOperatorSpi(this.anySourcesOpSpi);
        registry.addOperatorSpi((OperatorSpi)this.optSourcesOpSpi);
    }

    protected void tearDown() {
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.removeOperatorSpi(this.someOpSpi);
        registry.removeOperatorSpi(this.twoSourcesOpSpi);
        registry.removeOperatorSpi(this.anySourcesOpSpi);
        registry.removeOperatorSpi((OperatorSpi)this.optSourcesOpSpi);
    }

    public void testTwoSourcesOp() {
        String opName = "TwoSourcesOp";
        Graph graph = this.createTestGraph("TwoSourcesOp");
        try {
            new GraphContext(graph);
            SourceProductsAnnotationValidationTest.fail((String)"GraphException expected, need exactly 2 sources");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        graph = this.createTestGraph("TwoSourcesOp");
        Node outputNode = graph.getNode("output");
        outputNode.addSource(new NodeSource("dummy", "input1"));
        try {
            new GraphContext(graph);
            SourceProductsAnnotationValidationTest.fail((String)"GraphException expected, need exactly 2 sources");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        graph = this.createTestGraph("TwoSourcesOp");
        outputNode = graph.getNode("output");
        outputNode.addSource(new NodeSource("dummy1", "input1"));
        outputNode.addSource(new NodeSource("dummy2", "input2"));
        try {
            new GraphContext(graph);
        }
        catch (GraphException ge) {
            SourceProductsAnnotationValidationTest.fail((String)("GraphException not expected, exactly 2 sources given. Error: " + ge.getMessage()));
        }
        graph = this.createTestGraph("TwoSourcesOp");
        outputNode = graph.getNode("output");
        outputNode.addSource(new NodeSource("dummy1", "input1"));
        outputNode.addSource(new NodeSource("dummy2", "input2"));
        outputNode.addSource(new NodeSource("dummy3", "input3"));
        try {
            new GraphContext(graph);
            SourceProductsAnnotationValidationTest.fail((String)"GraphException expected, need exactly 2 sources");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testAnySourcesOp() {
        String opName = "AnySourcesOp";
        Graph graph = this.createTestGraph("AnySourcesOp");
        try {
            new GraphContext(graph);
            SourceProductsAnnotationValidationTest.fail((String)"GraphException expected, at least one source expected");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        graph = this.createTestGraph("AnySourcesOp");
        Node outputNode = graph.getNode("output");
        outputNode.addSource(new NodeSource("dummy1", "input1"));
        outputNode.addSource(new NodeSource("dummy2", "input2"));
        outputNode.addSource(new NodeSource("dummy3", "input3"));
        try {
            new GraphContext(graph);
        }
        catch (GraphException ge) {
            SourceProductsAnnotationValidationTest.fail((String)("GraphException not expected, any number of sources allowed. Error: " + ge.getMessage()));
        }
    }

    public void testOptSourcesOp() {
        String opName = "OptSourcesOp";
        Graph graph = this.createTestGraph("OptSourcesOp");
        try {
            new GraphContext(graph);
        }
        catch (GraphException ge) {
            SourceProductsAnnotationValidationTest.fail((String)("GraphException not expected, sources not checked. Error: " + ge.getMessage()));
        }
        graph = this.createTestGraph("OptSourcesOp");
        Node outputNode = graph.getNode("output");
        outputNode.addSource(new NodeSource("dummy1", "input1"));
        outputNode.addSource(new NodeSource("dummy2", "input2"));
        outputNode.addSource(new NodeSource("dummy3", "input3"));
        try {
            new GraphContext(graph);
        }
        catch (GraphException ge) {
            SourceProductsAnnotationValidationTest.fail((String)("GraphException not expected, sources not checked. Error: " + ge.getMessage()));
        }
    }

    private Graph createTestGraph(String opName) {
        Graph graph = new Graph("graph");
        Node input1Node = new Node("input1", "InputOp");
        Node input2Node = new Node("input2", "InputOp");
        Node input3Node = new Node("input3", "InputOp");
        Node outputNode = new Node("output", opName);
        graph.addNode(input1Node);
        graph.addNode(input2Node);
        graph.addNode(input3Node);
        graph.addNode(outputNode);
        return graph;
    }

    @OperatorMetadata(alias="OptSourcesOp")
    public static class OptSourcesOp
    extends Operator {
        @SourceProducts
        Product[] inputs;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(OptSourcesOp.class);
            }
        }
    }

    @OperatorMetadata(alias="AnySourcesOp")
    public static class AnySourcesOp
    extends Operator {
        @SourceProducts(count=-1)
        Product[] inputs;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(AnySourcesOp.class);
            }
        }
    }

    @OperatorMetadata(alias="TwoSourcesOp")
    public static class TwoSourcesOp
    extends Operator {
        @SourceProducts(count=2)
        Product[] inputs;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(TwoSourcesOp.class);
            }
        }
    }

    @OperatorMetadata(alias="InputOp")
    public static class InputOp
    extends Operator {
        @TargetProduct
        private Product targetProduct;

        public void initialize() throws OperatorException {
            this.targetProduct = new Product("input", "inputType", 1, 1);
            this.targetProduct.addBand("a", 10);
            this.targetProduct.addBand("b", 10);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(InputOp.class);
            }
        }
    }
}

