/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.junit.Assert;
import org.junit.Test;

public class NodeTest {
    @Test
    public void testAddSource() throws Exception {
        Node node = new Node("myId", "opName");
        node.addSource(new NodeSource("nodeName", "source1"));
        Assert.assertEquals((long)1L, (long)node.getSources().length);
        Assert.assertEquals((Object)"nodeName", (Object)node.getSources()[0].getName());
        node.addSource(new NodeSource("anotherName", "source2"));
        node.addSource(new NodeSource("thirdName", "source3"));
        Assert.assertEquals((long)3L, (long)node.getSources().length);
        Assert.assertEquals((Object)"nodeName", (Object)node.getSources()[0].getName());
        Assert.assertEquals((Object)"anotherName", (Object)node.getSources()[1].getName());
        Assert.assertEquals((Object)"thirdName", (Object)node.getSources()[2].getName());
    }

    @Test
    public void testRemoveSource() throws Exception {
        Node baseNode = new Node("myId", "opName");
        NodeSource node1 = new NodeSource("nodeName", "source1");
        NodeSource node2 = new NodeSource("anotherName", "source2");
        NodeSource node3 = new NodeSource("thirdName", "source3");
        baseNode.addSource(node1);
        baseNode.addSource(node2);
        baseNode.addSource(node3);
        Assert.assertEquals((long)3L, (long)baseNode.getSources().length);
        baseNode.removeSource(node2);
        Assert.assertEquals((long)2L, (long)baseNode.getSources().length);
        Assert.assertEquals((Object)"nodeName", (Object)baseNode.getSources()[0].getName());
        Assert.assertEquals((Object)"thirdName", (Object)baseNode.getSources()[1].getName());
        baseNode.removeSource(node1);
        baseNode.removeSource(node3);
        Assert.assertEquals((long)0L, (long)baseNode.getSources().length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicatedSourceNodeNameNotAllowed() throws Exception {
        Node node = new Node("myId", "opName");
        node.addSource(new NodeSource("duplicated", "sourceNode1"));
        node.addSource(new NodeSource("sameId", "sourceNode1"));
    }
}

