/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.util.jai.VerbousTileCache;

public class GraphProcessorTest
extends TestCase {
    private OperatorSpi spi1;
    private OperatorSpi spi2;
    private OperatorSpi spi3;
    private TileCache jaiTileCache;
    private TileCache testTileCache;

    protected void setUp() throws Exception {
        this.jaiTileCache = JAI.getDefaultInstance().getTileCache();
        this.testTileCache = new VerbousTileCache(this.jaiTileCache);
        JAI.getDefaultInstance().setTileCache(this.testTileCache);
        this.testTileCache.flush();
        TestOps.clearCalls();
        this.spi1 = new TestOps.Op1.Spi();
        this.spi2 = new TestOps.Op2.Spi();
        this.spi3 = new TestOps.Op3.Spi();
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.addOperatorSpi(this.spi1);
        registry.addOperatorSpi(this.spi2);
        registry.addOperatorSpi(this.spi3);
    }

    protected void tearDown() throws Exception {
        this.testTileCache.flush();
        JAI.getDefaultInstance().setTileCache(this.jaiTileCache);
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        spiRegistry.removeOperatorSpi(this.spi1);
        spiRegistry.removeOperatorSpi(this.spi2);
        spiRegistry.removeOperatorSpi(this.spi3);
    }

    public void testTwoOpsExecutionOrder() throws Exception {
        GraphProcessor processor = new GraphProcessor();
        Graph graph = new Graph("chain1");
        Node node1 = new Node("node1", "Op1");
        Node node2 = new Node("node2", "Op2");
        node2.addSource(new NodeSource("input", "node1"));
        graph.addNode(node1);
        graph.addNode(node2);
        GraphContext graphContext = new GraphContext(graph);
        Product chainOut = processor.executeGraph(graphContext, ProgressMonitor.NULL)[0];
        GraphProcessorTest.assertNotNull((Object)chainOut);
        GraphProcessorTest.assertEquals((String)"Op2Name", (String)chainOut.getName());
        GraphProcessorTest.assertEquals((String)"Op1;Op2;", (String)TestOps.getCalls());
        TestOps.clearCalls();
    }

    public void testThreeOpsExecutionOrder() throws Exception {
        VerbousTileCache.setVerbous((boolean)false);
        Graph graph = new Graph("graph");
        Node node1 = new Node("node1", "Op1");
        Node node2 = new Node("node2", "Op2");
        Node node3 = new Node("node3", "Op3");
        node2.addSource(new NodeSource("input", "node1"));
        node3.addSource(new NodeSource("input1", "node1"));
        node3.addSource(new NodeSource("input2", "node2"));
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = new GraphContext(graph);
        Product chainOut = graphContext.getOutputProducts()[0];
        GraphProcessorTest.assertNotNull((Object)chainOut);
        GraphProcessorTest.assertEquals((String)"Op3Name", (String)chainOut.getName());
        processor.executeGraph(graphContext, ProgressMonitor.NULL);
        GraphProcessorTest.assertEquals((String)"Op1;Op2;Op3;", (String)TestOps.getCalls());
        TestOps.clearCalls();
        VerbousTileCache.setVerbous((boolean)false);
    }
}

