/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.media.jai.JAI;
import javax.media.jai.TileScheduler;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GraphProcessingObserverTest {
    private static OpMock.Spi opMockSpi = new OpMock.Spi();
    private int oldParallelism;

    @Before
    public void setUp() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)opMockSpi);
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        this.oldParallelism = tileScheduler.getParallelism();
        tileScheduler.setParallelism(Runtime.getRuntime().availableProcessors());
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)opMockSpi);
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        tileScheduler.setParallelism(this.oldParallelism);
    }

    @Test
    public void testAddingOberserverToChain() throws GraphException {
        GraphProcessor processor = new GraphProcessor();
        GraphProcessingObserver[] observers = processor.getObservers();
        Assert.assertNotNull((Object)observers);
        Assert.assertEquals((long)0L, (long)observers.length);
        GraphProcessingObserverMock observerMock = new GraphProcessingObserverMock();
        processor.addObserver((GraphProcessingObserver)observerMock);
        observers = processor.getObservers();
        Assert.assertNotNull((Object)observers);
        Assert.assertEquals((long)1L, (long)observers.length);
        Assert.assertSame((Object)observerMock, (Object)observers[0]);
        Graph graph = new Graph("test-graph");
        graph.addNode(new Node("a", OpMock.Spi.class.getName()));
        processor.executeGraph(graph, ProgressMonitor.NULL);
        Assert.assertEquals((long)6L, (long)observerMock.entries.size());
        Assert.assertEquals((Object)"graph [test-graph] started", (Object)observerMock.entries.get(0));
        Assert.assertEquals((Object)"tile java.awt.Rectangle[x=0,y=0,width=10,height=5] started", (Object)observerMock.entries.get(1));
        Assert.assertEquals((Object)"tile java.awt.Rectangle[x=0,y=0,width=10,height=5] stopped", (Object)observerMock.entries.get(2));
        Assert.assertEquals((Object)"tile java.awt.Rectangle[x=0,y=5,width=10,height=5] started", (Object)observerMock.entries.get(3));
        Assert.assertEquals((Object)"tile java.awt.Rectangle[x=0,y=5,width=10,height=5] stopped", (Object)observerMock.entries.get(4));
        Assert.assertEquals((Object)"graph [test-graph] stopped", (Object)observerMock.entries.get(5));
    }

    static class GraphProcessingObserverMock
    implements GraphProcessingObserver {
        ArrayList<String> entries = new ArrayList();

        GraphProcessingObserverMock() {
        }

        public void graphProcessingStarted(GraphContext graphContext) {
            this.ralla("graph [" + graphContext.getGraph().getId() + "] started");
        }

        private void ralla(String m) {
            this.entries.add(m);
        }

        public void graphProcessingStopped(GraphContext graphContext) {
            this.ralla("graph [" + graphContext.getGraph().getId() + "] stopped");
        }

        public void tileProcessingStarted(GraphContext graphContext, Rectangle tileRectangle) {
            this.ralla("tile " + tileRectangle + " started");
        }

        public void tileProcessingStopped(GraphContext graphContext, Rectangle tileRectangle) {
            this.ralla("tile " + tileRectangle + " stopped");
        }
    }

    @OperatorMetadata(alias="OpMock")
    public static class OpMock
    extends Operator {
        @TargetProduct
        private Product product;

        public void initialize() throws OperatorException {
            this.product = new Product(((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName(), 10, 10);
            this.product.addBand("band_1", 12);
            this.product.setPreferredTileSize(new Dimension(10, 5));
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            System.out.println("OpMock.computeTile");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(OpMock.class);
            }
        }
    }
}

