/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.experimental;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Ignore;

@Ignore
public class JaiTileSchedulerTest {
    public static void main(String[] args) {
        JaiTileSchedulerTest.scheduleTiles(0);
        JaiTileSchedulerTest.scheduleTiles(1);
        JaiTileSchedulerTest.scheduleTiles(2);
        JaiTileSchedulerTest.scheduleTiles(4);
        JaiTileSchedulerTest.scheduleTiles(8);
    }

    private static void scheduleTiles(int sleepTime) {
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileWidth(512);
        imageLayout.setTileHeight(512);
        RenderedOp op = ConstantDescriptor.create((Float)Float.valueOf(1024.0f), (Float)Float.valueOf(1024.0f), (Number[])new Short[]{(short)1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        MyTileComputationListener listener = new MyTileComputationListener();
        for (int i = 0; i < 1000; ++i) {
            tileScheduler.scheduleTiles((PlanarImage)op, new Point[]{new Point(0, 0)}, new TileComputationListener[]{listener});
            if (sleepTime <= 0) continue;
            JaiTileSchedulerTest.sleep(sleepTime);
        }
        JaiTileSchedulerTest.sleep(100L);
        System.out.println("scheduleTiles(sleepTime = " + sleepTime + "):");
        System.out.println("  Tiles computed: " + listener.computed);
        System.out.println("  Tiles cancelled: " + listener.cancelled);
        System.out.println("  Tile computation failures: " + listener.computationFailures);
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class MyTileComputationListener
    implements TileComputationListener {
        int computed;
        int cancelled;
        int computationFailures;

        private MyTileComputationListener() {
        }

        public void tileComputed(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int i, int i1, Raster raster) {
            ++this.computed;
        }

        public void tileCancelled(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int i, int i1) {
            ++this.cancelled;
        }

        public void tileComputationFailure(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int i, int i1, Throwable throwable) {
            ++this.computationFailures;
        }
    }
}

