/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import junit.framework.Assert;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.common.resample.DoubleDataInterpolator;
import org.junit.Before;
import org.junit.Test;

public class DoubleDataInterpolatorTest {
    private DoubleDataInterpolator.CubicConvolution cubicConvolutionInterpolator;
    private int srcOffset;
    private int srcScanlineStride;
    private Raster vbData;

    @Before
    public void setup() {
        this.cubicConvolutionInterpolator = new DoubleDataInterpolator.CubicConvolution();
        Product product = new Product("product", "type", 4, 4);
        VirtualBand vb = new VirtualBand("vb", 31, 4, 4, "((Y - 0.5) * 4) + (X - 0.5)");
        product.addBand((Band)vb);
        RasterFormatTag[] compatibleTags = RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{vb.getSourceImage()}, (RenderedImage)vb.getSourceImage());
        this.vbData = vb.getSourceImage().getData();
        RasterAccessor accessor = new RasterAccessor(this.vbData, new Rectangle(4, 4), compatibleTags[0], null);
        this.cubicConvolutionInterpolator.init(accessor, accessor, Double.NaN);
        this.srcScanlineStride = accessor.getScanlineStride();
        this.srcOffset = accessor.getBandOffset(0);
    }

    @Test
    public void testCubicConvolution_GetValidRectangle_1_1() {
        int srcIndexY = this.srcOffset + this.srcScanlineStride;
        double[][] validRectangle = this.cubicConvolutionInterpolator.getValidRectangle(1, 1, srcIndexY, 4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)this.vbData.getSampleDouble(i, j, 0), (double)validRectangle[i][j], (double)1.0E-8);
            }
        }
    }

    @Test
    public void testCubicConvolution_GetValidRectangle_0_0() {
        int srcIndexY = this.srcOffset;
        double[][] validRectangle = this.cubicConvolutionInterpolator.getValidRectangle(0, 0, srcIndexY, 4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)this.vbData.getSampleDouble(Math.max(0, i - 1), Math.max(0, j - 1), 0), (double)validRectangle[i][j], (double)1.0E-8);
            }
        }
    }

    @Test
    public void testCubicConvolution_GetValidRectangle_3_0() {
        int srcIndexY = this.srcOffset;
        double[][] validRectangle = this.cubicConvolutionInterpolator.getValidRectangle(3, 0, srcIndexY, 4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)this.vbData.getSampleDouble(Math.min(3, i + 2), Math.max(0, j - 1), 0), (double)validRectangle[i][j], (double)1.0E-8);
            }
        }
    }

    @Test
    public void testCubicConvolution_GetValidRectangle_0_3() {
        int srcIndexY = this.srcOffset + 3 * this.srcScanlineStride;
        double[][] validRectangle = this.cubicConvolutionInterpolator.getValidRectangle(0, 3, srcIndexY, 4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)this.vbData.getSampleDouble(Math.max(0, i - 1), Math.min(3, j + 2), 0), (double)validRectangle[i][j], (double)1.0E-8);
            }
        }
    }

    @Test
    public void testCubicConvolution_GetValidRectangle_3_3() {
        int srcIndexY = this.srcOffset + 3 * this.srcScanlineStride;
        double[][] validRectangle = this.cubicConvolutionInterpolator.getValidRectangle(3, 3, srcIndexY, 4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)this.vbData.getSampleDouble(Math.min(3, i + 2), Math.min(3, j + 2), 0), (double)validRectangle[i][j], (double)1.0E-8);
            }
        }
    }
}

