/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.common.resample.AggregatedOpImage;
import org.esa.snap.core.gpf.common.resample.AggregationType;
import org.esa.snap.core.image.ImageManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatedOpImageTest_Flags {
    private Band referenceBand;
    private AffineTransform sourceTransform;
    private double noDataValue;

    @Before
    public void setUp() {
        final int referenceWidth = 2;
        final int referenceHeight = 2;
        int referenceScaleX = 4;
        int referenceScaleY = 4;
        int referenceTranslateX = 4;
        int referenceTranslateY = 4;
        int referenceLevelCount = 2;
        AffineTransform imageToModelTransform = new AffineTransform(referenceScaleX, 0.0f, 0.0f, referenceScaleY, referenceTranslateX, referenceTranslateY);
        this.referenceBand = new Band("referenceBand", 10, referenceWidth, referenceHeight);
        DefaultMultiLevelModel referenceModel = new DefaultMultiLevelModel(referenceLevelCount, imageToModelTransform, referenceWidth, referenceHeight);
        this.referenceBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource((MultiLevelModel)referenceModel){

            protected RenderedImage createImage(int level) {
                return new BufferedImage(referenceWidth / (1 + level), referenceHeight / (1 + level), 10);
            }
        }));
        this.sourceTransform = new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f);
        this.noDataValue = 117.0;
    }

    @Test
    public void testFlagAnd() throws NoninvertibleTransformException {
        short[] sourceData = new short[]{5, 1, 2, 3, 9, 6, 3, 2, 7, 5, 7, 1, 7, 5, 9, 5};
        short[] expectedData = new short[]{0, 0, 1, 5};
        RenderedImage sourceImage = AggregatedOpImageTest_Flags.createSourceImage(sourceData);
        ImageLayout imageLayout = this.createImageLayout(sourceImage);
        AggregatedOpImage image = new AggregatedOpImage(sourceImage, imageLayout, this.noDataValue, AggregationType.FlagAnd, 21, this.sourceTransform, this.referenceBand.getImageToModelTransform());
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((long)2L, (long)image.getWidth());
        Assert.assertEquals((long)2L, (long)image.getHeight());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)image.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagOr() throws NoninvertibleTransformException {
        short[] sourceData = new short[]{5, 1, 2, 3, 9, 6, 3, 2, 7, 5, 7, 1, 7, 5, 9, 5};
        short[] expectedData = new short[]{7, 3, 13, 5};
        RenderedImage sourceImage = AggregatedOpImageTest_Flags.createSourceImage(sourceData);
        ImageLayout imageLayout = this.createImageLayout(sourceImage);
        AggregatedOpImage image = new AggregatedOpImage(sourceImage, imageLayout, this.noDataValue, AggregationType.FlagOr, 21, this.sourceTransform, this.referenceBand.getImageToModelTransform());
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((long)2L, (long)image.getWidth());
        Assert.assertEquals((long)2L, (long)image.getHeight());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)image.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagMedianAnd() throws NoninvertibleTransformException {
        short[] sourceData = new short[]{5, 1, 2, 3, 9, 6, 3, 2, 7, 5, 7, 1, 7, 5, 9, 5};
        short[] expectedData = new short[]{7, 0, 1, 5};
        RenderedImage sourceImage = AggregatedOpImageTest_Flags.createSourceImage(sourceData);
        ImageLayout imageLayout = this.createImageLayout(sourceImage);
        AggregatedOpImage image = new AggregatedOpImage(sourceImage, imageLayout, this.noDataValue, AggregationType.FlagMedianAnd, 21, this.sourceTransform, this.referenceBand.getImageToModelTransform());
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((long)2L, (long)image.getWidth());
        Assert.assertEquals((long)2L, (long)image.getHeight());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)image.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagMedianOr() throws NoninvertibleTransformException {
        short[] sourceData = new short[]{5, 1, 2, 3, 9, 6, 3, 2, 7, 5, 7, 1, 7, 5, 9, 5};
        short[] expectedData = new short[]{7, 3, 13, 5};
        RenderedImage sourceImage = AggregatedOpImageTest_Flags.createSourceImage(sourceData);
        ImageLayout imageLayout = this.createImageLayout(sourceImage);
        AggregatedOpImage image = new AggregatedOpImage(sourceImage, imageLayout, this.noDataValue, AggregationType.FlagMedianOr, 21, this.sourceTransform, this.referenceBand.getImageToModelTransform());
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((long)2L, (long)image.getWidth());
        Assert.assertEquals((long)2L, (long)image.getHeight());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)image.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    private ImageLayout createImageLayout(RenderedImage sourceImage) {
        int dataType = sourceImage.getSampleModel().getDataType();
        return ImageManager.createSingleBandedImageLayout((int)dataType, (int)this.referenceBand.getRasterWidth(), (int)this.referenceBand.getRasterHeight(), (int)this.referenceBand.getRasterWidth(), (int)this.referenceBand.getRasterHeight());
    }

    static RenderedImage createSourceImage(short[] data) {
        int widthAndHeight = (int)Math.sqrt(data.length);
        BufferedImage image = new BufferedImage(widthAndHeight, widthAndHeight, 11);
        DataBufferUShort buffer = (DataBufferUShort)image.getRaster().getDataBuffer();
        System.arraycopy(data, 0, buffer.getData(), 0, widthAndHeight * widthAndHeight);
        return image;
    }
}

