/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.resample.AggregatedOpImage;
import org.esa.snap.core.gpf.common.resample.AggregationType;
import org.esa.snap.core.image.ImageManager;
import org.junit.Before;
import org.junit.Test;

public class AggregatedOpImageTest {
    private Band referenceBand;

    @Before
    public void setUp() {
        final int referenceWidth = 2;
        final int referenceHeight = 2;
        int referenceScaleX = 4;
        int referenceScaleY = 4;
        int referenceTranslateX = 4;
        int referenceTranslateY = 4;
        int referenceLevelCount = 2;
        AffineTransform imageToModelTransform = new AffineTransform(referenceScaleX, 0.0f, 0.0f, referenceScaleY, referenceTranslateX, referenceTranslateY);
        this.referenceBand = new Band("referenceBand", 10, referenceWidth, referenceHeight);
        DefaultMultiLevelModel referenceModel = new DefaultMultiLevelModel(referenceLevelCount, imageToModelTransform, referenceWidth, referenceHeight);
        this.referenceBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource((MultiLevelModel)referenceModel){

            protected RenderedImage createImage(int level) {
                return new BufferedImage(referenceWidth / (1 + level), referenceHeight / (1 + level), 10);
            }
        }));
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Double_Mean() throws Exception {
        this.test_mean(31);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Double_Median() throws Exception {
        this.test_median(31);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Double_Min() throws Exception {
        this.test_min(31);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Double_Max() throws Exception {
        this.test_max(31);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Double_First() throws Exception {
        this.test_first(31);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Float_Mean() throws Exception {
        this.test_mean(30);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Float_Median() throws Exception {
        this.test_median(30);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Float_Min() throws Exception {
        this.test_min(30);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Float_Max() throws Exception {
        this.test_max(30);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Float_First() throws Exception {
        this.test_first(30);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Mean_Byte() throws Exception {
        this.test_mean(10);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Byte_Median() throws Exception {
        this.test_median(10);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Byte_Min() throws Exception {
        this.test_min(10);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Byte_Max() throws Exception {
        this.test_max(10);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Byte_First() throws Exception {
        this.test_first(10);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Mean_Short() throws Exception {
        this.test_mean(11);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Short_Median() throws Exception {
        this.test_median(11);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Short_Min() throws Exception {
        this.test_min(11);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Short_Max() throws Exception {
        this.test_max(11);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Short_First() throws Exception {
        this.test_first(11);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Int_Mean() throws Exception {
        this.test_mean(12);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Int_Median() throws Exception {
        this.test_median(12);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Int_Min() throws Exception {
        this.test_min(12);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Int_Max() throws Exception {
        this.test_max(12);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Int_First() throws Exception {
        this.test_first(12);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_UShort_Mean() throws Exception {
        this.test_mean(21);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_UShort_Median() throws Exception {
        this.test_median(21);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_UShort_Min() throws Exception {
        this.test_min(21);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_UShort_Max() throws Exception {
        this.test_max(21);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_UShort_First() throws Exception {
        this.test_first(21);
    }

    private void test_mean(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = ImageManager.getDataBufferType((int)dataType);
        ImageLayout imageLayout = this.createImageLayout(sourceBand);
        AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), AggregationType.Mean, dataBufferType, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)2, (int)image.getWidth());
        Assert.assertEquals((int)2, (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster imageData = image.getData();
        if (dataType != 30 && dataType != 31) {
            Assert.assertEquals((double)7.0, (double)imageData.getSample(0, 0, 0), (double)1.0E-8);
            Assert.assertEquals((double)9.0, (double)imageData.getSample(0, 1, 0), (double)1.0E-8);
            Assert.assertEquals((double)13.0, (double)imageData.getSample(1, 0, 0), (double)1.0E-8);
            Assert.assertEquals((double)15.0, (double)imageData.getSample(1, 1, 0), (double)1.0E-8);
        } else {
            Assert.assertEquals((double)7.5, (double)imageData.getSampleDouble(0, 0, 0), (double)1.0E-8);
            Assert.assertEquals((double)9.0, (double)imageData.getSampleDouble(0, 1, 0), (double)1.0E-8);
            Assert.assertEquals((double)13.5, (double)imageData.getSampleDouble(1, 0, 0), (double)1.0E-8);
            Assert.assertEquals((double)15.0, (double)imageData.getSampleDouble(1, 1, 0), (double)1.0E-8);
        }
    }

    private void test_median(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand_Median(dataType);
        int dataBufferType = ImageManager.getDataBufferType((int)dataType);
        ImageLayout imageLayout = this.createImageLayout(sourceBand);
        AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), AggregationType.Median, dataBufferType, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)2, (int)image.getWidth());
        Assert.assertEquals((int)2, (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster imageData = image.getData();
        Assert.assertEquals((double)6.0, (double)imageData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)imageData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)imageData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)16.0, (double)imageData.getSampleDouble(1, 1, 0), (double)1.0E-8);
    }

    private void test_min(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = ImageManager.getDataBufferType((int)dataType);
        ImageLayout imageLayout = this.createImageLayout(sourceBand);
        AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), AggregationType.Min, dataBufferType, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)2, (int)image.getWidth());
        Assert.assertEquals((int)2, (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster imageData = image.getData();
        Assert.assertEquals((double)5.0, (double)imageData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)7.0, (double)imageData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)13.0, (double)imageData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData.getSampleDouble(1, 1, 0), (double)1.0E-8);
    }

    private void test_max(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = ImageManager.getDataBufferType((int)dataType);
        ImageLayout imageLayout = this.createImageLayout(sourceBand);
        AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), AggregationType.Max, dataBufferType, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)2, (int)image.getWidth());
        Assert.assertEquals((int)2, (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster imageData = image.getData();
        Assert.assertEquals((double)10.0, (double)imageData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)11.0, (double)imageData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)14.0, (double)imageData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData.getSampleDouble(1, 1, 0), (double)1.0E-8);
    }

    private void test_first(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = ImageManager.getDataBufferType((int)dataType);
        ImageLayout imageLayout = this.createImageLayout(sourceBand);
        AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), AggregationType.First, dataBufferType, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)2, (int)image.getWidth());
        Assert.assertEquals((int)2, (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster imageData = image.getData();
        Assert.assertEquals((double)5.0, (double)imageData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)7.0, (double)imageData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)13.0, (double)imageData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData.getSampleDouble(1, 1, 0), (double)1.0E-8);
    }

    private ImageLayout createImageLayout(Band sourceBand) {
        int dataType = sourceBand.getSourceImage().getSampleModel().getDataType();
        return ImageManager.createSingleBandedImageLayout((int)dataType, (int)this.referenceBand.getRasterWidth(), (int)this.referenceBand.getRasterHeight(), (int)this.referenceBand.getRasterWidth(), (int)this.referenceBand.getRasterHeight());
    }

    private Band createSourceBand(int dataType) {
        Product sourceProduct = new Product("dummy", "dummy", 4, 4);
        Band sourceBand = sourceProduct.addBand("sourceBand", "((X - 0.5) * 4) + (Y - 0.5)", dataType);
        sourceBand.setNoDataValue(117.0);
        sourceBand.setImageToModelTransform(new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f));
        return sourceBand;
    }

    private Band createSourceBand_Median(int dataType) {
        Product sourceProduct = new Product("dummy", "dummy", 4, 4);
        Band sourceBand = sourceProduct.addBand("sourceBand", "(X + 0.5) * (Y + 0.5)", dataType);
        sourceBand.setNoDataValue(117.0);
        sourceBand.setImageToModelTransform(new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f));
        return sourceBand;
    }
}

