/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.reproject;

import java.io.IOException;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.common.reproject.AbstractReprojectionOpTest;
import org.junit.Assert;
import org.junit.Test;

public class ReprojectionOpTest
extends AbstractReprojectionOpTest {
    @Test
    public void testGeoLatLon() throws IOException {
        this.parameterMap.put("crs", "EPSG:4326");
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        Assert.assertEquals((long)51L, (long)targetPoduct.getSceneRasterWidth());
        Assert.assertEquals((long)51L, (long)targetPoduct.getSceneRasterHeight());
        Assert.assertNotNull((Object)targetPoduct.getSceneGeoCoding());
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testUTMWithWktText() throws IOException {
        this.parameterMap.put("crs", "PROJCS[\"WGS 84 / UTM zone 33N\",GEOGCS[\"WGS 84\",  DATUM[\"World Geodetic System 1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],PARAMETER[\"central_meridian\", 15.0],PARAMETER[\"latitude_of_origin\", 0.0],PARAMETER[\"scale_factor\", 0.9996],PARAMETER[\"false_easting\", 500000.0],PARAMETER[\"false_northing\", 0.0],UNIT[\"m\", 1.0],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH],AUTHORITY[\"EPSG\",\"32633\"]]");
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testWithWktFile() throws IOException {
        this.parameterMap.put("wktFile", wktFile);
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testWithCollocationProduct() {
        HashMap<String, Object> productMap = new HashMap<String, Product>(5);
        productMap.put("source", this.sourceProduct);
        this.parameterMap.put("crs", "AUTO:42002");
        Product collocationProduct = this.createReprojectedProduct(productMap);
        productMap = new HashMap(5);
        productMap.put("source", this.sourceProduct);
        productMap.put("collocateWith", collocationProduct);
        this.parameterMap.remove("crs");
        Product targetProduct = this.createReprojectedProduct(productMap);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertTrue((boolean)targetProduct.isCompatibleProduct(collocationProduct, 1.0E-6f));
    }

    @Test
    public void testUTM() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testStartAndEndTime() throws Exception {
        this.parameterMap.put("crs", "EPSG:32633");
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct.getStartTime());
        Assert.assertNotNull((Object)targetPoduct.getEndTime());
        String meanTime = "02-JAN-2008 10:30:30.000000";
        Assert.assertEquals((Object)meanTime, (Object)targetPoduct.getStartTime().format());
        Assert.assertEquals((Object)meanTime, (Object)targetPoduct.getEndTime().format());
    }

    @Test
    public void testUTM_Bilinear() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("resampling", "Bilinear");
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        Assert.assertNotNull((Object)targetPoduct.getSceneGeoCoding());
        this.assertPixelValue(targetPoduct.getBand("floatData"), 24.0, 14.0, 311.96527, 0.01);
    }

    @Test
    public void testSpecifyingTargetDimension() throws IOException {
        int width = 200;
        int height = 300;
        this.parameterMap.put("crs", "EPSG:4326");
        this.parameterMap.put("width", 200);
        this.parameterMap.put("height", 300);
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        Assert.assertEquals((long)200L, (long)targetPoduct.getSceneRasterWidth());
        Assert.assertEquals((long)300L, (long)targetPoduct.getSceneRasterHeight());
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testSpecifyingPixelSize() throws IOException {
        double sizeX = 5.0;
        double sizeY = 10.0;
        this.parameterMap.put("crs", "EPSG:4326");
        this.parameterMap.put("pixelSizeX", 5.0);
        this.parameterMap.put("pixelSizeY", 10.0);
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        Assert.assertEquals((long)5L, (long)targetPoduct.getSceneRasterWidth());
        Assert.assertEquals((long)3L, (long)targetPoduct.getSceneRasterHeight());
    }

    @Test
    public void testSpecifyingReferencing() throws IOException {
        this.parameterMap.put("crs", "EPSG:4326");
        this.parameterMap.put("referencePixelX", 0.5);
        this.parameterMap.put("referencePixelY", 0.5);
        this.parameterMap.put("easting", 9.0);
        this.parameterMap.put("northing", 52.0);
        this.parameterMap.put("orientation", 0.0);
        Product targetPoduct = this.createReprojectedProduct();
        Assert.assertNotNull((Object)targetPoduct);
        GeoPos geoPos = targetPoduct.getSceneGeoCoding().getGeoPos(new PixelPos(0.5, 0.5), null);
        Assert.assertEquals((Object)new GeoPos(52.0, 9.0), (Object)geoPos);
        this.assertPixelValue(targetPoduct.getBand("floatData"), 23.5, 13.5, 299.0, 1.0E-6);
    }

    @Test
    public void testIncludeTiePointGrids() throws Exception {
        this.parameterMap.put("crs", "EPSG:4326");
        Product targetPoduct = this.createReprojectedProduct();
        TiePointGrid[] tiePointGrids = targetPoduct.getTiePointGrids();
        Assert.assertNotNull((Object)tiePointGrids);
        Assert.assertEquals((long)0L, (long)tiePointGrids.length);
        Band latGrid = targetPoduct.getBand("latGrid");
        Assert.assertNotNull((Object)latGrid);
        this.parameterMap.put("includeTiePointGrids", false);
        targetPoduct = this.createReprojectedProduct();
        tiePointGrids = targetPoduct.getTiePointGrids();
        Assert.assertNotNull((Object)tiePointGrids);
        Assert.assertEquals((long)0L, (long)tiePointGrids.length);
        latGrid = targetPoduct.getBand("latGrid");
        Assert.assertNull((Object)latGrid);
    }

    @Test
    public void testCopyPlacemarkGroups() throws IOException {
        PinDescriptor pinDescriptor = PinDescriptor.getInstance();
        Placemark pin = Placemark.createPointPlacemark((PlacemarkDescriptor)pinDescriptor, (String)"P1", (String)"", (String)"", (PixelPos)new PixelPos(1.5, 1.5), null, (GeoCoding)this.sourceProduct.getSceneGeoCoding());
        Placemark gcp = Placemark.createPointPlacemark((PlacemarkDescriptor)pinDescriptor, (String)"G1", (String)"", (String)"", (PixelPos)new PixelPos(2.5, 2.5), null, (GeoCoding)this.sourceProduct.getSceneGeoCoding());
        this.sourceProduct.getPinGroup().add(pin);
        this.sourceProduct.getGcpGroup().add(gcp);
        this.parameterMap.put("crs", "EPSG:4326");
        Product targetProduct = this.createReprojectedProduct();
        Assert.assertEquals((long)1L, (long)targetProduct.getPinGroup().getNodeCount());
        Assert.assertEquals((long)1L, (long)targetProduct.getGcpGroup().getNodeCount());
        Placemark pin2 = (Placemark)targetProduct.getPinGroup().get(0);
        Placemark gcp2 = (Placemark)targetProduct.getGcpGroup().get(0);
        Assert.assertEquals((Object)"P1", (Object)pin2.getName());
        Assert.assertEquals((Object)"G1", (Object)gcp2.getName());
        Assert.assertEquals((Object)pin.getGeoPos(), (Object)pin2.getGeoPos());
        Assert.assertEquals((Object)gcp.getGeoPos(), (Object)gcp2.getGeoPos());
        Assert.assertNotNull((Object)pin2.getPixelPos());
        Assert.assertNotNull((Object)gcp2.getPixelPos());
    }
}

