/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.reproject;

import java.util.HashMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.common.reproject.AbstractReprojectionOpTest;
import org.junit.Test;

public class FailureCasesReprojectionOpTest
extends AbstractReprojectionOpTest {
    @Test(expected=OperatorException.class)
    public void testEmptyParameterMap() {
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testParameterAmbigouity_wkt_wktFile() {
        this.parameterMap.put("crs", "PROJCS[\"WGS 84 / UTM zone 33N\",GEOGCS[\"WGS 84\",  DATUM[\"World Geodetic System 1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],PARAMETER[\"central_meridian\", 15.0],PARAMETER[\"latitude_of_origin\", 0.0],PARAMETER[\"scale_factor\", 0.9996],PARAMETER[\"false_easting\", 500000.0],PARAMETER[\"false_northing\", 0.0],UNIT[\"m\", 1.0],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH],AUTHORITY[\"EPSG\",\"32633\"]]");
        this.parameterMap.put("wktFile", wktFile);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testParameterAmbigouity_wkt_collocateProduct() {
        HashMap<String, Product> productMap = new HashMap<String, Product>(5);
        productMap.put("source", this.sourceProduct);
        productMap.put("collocateWith", this.sourceProduct);
        this.parameterMap.put("crs", "PROJCS[\"WGS 84 / UTM zone 33N\",GEOGCS[\"WGS 84\",  DATUM[\"World Geodetic System 1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],PARAMETER[\"central_meridian\", 15.0],PARAMETER[\"latitude_of_origin\", 0.0],PARAMETER[\"scale_factor\", 0.9996],PARAMETER[\"false_easting\", 500000.0],PARAMETER[\"false_northing\", 0.0],UNIT[\"m\", 1.0],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH],AUTHORITY[\"EPSG\",\"32633\"]]");
        this.createReprojectedProduct(productMap);
    }

    @Test(expected=OperatorException.class)
    public void testUnknownResamplingMethode() {
        this.parameterMap.put("resamplingName", "Super_Duper_Resampling");
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingPixelSizeY() {
        this.parameterMap.put("pixelSizeX", 0.024);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingPixelSizeX() {
        this.parameterMap.put("pixelSizeY", 0.024);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingReferencingPixelX() {
        this.parameterMap.put("referencePixelY", 0.5);
        this.parameterMap.put("easting", 1234.5);
        this.parameterMap.put("northing", 1234.5);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingReferencingpixelY() {
        this.parameterMap.put("referencePixelX", 0.5);
        this.parameterMap.put("easting", 1234.5);
        this.parameterMap.put("northing", 1234.5);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingReferencingNorthing() {
        this.parameterMap.put("referencePixelX", 0.5);
        this.parameterMap.put("referencePixelY", 0.5);
        this.parameterMap.put("easting", 1234.5);
        this.createReprojectedProduct();
    }

    @Test(expected=OperatorException.class)
    public void testMissingReferencingEasting() {
        this.parameterMap.put("referencePixelX", 0.5);
        this.parameterMap.put("referencePixelY", 0.5);
        this.parameterMap.put("northing", 1234.5);
        this.createReprojectedProduct();
    }
}

