/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.reproject;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.reproject.ReprojectionOp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractReprojectionOpTest {
    protected static final String WGS84_CODE = "EPSG:4326";
    protected static final String UTM33N_CODE = "EPSG:32633";
    protected static final String UTM33N_WKT = "PROJCS[\"WGS 84 / UTM zone 33N\",GEOGCS[\"WGS 84\",  DATUM[\"World Geodetic System 1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],PARAMETER[\"central_meridian\", 15.0],PARAMETER[\"latitude_of_origin\", 0.0],PARAMETER[\"scale_factor\", 0.9996],PARAMETER[\"false_easting\", 500000.0],PARAMETER[\"false_northing\", 0.0],UNIT[\"m\", 1.0],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH],AUTHORITY[\"EPSG\",\"32633\"]]";
    protected static File wktFile;
    private static final float[] LATS;
    private static final float[] LONS;
    protected static final String FLOAT_BAND_NAME = "floatData";
    protected static final String INT_BAND_NAME = "intData";
    protected Product sourceProduct;
    protected Map<String, Object> parameterMap;
    protected static final double EPS = 1.0E-6;

    @BeforeClass
    public static void setup() throws URISyntaxException {
        wktFile = new File(AbstractReprojectionOpTest.class.getResource("test.wkt").toURI());
    }

    private void createSourceProduct() throws Exception {
        this.sourceProduct = new Product("source", "t", 50, 50);
        TiePointGrid latGrid = new TiePointGrid("latGrid", 2, 2, 0.5, 0.5, 49.0, 49.0, LATS);
        TiePointGrid lonGrid = new TiePointGrid("lonGrid", 2, 2, 0.5, 0.5, 49.0, 49.0, LONS);
        this.sourceProduct.addTiePointGrid(latGrid);
        this.sourceProduct.addTiePointGrid(lonGrid);
        this.sourceProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        this.sourceProduct.setStartTime(ProductData.UTC.parse((String)"02-Jan-2008 10:15:10"));
        this.sourceProduct.setEndTime(ProductData.UTC.parse((String)"02-Jan-2008 10:45:50"));
        Band floatDataBand = this.sourceProduct.addBand(FLOAT_BAND_NAME, 30);
        floatDataBand.setRasterData(AbstractReprojectionOpTest.createDataFor(floatDataBand));
        floatDataBand.setSynthetic(true);
        Band intDataBand = this.sourceProduct.addBand(INT_BAND_NAME, 11);
        intDataBand.setRasterData(AbstractReprojectionOpTest.createDataFor(intDataBand));
        intDataBand.setSynthetic(true);
    }

    @Before
    public void setupTestMethod() throws Exception {
        this.parameterMap = new HashMap<String, Object>(5);
        this.createSourceProduct();
    }

    protected Product createReprojectedProduct(Map<String, Product> sourceMap) {
        String operatorName = OperatorSpi.getOperatorAlias(ReprojectionOp.class);
        return GPF.createProduct((String)operatorName, this.parameterMap, sourceMap);
    }

    protected Product createReprojectedProduct() {
        String operatorName = OperatorSpi.getOperatorAlias(ReprojectionOp.class);
        return GPF.createProduct((String)operatorName, this.parameterMap, (Product)this.sourceProduct);
    }

    protected void assertPixelValidState(Band targetBand, double sourceX, double sourceY, boolean expectedValid) throws IOException {
        PixelPos targetPP = this.computeTargetPP(targetBand, sourceX, sourceY);
        this.assertTargetPixelValidState(targetBand, targetPP, expectedValid);
    }

    protected void assertTargetPixelValidState(Band targetBand, PixelPos targetPP, boolean expectedValid) {
        boolean pixelValid = targetBand.isPixelValid((int)Math.floor(targetPP.x), (int)Math.floor(targetPP.y));
        Assert.assertEquals((Object)expectedValid, (Object)pixelValid);
    }

    protected void assertPixelValue(Band targetBand, double sourceX, double sourceY, double expectedPixelValue, double delta) throws IOException {
        PixelPos targetPP = this.computeTargetPP(targetBand, sourceX, sourceY);
        this.assertTargetPixelValue(targetBand, targetPP, expectedPixelValue, delta);
    }

    protected void assertTargetPixelValue(Band targetBand, PixelPos targetPP, double expectedPixelValue, double delta) throws IOException {
        double[] pixels = new double[1];
        targetBand.readPixels((int)Math.floor(targetPP.x), (int)Math.floor(targetPP.y), 1, 1, pixels);
        Assert.assertEquals((double)expectedPixelValue, (double)pixels[0], (double)delta);
    }

    protected PixelPos computeTargetPP(Band targetBand, double sourceX, double sourceY) {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        PixelPos sourcePP = new PixelPos(sourceX, sourceY);
        GeoPos geoPos = sourceBand.getGeoCoding().getGeoPos(sourcePP, null);
        return targetBand.getGeoCoding().getPixelPos(geoPos, null);
    }

    private static ProductData createDataFor(Band dataBand) {
        int width = dataBand.getRasterWidth();
        int height = dataBand.getRasterHeight();
        ProductData data = ProductData.createInstance((int)dataBand.getDataType(), (int)(width * height));
        for (int y = 0; y < height; ++y) {
            int line = y * width;
            for (int x = 0; x < width; ++x) {
                data.setElemIntAt(line + x, x * y);
            }
        }
        return data;
    }

    static {
        LATS = new float[]{50.0f, 50.0f, 30.0f, 30.0f};
        LONS = new float[]{6.0f, 26.0f, 6.0f, 26.0f};
    }
}

