/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.ProductSetReaderOp;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductSetReaderOpTest {
    private static File outputFile;

    @BeforeClass
    public static void setup() {
        outputFile = GlobalTestConfig.getBeamTestDataOutputFile((String)"ProductSetReaderOpTest/writtenProduct.dim");
        outputFile.getParentFile().mkdirs();
    }

    @AfterClass
    public static void teardown() {
        FileUtils.deleteTree((File)outputFile.getParentFile());
    }

    @Test
    public void testProductSetGraph() throws IOException, GraphException {
        Graph graph;
        String graphPath = ProductSetReaderOpTest.class.getResource("/org/esa/snap/core/gpf/common/productset/ProductSetMosaicGraph.xml").getFile();
        File product1 = new File(ProductSetReaderOpTest.class.getResource("/org/esa/snap/core/gpf/common/productset/subset1.dim").getFile());
        File product2 = new File(ProductSetReaderOpTest.class.getResource("/org/esa/snap/core/gpf/common/productset/subset2.dim").getFile());
        File[] srcFiles = new File[]{product1, product2};
        try (FileReader fileReader = new FileReader(graphPath);){
            graph = GraphIO.read((Reader)fileReader);
        }
        GraphProcessor processor = new GraphProcessor();
        this.setIO(graph, srcFiles, outputFile, "BEAM-DIMAP");
        processor.executeGraph(graph, ProgressMonitor.NULL);
    }

    @Test
    public void testFolderProductSetGraph() throws IOException, GraphException {
        Graph graph;
        String graphPath = ProductSetReaderOpTest.class.getResource("/org/esa/snap/core/gpf/common/productset/ProductSetMosaicGraph.xml").getFile();
        File product1 = new File(ProductSetReaderOpTest.class.getResource("/org/esa/snap/core/gpf/common/productset/subset1.dim").getFile());
        File[] srcFiles = new File[]{product1.getParentFile()};
        try (FileReader fileReader = new FileReader(graphPath);){
            graph = GraphIO.read((Reader)fileReader);
        }
        GraphProcessor processor = new GraphProcessor();
        this.setIO(graph, srcFiles, outputFile, "BEAM-DIMAP");
        processor.executeGraph(graph, ProgressMonitor.NULL);
    }

    private void setIO(Graph graph, File[] srcFiles, File tgtFile, String format) {
        String writeOperatorAlias;
        Node writerNode;
        String readOperatorAlias = OperatorSpi.getOperatorAlias(ProductSetReaderOp.class);
        Node readerNode = ProductSetReaderOpTest.findNode(graph, readOperatorAlias);
        if (readerNode != null) {
            DefaultDomElement param = new DefaultDomElement("parameters");
            String value = "";
            for (File srcFile : srcFiles) {
                value = value + srcFile.getAbsolutePath() + ",";
            }
            param.createChild("fileList").setValue(value);
            readerNode.setConfiguration((DomElement)param);
        }
        if ((writerNode = ProductSetReaderOpTest.findNode(graph, writeOperatorAlias = OperatorSpi.getOperatorAlias(WriteOp.class))) != null && tgtFile != null) {
            DomElement origParam = writerNode.getConfiguration();
            ((DomElement)origParam.getChild("file")).setValue(tgtFile.getAbsolutePath());
            if (format != null) {
                ((DomElement)origParam.getChild("formatName")).setValue(format);
            }
        }
    }

    private static Node findNode(Graph graph, String alias) {
        for (Node n : graph.getNodes()) {
            if (!n.getOperatorName().equals(alias)) continue;
            return n;
        }
        return null;
    }
}

