/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.util.io.FileUtils;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BandMathsOpTest {
    @Test
    public void testSimplestCase() throws Exception {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "1.0", "float32", "bigUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Band band = targetProduct.getBand("aBandName");
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"aDescription", (Object)band.getDescription());
        Assert.assertEquals((Object)"bigUnits", (Object)band.getUnit());
        Assert.assertEquals((long)30L, (long)band.getDataType());
        float[] floatValues = new float[16];
        band.readPixels(0, 0, 4, 4, floatValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 1.0f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, floatValues));
        Assert.assertNotNull((Object)targetProduct.getStartTime());
        Assert.assertEquals((Object)sourceProduct.getStartTime(), (Object)targetProduct.getStartTime());
        Assert.assertNotNull((Object)targetProduct.getEndTime());
        Assert.assertEquals((Object)sourceProduct.getEndTime(), (Object)targetProduct.getEndTime());
    }

    @Test
    public void testGeoCodingIsCopied() throws Exception {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "1.0", "uint8", "simpleUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        CoordinateReferenceSystem decode = CRS.decode((String)"EPSG:32632");
        Rectangle imageBounds = new Rectangle(4, 4);
        AffineTransform imageToMap = new AffineTransform();
        CrsGeoCoding geoCoding = new CrsGeoCoding(decode, imageBounds, imageToMap);
        sourceProduct.setSceneGeoCoding((GeoCoding)geoCoding);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertNotNull((Object)targetProduct.getSceneGeoCoding());
        Assert.assertTrue((boolean)targetProduct.isUsingSingleGeoCoding());
    }

    @Test
    public void testGeoCodingIsCopiedWithRasterInExpresssion() throws Exception {
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        CoordinateReferenceSystem decode = CRS.decode((String)"EPSG:32632");
        Rectangle imageBounds = new Rectangle(4, 4);
        AffineTransform imageToMap = new AffineTransform();
        CrsGeoCoding geoCoding = new CrsGeoCoding(decode, imageBounds, imageToMap);
        sourceProduct.setSceneGeoCoding((GeoCoding)geoCoding);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band1 * 2.0", "uint8", "simpleUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertNotNull((Object)targetProduct.getSceneGeoCoding());
        Assert.assertNotNull((Object)targetProduct.getBand("aBandName").getGeoCoding());
    }

    @Test
    public void testTwoExpressionWithMultiSize() throws Exception {
        Product sourceProduct1 = BandMathsOpTest.createTestProduct(4, 4);
        AffineTransform imageToMap = new AffineTransform();
        CrsGeoCoding geoCoding = new CrsGeoCoding(CRS.decode((String)"EPSG:32632"), new Rectangle(4, 4), imageToMap);
        sourceProduct1.setSceneGeoCoding((GeoCoding)geoCoding);
        Product sourceProduct2 = BandMathsOpTest.createTestProduct(12, 12);
        AffineTransform imageToMap2 = new AffineTransform();
        CrsGeoCoding geoCoding2 = new CrsGeoCoding(CRS.decode((String)"EPSG:32632"), new Rectangle(12, 12), imageToMap2);
        sourceProduct2.setSceneGeoCoding((GeoCoding)geoCoding2);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName1", "$sourceProduct.1.band1 + $sourceProduct.1.band2", "uint16", "simpleUnits"), BandMathsOpTest.createBandDescription("aBandName2", "$sourceProduct.2.band1 + $sourceProduct.2.band2", "uint16", "simpleUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product[])new Product[]{sourceProduct1, sourceProduct2});
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertNotNull((Object)targetProduct.getSceneGeoCoding());
        Assert.assertFalse((boolean)targetProduct.isUsingSingleGeoCoding());
        GeoCoding targetGC1 = targetProduct.getBand("aBandName1").getGeoCoding();
        GeoCoding targetGC2 = targetProduct.getBand("aBandName2").getGeoCoding();
        Assert.assertNotSame((Object)targetGC1, (Object)targetGC2);
    }

    @Test
    public void testOneExpressionWithMultiSize() throws Exception {
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        Band band4 = new Band("band4", 11, 10, 10);
        sourceProduct.addBand(band4);
        short[] shortValues = new short[100];
        Arrays.fill(shortValues, (short)12);
        band4.setData(ProductData.createInstance((short[])shortValues));
        CoordinateReferenceSystem decode = CRS.decode((String)"EPSG:32632");
        Rectangle imageBounds = new Rectangle(4, 4);
        AffineTransform imageToMap = new AffineTransform();
        CrsGeoCoding geoCoding = new CrsGeoCoding(decode, imageBounds, imageToMap);
        sourceProduct.setSceneGeoCoding((GeoCoding)geoCoding);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band1 * band4", "uint8", "simpleUnits")};
        parameters.put("targetBands", bandDescriptors);
        try {
            GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
            Assert.fail((String)"Should fail, because bands have different size");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    @Test
    public void testSimplestCaseWithFactoryMethod() throws Exception {
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        BandMathsOp bandMathsOp = BandMathsOpTest.createBooleanExpressionBand(sourceProduct, "band1 > 0");
        Assert.assertNotNull((Object)bandMathsOp);
        Product targetProduct = bandMathsOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        Band band = targetProduct.getBandAt(0);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((long)10L, (long)band.getDataType());
        int[] intValues = new int[16];
        band.readPixels(0, 0, 4, 4, intValues, ProgressMonitor.NULL);
        int[] expectedValues = new int[16];
        Arrays.fill(expectedValues, 1);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, intValues));
    }

    @Test
    public void testScaledInputBand() throws Exception {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band3", "float32", "milliUnits"), BandMathsOpTest.createBandDescription("bBandName", "band3.raw & 64", "int32", "noUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Band band = targetProduct.getBand("aBandName");
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"aDescription", (Object)band.getDescription());
        Assert.assertEquals((Object)"milliUnits", (Object)band.getUnit());
        Assert.assertEquals((long)30L, (long)band.getDataType());
        float[] floatValues = new float[16];
        band.readPixels(0, 0, 4, 4, floatValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 3.0f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, floatValues));
        Band bband = targetProduct.getBand("bBandName");
        int[] intValues = new int[16];
        bband.readPixels(0, 0, 4, 4, intValues, ProgressMonitor.NULL);
        int[] expectedIntValues = new int[16];
        Arrays.fill(expectedValues, 0.0f);
        Assert.assertTrue((boolean)Arrays.equals(expectedIntValues, intValues));
    }

    @Test
    public void testScaledOutputBand() throws Exception {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band1", "float32", "milliUnits", 0.1, 5.0)};
        parameters.put("targetBands", bandDescriptors);
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Band band = targetProduct.getBand("aBandName");
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"aDescription", (Object)band.getDescription());
        Assert.assertEquals((Object)"milliUnits", (Object)band.getUnit());
        Assert.assertEquals((long)30L, (long)band.getDataType());
        Assert.assertEquals((double)0.1, (double)band.getScalingFactor(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)band.getScalingOffset(), (double)1.0E-6);
        float[] floatValues = new float[16];
        band.readPixels(0, 0, 4, 4, floatValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 1.0f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, floatValues));
    }

    @Test
    public void testTwoSourceBandsOneTargetBand() throws Exception {
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band1 + band2", "float32", "")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Band band = targetProduct.getBand("aBandName");
        float[] actualValues = new float[16];
        band.readPixels(0, 0, 4, 4, actualValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 3.5f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, actualValues));
    }

    @Test
    public void testTwoSourceBandsTwoTargetBands() throws Exception {
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("b1", "band1 + band2 < 3.0", "int8", "milliUnit"), BandMathsOpTest.createBandDescription("b2", "band1 + band2 + 2.5", "int32", "maxiUnit")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Band b1 = targetProduct.getBand("b1");
        Assert.assertEquals((Object)"milliUnit", (Object)b1.getUnit());
        b1.readRasterDataFully(ProgressMonitor.NULL);
        Assert.assertTrue((boolean)(b1.getRasterData().getElems() instanceof byte[]));
        byte[] actualBooleanValues = (byte[])b1.getRasterData().getElems();
        byte[] expectedBooleanValues = new byte[16];
        Arrays.fill(expectedBooleanValues, (byte)0);
        Assert.assertTrue((boolean)Arrays.equals(expectedBooleanValues, actualBooleanValues));
        Band b2 = targetProduct.getBand("b2");
        Assert.assertEquals((Object)"maxiUnit", (Object)b2.getUnit());
        b2.readRasterDataFully(ProgressMonitor.NULL);
        Assert.assertTrue((boolean)(b2.getRasterData().getElems() instanceof int[]));
        int[] actualIntValues = (int[])b2.getRasterData().getElems();
        int[] expectedIntValues = new int[16];
        Arrays.fill(expectedIntValues, 6);
        Assert.assertTrue((boolean)Arrays.equals(expectedIntValues, actualIntValues));
    }

    @Test
    public void testTwoSourceProductsOneTargetBand() throws Exception {
        Product sourceProduct1 = BandMathsOpTest.createTestProduct(4, 4);
        Product sourceProduct2 = BandMathsOpTest.createTestProduct(4, 4);
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "$sourceProduct.1.band1 + $sourceProduct.2.band2", "float32", "milliUnit")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product[])new Product[]{sourceProduct1, sourceProduct2});
        Band band = targetProduct.getBand("aBandName");
        float[] actualValues = new float[16];
        band.readPixels(0, 0, 4, 4, actualValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 3.5f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, actualValues));
    }

    @Test
    public void testTwoSourceProductsWithNames() throws Exception {
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        productMap.put("numberOne", BandMathsOpTest.createTestProduct(4, 4));
        productMap.put("numberTwo", BandMathsOpTest.createTestProduct(4, 4));
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "$numberOne.band1 + $numberTwo.band2", "float32", "milliUnit")};
        parameters.put("targetBands", bandDescriptors);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, productMap);
        Band band = targetProduct.getBand("aBandName");
        float[] actualValues = new float[16];
        band.readPixels(0, 0, 4, 4, actualValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, 3.5f);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, actualValues));
    }

    @Test
    public void testDivisionByZero() throws Exception {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{BandMathsOpTest.createBandDescription("aBandName", "band1/0.0", "float32", "bigUnits")};
        parameters.put("targetBands", bandDescriptors);
        Product sourceProduct = BandMathsOpTest.createTestProduct(4, 4);
        Product targetProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)targetProduct);
        Band band = targetProduct.getBand("aBandName");
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"aDescription", (Object)band.getDescription());
        Assert.assertEquals((Object)"bigUnits", (Object)band.getUnit());
        Assert.assertEquals((long)30L, (long)band.getDataType());
        float[] floatValues = new float[16];
        band.readPixels(0, 0, 4, 4, floatValues, ProgressMonitor.NULL);
        float[] expectedValues = new float[16];
        Arrays.fill(expectedValues, Float.NaN);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, floatValues));
    }

    @Test
    public void testGraph() throws Exception {
        HashMap parameterMap = new HashMap();
        Class<BandMathsOp> opType = BandMathsOp.class;
        Graph graph = GraphIO.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("BandMathsOpTest.xml")));
        Node bandMathsNode = graph.getNode("bandMathsNode");
        DomElement configurationDomElement = bandMathsNode.getConfiguration();
        ParameterDescriptorFactory parameterDescriptorFactory = new ParameterDescriptorFactory();
        PropertyContainer parameterSet = PropertyContainer.createMapBacked(parameterMap, opType, (PropertyDescriptorFactory)parameterDescriptorFactory);
        Assert.assertNotNull((Object)parameterSet.getProperty("targetBands"));
        Assert.assertNull((Object)parameterSet.getProperty("targetBands").getValue());
        Assert.assertNotNull((Object)parameterSet.getProperty("variables"));
        Assert.assertNull((Object)parameterSet.getProperty("variables").getValue());
        DefaultDomConverter domConverter = new DefaultDomConverter(opType, (PropertyDescriptorFactory)parameterDescriptorFactory);
        domConverter.convertDomToValue(configurationDomElement, (Object)parameterSet);
        Assert.assertNotNull((Object)parameterSet.getProperty("targetBands"));
        Assert.assertNotNull((Object)parameterSet.getProperty("targetBands").getValue());
        Assert.assertNotNull((Object)parameterSet.getProperty("variables"));
        Assert.assertNotNull((Object)parameterSet.getProperty("variables").getValue());
        Object targetBandsObj = parameterSet.getProperty("targetBands").getValue();
        Assert.assertTrue((boolean)(targetBandsObj instanceof BandMathsOp.BandDescriptor[]));
        BandMathsOp.BandDescriptor[] targetBands = (BandMathsOp.BandDescriptor[])targetBandsObj;
        Assert.assertEquals((long)2L, (long)targetBands.length);
        Assert.assertEquals((Object)"reflec_13", (Object)targetBands[0].name);
        Assert.assertEquals((Object)"reflec_14", (Object)targetBands[1].name);
        Object variablesObj = parameterSet.getProperty("variables").getValue();
        Assert.assertTrue((boolean)(variablesObj instanceof BandMathsOp.Variable[]));
        BandMathsOp.Variable[] variables = (BandMathsOp.Variable[])variablesObj;
        Assert.assertEquals((long)3L, (long)variables.length);
        Assert.assertEquals((Object)"SOLAR_FLUX_13", (Object)variables[0].name);
        Assert.assertEquals((Object)"float32", (Object)variables[0].type);
        Assert.assertEquals((Object)"SOLAR_FLUX_14", (Object)variables[1].name);
        Assert.assertEquals((Object)"float32", (Object)variables[1].type);
        Assert.assertEquals((Object)"PI", (Object)variables[2].name);
        Assert.assertEquals((Object)"float64", (Object)variables[2].type);
        InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("BandMathsOpParameters.xml"));
        String expectedXML = FileUtils.readText((Reader)inputStreamReader).trim();
        DefaultDomElement parameters = new DefaultDomElement("parameters");
        domConverter.convertValueToDom((Object)parameterSet, (DomElement)parameters);
        Assert.assertEquals((Object)expectedXML, (Object)StringEscapeUtils.unescapeXml((String)parameters.toXml().trim()));
    }

    private static BandMathsOp.BandDescriptor createBandDescription(String bandName, String expression, String type, String unit) {
        return BandMathsOpTest.createBandDescription(bandName, expression, type, unit, null, null);
    }

    private static BandMathsOp.BandDescriptor createBandDescription(String bandName, String expression, String type, String unit, Double scalingFactor, Double scalingOffset) {
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = bandName;
        bandDescriptor.description = "aDescription";
        bandDescriptor.expression = expression;
        bandDescriptor.type = type;
        bandDescriptor.unit = unit;
        bandDescriptor.scalingFactor = scalingFactor;
        bandDescriptor.scalingOffset = scalingOffset;
        return bandDescriptor;
    }

    private static Product createTestProduct(int w, int h) throws ParseException {
        Product testProduct = new Product("p", "t", w, h);
        Band band1 = testProduct.addBand("band1", 12);
        int[] intValues = new int[w * h];
        Arrays.fill(intValues, 1);
        band1.setData(ProductData.createInstance((int[])intValues));
        Band band2 = testProduct.addBand("band2", 30);
        float[] floatValues = new float[w * h];
        Arrays.fill(floatValues, 2.5f);
        band2.setData(ProductData.createInstance((float[])floatValues));
        Band band3 = testProduct.addBand("band3", 11);
        band3.setScalingFactor(0.5);
        short[] shortValues = new short[w * h];
        Arrays.fill(shortValues, (short)6);
        band3.setData(ProductData.createInstance((short[])shortValues));
        testProduct.setStartTime(ProductData.UTC.parse((String)"01-APR-2011 11:22:33"));
        testProduct.setEndTime(ProductData.UTC.parse((String)"02-APR-2011 11:22:33"));
        return testProduct;
    }

    public static BandMathsOp createBooleanExpressionBand(Product sourceProduct, String expression) {
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = "band1";
        bandDescriptor.expression = expression;
        bandDescriptor.type = "int8";
        BandMathsOp bandMathsOp = new BandMathsOp();
        bandMathsOp.setSourceProduct(sourceProduct);
        bandMathsOp.setTargetBandDescriptors(new BandMathsOp.BandDescriptor[]{bandDescriptor});
        return bandMathsOp;
    }
}

