/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.annotations;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.DoubleConverter;
import com.bc.ceres.binding.converters.EnumConverter;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.annotations.TestPojo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParameterDescriptorFactoryTest {
    private static PropertyContainer propertyContainer;

    @BeforeClass
    public static void setUp() {
        ParameterDescriptorFactory pdf = new ParameterDescriptorFactory();
        TestPojo testPojo = new TestPojo();
        propertyContainer = PropertyContainer.createObjectBacked((Object)testPojo, (PropertyDescriptorFactory)pdf);
    }

    @Test
    public void testPercentageField() throws Exception {
        String PERCENTAGE = "percentage";
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("percentage");
        Assert.assertEquals((Object)"percentage", (Object)propertyDescriptor.getName());
        Assert.assertNull((Object)propertyDescriptor.getAlias());
        Assert.assertEquals((Object)0.0, (Object)propertyDescriptor.getDefaultValue());
        Assert.assertSame(DoubleConverter.class, propertyDescriptor.getConverter().getClass());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDescription());
        Assert.assertEquals((Object)"Percentage", (Object)propertyDescriptor.getDisplayName());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDomConverter());
        Assert.assertEquals(null, (Object)propertyDescriptor.getFormat());
        Assert.assertEquals(null, (Object)propertyDescriptor.getItemAlias());
        Assert.assertEquals((Object)"double", (Object)propertyDescriptor.getType().getName());
        Assert.assertEquals(null, (Object)propertyDescriptor.getUnit());
        Assert.assertNull((Object)propertyDescriptor.getValidator());
        Assert.assertEquals((Object)"(0,100]", (Object)propertyDescriptor.getValueRange().toString());
        Assert.assertEquals((double)0.0, (double)propertyDescriptor.getValueRange().getMin(), (double)1.0E-6);
        Assert.assertEquals((double)100.0, (double)propertyDescriptor.getValueRange().getMax(), (double)1.0E-6);
        Assert.assertEquals(null, (Object)propertyDescriptor.getValueSet());
    }

    @Test
    public void testThresholdField() throws Exception {
        String FIELD_NAME = "threshold";
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("threshold");
        Assert.assertEquals((Object)"threshold", (Object)propertyDescriptor.getName());
        Assert.assertNull((Object)propertyDescriptor.getAlias());
        Assert.assertEquals((Object)0.0, (Object)propertyDescriptor.getDefaultValue());
        Assert.assertSame(DoubleConverter.class, propertyDescriptor.getConverter().getClass());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDescription());
        Assert.assertEquals((Object)"a nice desciption", (Object)propertyDescriptor.getDisplayName());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDomConverter());
        Assert.assertEquals(null, (Object)propertyDescriptor.getFormat());
        Assert.assertEquals(null, (Object)propertyDescriptor.getItemAlias());
        Assert.assertFalse((boolean)propertyDescriptor.getType().isArray());
        Assert.assertEquals(null, (Object)propertyDescriptor.getUnit());
        Assert.assertNull((Object)propertyDescriptor.getValidator());
        Assert.assertEquals(null, (Object)propertyDescriptor.getValueRange());
        Assert.assertNotNull((Object)propertyDescriptor.getValueSet());
        Assert.assertEquals((long)3L, (long)propertyDescriptor.getValueSet().getItems().length);
        Assert.assertEquals((Object)0.0, (Object)propertyDescriptor.getValueSet().getItems()[0]);
        Assert.assertEquals((Object)13.0, (Object)propertyDescriptor.getValueSet().getItems()[1]);
        Assert.assertEquals((Object)42.0, (Object)propertyDescriptor.getValueSet().getItems()[2]);
        DefaultPropertyAccessor propertyAccessor = new DefaultPropertyAccessor();
        Property property = new Property(propertyDescriptor, (PropertyAccessor)propertyAccessor);
        Validator validator = property.getValidator();
        Assert.assertNotNull((Object)validator);
        Assert.assertNotNull((Object)property);
        try {
            validator.validateValue(property, (Object)42.0);
        }
        catch (ValidationException e) {
            Assert.fail((String)("validation failed: " + e.getMessage()));
        }
    }

    @Test
    public void testThresholdArrayField() throws Exception {
        String fieldName = "thresholdArray";
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("thresholdArray");
        Assert.assertEquals((Object)"thresholdArray", (Object)propertyDescriptor.getName());
        Assert.assertNull((Object)propertyDescriptor.getAlias());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDefaultValue());
        Assert.assertSame(ArrayConverter.class, propertyDescriptor.getConverter().getClass());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDescription());
        Assert.assertEquals((Object)"Threshold array", (Object)propertyDescriptor.getDisplayName());
        Assert.assertEquals(null, (Object)propertyDescriptor.getDomConverter());
        Assert.assertEquals(null, (Object)propertyDescriptor.getFormat());
        Assert.assertEquals(null, (Object)propertyDescriptor.getItemAlias());
        Class type = propertyDescriptor.getType();
        Assert.assertTrue((boolean)type.isArray());
        Assert.assertEquals(Double.TYPE, type.getComponentType());
        Assert.assertEquals(null, (Object)propertyDescriptor.getUnit());
        Assert.assertNull((Object)propertyDescriptor.getValidator());
        Assert.assertEquals(null, (Object)propertyDescriptor.getValueRange());
        Assert.assertNotNull((Object)propertyDescriptor.getValueSet());
        Assert.assertEquals((long)3L, (long)propertyDescriptor.getValueSet().getItems().length);
        Assert.assertEquals((Object)0.0, (Object)propertyDescriptor.getValueSet().getItems()[0]);
        Assert.assertEquals((Object)13.0, (Object)propertyDescriptor.getValueSet().getItems()[1]);
        Assert.assertEquals((Object)42.0, (Object)propertyDescriptor.getValueSet().getItems()[2]);
        DefaultPropertyAccessor propertyAccessor = new DefaultPropertyAccessor();
        Property property = new Property(propertyDescriptor, (PropertyAccessor)propertyAccessor);
        Validator validator = property.getValidator();
        Assert.assertNotNull((Object)validator);
        Assert.assertNotNull((Object)property);
        try {
            validator.validateValue(property, (Object)new double[]{42.0});
        }
        catch (ValidationException e) {
            Assert.fail((String)("validation failed: " + e.getMessage()));
        }
    }

    @Test
    public void testThresholdFail() {
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("threshold");
        DefaultPropertyAccessor propertyAccessor = new DefaultPropertyAccessor();
        Property property = new Property(propertyDescriptor, (PropertyAccessor)propertyAccessor);
        Validator validator = property.getValidator();
        try {
            validator.validateValue(property, (Object)10.0);
            Assert.fail((String)"validation should fail");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    public void testEnums() {
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("aPValue");
        Assert.assertEquals((Object)"aPValue", (Object)propertyDescriptor.getName());
        Assert.assertSame(EnumConverter.class, propertyDescriptor.getConverter().getClass());
        ValueSet valueSet = propertyDescriptor.getValueSet();
        Assert.assertNotNull((Object)valueSet);
        Object[] valueSetItems = valueSet.getItems();
        Assert.assertEquals((long)3L, (long)valueSetItems.length);
        Assert.assertEquals((Object)((Object)TestPojo.TestEnum.P1), (Object)valueSetItems[0]);
        Assert.assertEquals((Object)((Object)TestPojo.TestEnum.P2), (Object)valueSetItems[1]);
        Assert.assertEquals((Object)((Object)TestPojo.TestEnum.P3), (Object)valueSetItems[2]);
        Assert.assertEquals((Object)((Object)TestPojo.TestEnum.P2), (Object)propertyDescriptor.getDefaultValue());
    }
}

