/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.geotools.referencing.CRS;

public class TestOps {
    public static final int RASTER_WIDTH = 3;
    public static final int RASTER_HEIGHT = 2;
    static String calls = "";

    public static void registerCall(String str) {
        calls = calls + str;
    }

    public static void clearCalls() {
        calls = "";
    }

    public static String getCalls() {
        return calls;
    }

    @OperatorMetadata(alias="OpWithConverter")
    public static class OpParameterConverter
    extends Operator {
        @Parameter(converter=JtsGeometryConverter.class)
        private Geometry parameterWithConverter;
        @Parameter(domConverter=TestDomConverter.class)
        private CRS parameterWithDomConverter;
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            this.targetProduct = new Product("OpWithConverter", "Converting", 3, 2);
            this.targetProduct.addBand(new Band("region", 10, 3, 2));
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            TestOps.registerCall("OpWithConverter;");
        }

        public static class TestDomConverter
        implements DomConverter {
            public Class<?> getValueType() {
                return null;
            }

            public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
                return null;
            }

            public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            }
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(OpParameterConverter.class);
            }
        }
    }

    @OperatorMetadata(alias="OutputOp", autoWriteDisabled=true)
    public static class OpImplementingOutput
    extends Operator {
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            this.targetProduct = new Product("OutputOp", "OutputOp", 3, 2);
            this.targetProduct.addBand(new Band("OutputOp", 10, 3, 2));
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            TestOps.registerCall("OutputOp;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(OpImplementingOutput.class);
            }
        }
    }

    @OperatorMetadata(alias="Op5")
    public static class Op5
    extends Operator {
        @SourceProducts
        Product[] sourceProducts;
        @SourceProduct(alias="Vincent")
        Product namedProduct;
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            this.targetProduct = new Product("Op5", "Op5Type", 3, 2);
            this.targetProduct.addBand(new Band("Op5", 10, 3, 2));
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            TestOps.registerCall("Op5;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(Op5.class);
            }
        }
    }

    @OperatorMetadata(alias="Op4")
    public static class Op4
    extends Operator {
        @TargetProduct
        private Product targetProduct;
        @TargetProperty(alias="PI", description="The ratio of any circle's circumference to its diameter")
        private double pi;
        @TargetProperty
        private String[] names;

        public void initialize() {
            this.targetProduct = new Product("Op1Name", "Op1Type", 3, 2);
            this.targetProduct.addBand(new Band("Op1A", 10, 3, 2));
            this.pi = 3.142;
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            TestOps.registerCall("Op4;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(Op4.class);
            }
        }
    }

    @OperatorMetadata(alias="Op3")
    public static class Op3
    extends Operator {
        @Parameter
        public boolean ignoreSign;
        @Parameter(description="The valid mask expression")
        public String expression;
        @Parameter(valueSet={"NN", "BQ", "CC"}, defaultValue="NN")
        public String interpolMethod;
        @Parameter(defaultValue="1.5", interval="[-10,10)")
        public double factor;
        @SourceProduct(bands={"Op1A"})
        public Product input1;
        @SourceProduct(bands={"Op2A", "Op2B"})
        public Product input2;
        @SourceProducts
        public Product[] inputs;
        @TargetProduct
        public Product output;

        public void initialize() {
            this.output = new Product("Op3Name", "Op3Type", 3, 2);
            this.output.addBand(new Band("Op3A", 10, 3, 2));
            this.output.addBand(new Band("Op3B", 10, 3, 2));
            this.output.addBand(new Band("Op3C", 10, 3, 2));
            this.output.addBand(new Band("Op3D", 10, 3, 2));
        }

        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
            this.getSourceTile((RasterDataNode)this.input1.getBand("Op1A"), rectangle);
            this.getSourceTile((RasterDataNode)this.input2.getBand("Op2A"), rectangle);
            this.getSourceTile((RasterDataNode)this.input2.getBand("Op2B"), rectangle);
            targetTiles.get(this.output.getBand("Op3A"));
            targetTiles.get(this.output.getBand("Op3B"));
            targetTiles.get(this.output.getBand("Op3C"));
            targetTiles.get(this.output.getBand("Op3D"));
            TestOps.registerCall("Op3;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(Op3.class);
            }
        }
    }

    @OperatorMetadata(alias="Op2")
    public static class Op2
    extends Operator {
        @Parameter
        public double threshold;
        @SourceProduct(bands={"Op1A"})
        public Product input;
        @TargetProduct
        public Product output;

        public void initialize() {
            this.output = new Product("Op2Name", "Op2Type", 3, 2);
            this.output.addBand(new Band("Op2A", 10, 3, 2));
            this.output.addBand(new Band("Op2B", 10, 3, 2));
        }

        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
            this.getSourceTile((RasterDataNode)this.input.getBand("Op1A"), rectangle);
            targetTiles.get(this.output.getBand("Op2A"));
            targetTiles.get(this.output.getBand("Op2B"));
            TestOps.registerCall("Op2;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(Op2.class);
            }
        }
    }

    @OperatorMetadata(alias="Op1")
    public static class Op1
    extends Operator {
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            this.targetProduct = new Product("Op1Name", "Op1Type", 3, 2);
            this.targetProduct.addBand(new Band("Op1A", 10, 3, 2));
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            TestOps.registerCall("Op1;");
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(Op1.class);
            }
        }
    }
}

