/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.junit.Assert;
import org.junit.Test;

public class OperatorSpiTest {
    @Test
    public void testNonAnnotatedOperator() {
        OperatorSpi operatorSpi = new OperatorSpi(NonAnnotatedFooOp.class){};
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor());
        Assert.assertEquals((Object)NonAnnotatedFooOp.class.getName(), (Object)operatorSpi.getOperatorDescriptor().getName());
        Assert.assertEquals((Object)"NonAnnotatedFooOp", (Object)operatorSpi.getOperatorDescriptor().getAlias());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getLabel());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getVersion());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getAuthors());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getDescription());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getCopyright());
        Assert.assertEquals(NonAnnotatedFooOp.class, (Object)operatorSpi.getOperatorDescriptor().getOperatorClass());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getSourceProductDescriptors());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getSourceProductsDescriptor());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getParameterDescriptors());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getTargetProductDescriptor());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getTargetPropertyDescriptors());
        Assert.assertEquals((Object)"NonAnnotatedFooOp", (Object)operatorSpi.getOperatorAlias());
    }

    @Test
    public void testAnnotatedOperator() {
        OperatorSpi operatorSpi = new OperatorSpi(AnnotatedFooOp.class){};
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor());
        Assert.assertEquals((Object)AnnotatedFooOp.class.getName(), (Object)operatorSpi.getOperatorDescriptor().getName());
        Assert.assertEquals((Object)"fooop", (Object)operatorSpi.getOperatorDescriptor().getAlias());
        Assert.assertEquals((Object)"Foo Operator", (Object)operatorSpi.getOperatorDescriptor().getLabel());
        Assert.assertEquals((Object)"0.1", (Object)operatorSpi.getOperatorDescriptor().getVersion());
        Assert.assertEquals((Object)"F.Bar", (Object)operatorSpi.getOperatorDescriptor().getAuthors());
        Assert.assertEquals((Object)"This is a baz", (Object)operatorSpi.getOperatorDescriptor().getDescription());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getCopyright());
        Assert.assertEquals(AnnotatedFooOp.class, (Object)operatorSpi.getOperatorDescriptor().getOperatorClass());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getSourceProductDescriptors());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getSourceProductsDescriptor());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getParameterDescriptors());
        Assert.assertEquals(null, (Object)operatorSpi.getOperatorDescriptor().getTargetProductDescriptor());
        Assert.assertNotNull((Object)operatorSpi.getOperatorDescriptor().getTargetPropertyDescriptors());
        Assert.assertEquals((Object)"fooop", (Object)operatorSpi.getOperatorAlias());
    }

    @OperatorMetadata(alias="fooop", label="Foo Operator", version="0.1", authors="F.Bar", description="This is a baz")
    public static class AnnotatedFooOp
    extends Operator {
        @SourceProduct
        Product input;
        Product auxdata;
        @Parameter
        double threshold;
        int maxCount;

        public void initialize() throws OperatorException {
        }
    }

    public static class NonAnnotatedFooOp
    extends Operator {
        public void initialize() throws OperatorException {
        }
    }
}

