/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import java.io.File;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.junit.Assert;
import org.junit.Test;

public class OpParameterInitialisationTest {
    @Test
    public void testUnknownParameters() {
        SomeOp op;
        try {
            op = new SomeOp();
            op.setParameterDefaultValues();
            op.setParameter("pi", 21);
            op.getTargetProduct();
            Assert.assertEquals((Object)21, (Object)op.getParameter("pi"));
            Assert.assertEquals((long)21L, (long)op.pi);
        }
        catch (OperatorException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected: " + e.getMessage()));
        }
        try {
            op = new SomeOp();
            op.setParameterDefaultValues();
            op.setParameter("iamAnUnknownParameter", -1);
            op.getTargetProduct();
        }
        catch (OperatorException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected: " + e.getMessage()));
        }
    }

    @Test
    public void testParameterDefaultValueInitialisation() {
        SomeOp op = new SomeOp();
        op.setParameterDefaultValues();
        this.testParameterValues(op, false);
        op.getTargetProduct();
        this.testParameterValues(op, true);
    }

    @Test
    public void testDerivedParameterDefaultValueInitialisation() {
        SomeDerivedOp op = new SomeDerivedOp();
        op.setParameterDefaultValues();
        this.testParameterValues(op, false);
        Assert.assertEquals((Object)new File("/usr/marco"), (Object)op.pFile);
        op.getTargetProduct();
        this.testParameterValues(op, true);
        Assert.assertEquals((Object)new File("/usr/marco"), (Object)op.pFile);
    }

    private void testParameterValues(SomeOp op, boolean expectedInitialiseState) {
        Assert.assertEquals((Object)expectedInitialiseState, (Object)op.initialized);
        Assert.assertEquals((long)123L, (long)op.pb);
        Assert.assertEquals((long)97L, (long)op.pc);
        Assert.assertEquals((long)321L, (long)op.ph);
        Assert.assertEquals((long)12345L, (long)op.pi);
        Assert.assertEquals((long)1234512345L, (long)op.pl);
        Assert.assertEquals((double)123.45f, (double)op.pf, (double)1.0E-5);
        Assert.assertEquals((double)0.12345, (double)op.pd, (double)1.0E-10);
        Assert.assertEquals((Object)"x", (Object)op.ps);
        Assert.assertNotNull((Object)op.pab);
        Assert.assertEquals((long)3L, (long)op.pab.length);
        Assert.assertEquals((long)123L, (long)op.pab[0]);
        Assert.assertNotNull((Object)op.pac);
        Assert.assertEquals((long)3L, (long)op.pac.length);
        Assert.assertEquals((long)97L, (long)op.pac[0]);
        Assert.assertEquals((long)98L, (long)op.pac[1]);
        Assert.assertEquals((long)99L, (long)op.pac[2]);
        Assert.assertNotNull((Object)op.pah);
        Assert.assertEquals((long)3L, (long)op.pah.length);
        Assert.assertEquals((long)321L, (long)op.pah[0]);
        Assert.assertNotNull((Object)op.pai);
        Assert.assertEquals((long)3L, (long)op.pai.length);
        Assert.assertEquals((long)12345L, (long)op.pai[0]);
        Assert.assertNotNull((Object)op.pal);
        Assert.assertEquals((long)3L, (long)op.pal.length);
        Assert.assertEquals((long)1234512345L, (long)op.pal[0]);
        Assert.assertNotNull((Object)op.paf);
        Assert.assertEquals((long)3L, (long)op.paf.length);
        Assert.assertEquals((double)123.45f, (double)op.paf[0], (double)1.0E-5);
        Assert.assertNotNull((Object)op.pad);
        Assert.assertEquals((long)3L, (long)op.pad.length);
        Assert.assertEquals((double)0.12345, (double)op.pad[0], (double)1.0E-10);
        Assert.assertNotNull((Object)op.pas);
        Assert.assertEquals((long)3L, (long)op.pas.length);
        Assert.assertEquals((Object)"x", (Object)op.pas[0]);
        Assert.assertEquals((Object)"y", (Object)op.pas[1]);
        Assert.assertEquals((Object)"z", (Object)op.pas[2]);
    }

    public static class SomeDerivedOp
    extends SomeOp {
        @Parameter(defaultValue="/usr/marco")
        File pFile;
    }

    public static class SomeOp
    extends Operator {
        @Parameter(defaultValue="123")
        byte pb;
        @Parameter(defaultValue="a")
        char pc;
        @Parameter(defaultValue="321")
        short ph;
        @Parameter(defaultValue="12345")
        int pi;
        @Parameter(defaultValue="1234512345")
        long pl;
        @Parameter(defaultValue="123.45")
        float pf;
        @Parameter(defaultValue="0.12345")
        double pd;
        @Parameter(defaultValue="x")
        String ps;
        @Parameter(defaultValue="123,122,121")
        byte[] pab;
        @Parameter(defaultValue="a,b,c")
        char[] pac;
        @Parameter(defaultValue="321,331,341")
        short[] pah;
        @Parameter(defaultValue="12345,32345,42345")
        int[] pai;
        @Parameter(defaultValue="1234512345,2234512345,3234512345")
        long[] pal;
        @Parameter(defaultValue="123.45,133.45,143.45")
        float[] paf;
        @Parameter(defaultValue="0.12345,-0.12345,1.12345")
        double[] pad;
        @Parameter(defaultValue="x,y,z")
        String[] pas;
        boolean initialized = false;

        public void initialize() throws OperatorException {
            this.initialized = true;
            this.setTargetProduct(new Product("A", "AT", 10, 10));
        }
    }
}

