/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import java.awt.image.RenderedImage;
import javax.media.jai.OpImage;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.runtime.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GPFConfigurationTest {
    private String oldValue;

    @Before
    public void setUp() throws Exception {
        this.oldValue = Config.instance().preferences().get("snap.gpf.disableTileCache", null);
    }

    @After
    public void tearDown() throws Exception {
        if (this.oldValue != null) {
            Config.instance().preferences().put("snap.gpf.disableTileCache", this.oldValue);
        } else {
            Config.instance().preferences().remove("snap.gpf.disableTileCache");
        }
    }

    @Test
    public void testThatTileCacheCanBeDisabled() {
        Config.instance().preferences().put("snap.gpf.disableTileCache", "true");
        Assert.assertNull((Object)this.createOpImage().getTileCache());
    }

    @Test
    public void testThatTileCacheCanBeEnabled() {
        Config.instance().preferences().put("snap.gpf.disableTileCache", "false");
        Assert.assertNotNull((Object)this.createOpImage().getTileCache());
    }

    private OpImage createOpImage() {
        SubsetOp subsetOp = new SubsetOp();
        Product sourceProduct = new Product("name", "type", 16, 16);
        sourceProduct.addBand("x", 12);
        subsetOp.setSourceProduct(sourceProduct);
        Product targetProduct = subsetOp.getTargetProduct();
        RenderedImage image = targetProduct.getBand("x").getSourceImage().getImage(0);
        Assert.assertTrue((boolean)(image instanceof OpImage));
        return (OpImage)image;
    }
}

