/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.internal.DefaultTileIterator;
import org.esa.snap.core.util.BitSetter;

public class DirectDriverTest
extends TestCase {
    static final int W = 4;
    static final int H = 4;
    static final float valueA = 0.4f;
    static final float valueB = 0.5f;

    public void testDirect() {
        MyOp op = new MyOp();
        Product sourceProduct = new Product("N", "T", 4, 4);
        sourceProduct.addBand("a", 30).setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(4.0f), (Float)Float.valueOf(4.0f), (Number[])new Float[]{Float.valueOf(0.4f)}, null));
        sourceProduct.addBand("b", 30).setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(4.0f), (Float)Float.valueOf(4.0f), (Number[])new Float[]{Float.valueOf(0.5f)}, null));
        op.setSourceProduct(sourceProduct);
        Product targetProduct = op.getTargetProduct();
        Band bandC = targetProduct.getBand("c");
        ProductData data = bandC.createCompatibleRasterData(4, 1);
        DirectTile row1 = new DirectTile((RasterDataNode)bandC, data, new Rectangle(0, 0, 4, 1));
        op.computeTile(bandC, row1, ProgressMonitor.NULL);
        DirectDriverTest.assertEquals((Object)Float.valueOf(0.9f), (Object)Float.valueOf(data.getElemFloatAt(0)));
        DirectDriverTest.assertEquals((Object)Float.valueOf(0.9f), (Object)Float.valueOf(data.getElemFloatAt(1)));
        DirectDriverTest.assertEquals((Object)Float.valueOf(0.9f), (Object)Float.valueOf(data.getElemFloatAt(2)));
        DirectDriverTest.assertEquals((Object)Float.valueOf(0.9f), (Object)Float.valueOf(data.getElemFloatAt(3)));
    }

    private static class DirectTile
    implements Tile {
        private final RasterDataNode rasterDataNode;
        private ProductData dataBuffer;
        private final int minX;
        private final int minY;
        private final int maxX;
        private final int maxY;
        private final int width;
        private final int height;
        private final boolean target;
        private final boolean scaled;
        private final boolean signedByte;
        private final byte[] dataBufferByte;
        private final short[] dataBufferShort;
        private final int[] dataBufferInt;
        private final float[] dataBufferFloat;
        private final double[] dataBufferDouble;

        public DirectTile(RasterDataNode rasterDataNode, ProductData dataBuffer, Rectangle rectangle) {
            this(rasterDataNode, dataBuffer, rectangle, true);
        }

        public DirectTile(RasterDataNode rasterDataNode, ProductData dataBuffer, Rectangle rectangle, boolean target) {
            Assert.notNull((Object)rasterDataNode, (String)"rasterDataNode");
            this.rasterDataNode = rasterDataNode;
            this.dataBuffer = dataBuffer;
            this.minX = rectangle.x;
            this.minY = rectangle.y;
            this.maxX = rectangle.x + rectangle.width - 1;
            this.maxY = rectangle.y + rectangle.height - 1;
            this.width = rectangle.width;
            this.height = rectangle.height;
            this.target = target;
            this.scaled = rasterDataNode.isScalingApplied();
            this.signedByte = rasterDataNode.getDataType() == 10;
            this.dataBufferByte = dataBuffer instanceof ProductData.Byte ? ((ProductData.Byte)dataBuffer).getArray() : null;
            this.dataBufferShort = dataBuffer instanceof ProductData.Short ? ((ProductData.Short)dataBuffer).getArray() : null;
            this.dataBufferInt = dataBuffer instanceof ProductData.Int ? ((ProductData.Int)dataBuffer).getArray() : null;
            this.dataBufferFloat = dataBuffer instanceof ProductData.Float ? ((ProductData.Float)dataBuffer).getArray() : null;
            this.dataBufferDouble = dataBuffer instanceof ProductData.Double ? ((ProductData.Double)dataBuffer).getArray() : null;
        }

        public float toGeoPhysical(float sample) {
            return (float)this.rasterDataNode.scale((double)sample);
        }

        public double toGeoPhysical(double sample) {
            return this.rasterDataNode.scale(sample);
        }

        public float toRaw(float sample) {
            return (float)this.rasterDataNode.scaleInverse((double)sample);
        }

        public double toRaw(double sample) {
            return this.rasterDataNode.scaleInverse(sample);
        }

        public final boolean isTarget() {
            return this.target;
        }

        public boolean isSampleValid(int x, int y) {
            return this.rasterDataNode.isPixelValid(x, y);
        }

        public final Rectangle getRectangle() {
            return new Rectangle(this.minX, this.minY, this.width, this.height);
        }

        public final int getMinX() {
            return this.minX;
        }

        public final int getMaxX() {
            return this.maxX;
        }

        public final int getMinY() {
            return this.minY;
        }

        public final int getMaxY() {
            return this.maxY;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final RasterDataNode getRasterDataNode() {
            return this.rasterDataNode;
        }

        public int getDataBufferIndex(int x, int y) {
            return (y - this.minY) * this.width + x - this.minX;
        }

        public synchronized ProductData getDataBuffer() {
            return this.dataBuffer;
        }

        public final byte[] getDataBufferByte() {
            return this.dataBufferByte;
        }

        public final short[] getDataBufferShort() {
            return this.dataBufferShort;
        }

        public final int[] getDataBufferInt() {
            return this.dataBufferInt;
        }

        public final float[] getDataBufferFloat() {
            return this.dataBufferFloat;
        }

        public final double[] getDataBufferDouble() {
            return this.dataBufferDouble;
        }

        public final int getScanlineOffset() {
            return 0;
        }

        public final int getScanlineStride() {
            return this.width;
        }

        public synchronized ProductData getRawSamples() {
            return this.dataBuffer;
        }

        public synchronized void setRawSamples(ProductData rawSamples) {
            if (this.target && rawSamples != this.dataBuffer) {
                Assert.notNull((Object)rawSamples, (String)"rawSamples");
                Assert.argument((rawSamples.getType() == this.dataBuffer.getType() ? 1 : 0) != 0, (String)"rawSamples.getType() == dataBuffer.getType()");
                Assert.argument((rawSamples.getNumElems() == this.dataBuffer.getNumElems() ? 1 : 0) != 0, (String)"rawSamples.getNumElems() == dataBuffer.getNumElems()");
                this.dataBuffer.setElems(rawSamples.getElems());
            }
        }

        public byte[] getSamplesByte() {
            if (this.getRasterDataNode().isValidMaskUsed()) {
                int size = this.width * this.height;
                byte[] samples = new byte[size];
                int i = 0;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int x = this.minX; x <= this.maxX; ++x) {
                        samples[i++] = this.isSampleValid(x, y) ? (byte)this.getSampleInt(x, y) : (byte)0;
                    }
                }
                return samples;
            }
            ProductData data = this.getRawSamples();
            if (!(this.scaled || data.getType() != 10 && data.getType() != 20)) {
                return (byte[])data.getElems();
            }
            int size = data.getNumElems();
            byte[] samples = new byte[size];
            if (this.scaled) {
                for (int i = 0; i < size; ++i) {
                    samples[i] = (byte)this.toGeoPhysical(data.getElemIntAt(i));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    samples[i] = (byte)data.getElemIntAt(i);
                }
            }
            return samples;
        }

        public short[] getSamplesShort() {
            if (this.getRasterDataNode().isValidMaskUsed()) {
                int size = this.width * this.height;
                short[] samples = new short[size];
                int i = 0;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int x = this.minX; x <= this.maxX; ++x) {
                        samples[i++] = this.isSampleValid(x, y) ? (short)this.getSampleInt(x, y) : (short)0;
                    }
                }
                return samples;
            }
            ProductData data = this.getRawSamples();
            if (!(this.scaled || data.getType() != 11 && data.getType() != 21)) {
                return (short[])data.getElems();
            }
            int size = data.getNumElems();
            short[] samples = new short[size];
            if (this.scaled) {
                for (int i = 0; i < size; ++i) {
                    samples[i] = (short)this.toGeoPhysical(data.getElemIntAt(i));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    samples[i] = (short)data.getElemIntAt(i);
                }
            }
            return samples;
        }

        public int[] getSamplesInt() {
            if (this.getRasterDataNode().isValidMaskUsed()) {
                int size = this.width * this.height;
                int[] samples = new int[size];
                int i = 0;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int x = this.minX; x <= this.maxX; ++x) {
                        samples[i++] = this.isSampleValid(x, y) ? this.getSampleInt(x, y) : 0;
                    }
                }
                return samples;
            }
            ProductData data = this.getRawSamples();
            if (!(this.scaled || data.getType() != 12 && data.getType() != 22)) {
                return (int[])data.getElems();
            }
            int size = data.getNumElems();
            int[] samples = new int[size];
            if (this.scaled) {
                for (int i = 0; i < size; ++i) {
                    samples[i] = (int)this.toGeoPhysical(data.getElemIntAt(i));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    samples[i] = data.getElemIntAt(i);
                }
            }
            return samples;
        }

        public float[] getSamplesFloat() {
            if (this.getRasterDataNode().isValidMaskUsed()) {
                int size = this.width * this.height;
                float[] samples = new float[size];
                int i = 0;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int x = this.minX; x <= this.maxX; ++x) {
                        samples[i++] = this.isSampleValid(x, y) ? this.getSampleFloat(x, y) : Float.NaN;
                    }
                }
                return samples;
            }
            ProductData data = this.getRawSamples();
            if (!this.scaled && data.getType() == 30) {
                return (float[])data.getElems();
            }
            int size = data.getNumElems();
            float[] samples = new float[size];
            if (this.scaled) {
                for (int i = 0; i < size; ++i) {
                    samples[i] = this.toGeoPhysical(data.getElemFloatAt(i));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    samples[i] = data.getElemFloatAt(i);
                }
            }
            return samples;
        }

        public double[] getSamplesDouble() {
            if (this.getRasterDataNode().isValidMaskUsed()) {
                int size = this.width * this.height;
                double[] samples = new double[size];
                int i = 0;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int x = this.minX; x <= this.maxX; ++x) {
                        samples[i++] = this.isSampleValid(x, y) ? this.getSampleDouble(x, y) : Double.NaN;
                    }
                }
                return samples;
            }
            ProductData data = this.getRawSamples();
            if (!this.scaled && data.getType() == 30) {
                return (double[])data.getElems();
            }
            int size = data.getNumElems();
            double[] samples = new double[size];
            if (this.scaled) {
                for (int i = 0; i < size; ++i) {
                    samples[i] = this.toGeoPhysical(data.getElemDoubleAt(i));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    samples[i] = data.getElemDoubleAt(i);
                }
            }
            return samples;
        }

        public void setSamples(byte[] samples) {
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.setSample(x, y, samples[i++]);
                }
            }
        }

        public void setSamples(short[] samples) {
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.setSample(x, y, samples[i++]);
                }
            }
        }

        public void setSamples(int[] samples) {
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.setSample(x, y, samples[i++]);
                }
            }
        }

        public void setSamples(float[] samples) {
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.setSample(x, y, samples[i++]);
                }
            }
        }

        public void setSamples(double[] samples) {
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.setSample(x, y, samples[i++]);
                }
            }
        }

        public boolean getSampleBoolean(int x, int y) {
            return this.getSampleInt(x, y) != 0;
        }

        public void setSample(int x, int y, boolean sample) {
            this.setSample(x, y, sample ? 1 : 0);
        }

        public int getSampleInt(int x, int y) {
            int sample = this.dataBuffer.getElemIntAt(this.index(x, y));
            if (this.signedByte) {
                sample = (byte)sample;
            }
            if (this.scaled) {
                sample = (int)Math.floor((double)this.toGeoPhysical(sample) + 0.5);
            }
            return sample;
        }

        public void setSample(int x, int y, int sample) {
            if (this.scaled) {
                sample = (int)Math.floor(this.toRaw((double)sample) + 0.5);
            }
            this.dataBuffer.setElemIntAt(this.index(x, y), sample);
        }

        public float getSampleFloat(int x, int y) {
            float sample = this.dataBuffer.getElemFloatAt(this.index(x, y));
            if (this.signedByte) {
                sample = (byte)sample;
            }
            if (this.scaled) {
                sample = this.toGeoPhysical(sample);
            }
            return sample;
        }

        public void setSample(int x, int y, float sample) {
            if (this.scaled) {
                sample = this.toRaw(sample);
            }
            this.dataBuffer.setElemFloatAt(this.index(x, y), sample);
        }

        public double getSampleDouble(int x, int y) {
            double sample = this.dataBuffer.getElemDoubleAt(this.index(x, y));
            if (this.signedByte) {
                sample = (byte)sample;
            }
            if (this.scaled) {
                sample = this.toGeoPhysical(sample);
            }
            return sample;
        }

        public void setSample(int x, int y, double sample) {
            if (this.scaled) {
                sample = this.toRaw(sample);
            }
            this.dataBuffer.setElemDoubleAt(this.index(x, y), sample);
        }

        public boolean getSampleBit(int x, int y, int bitIndex) {
            long sample = this.dataBuffer.getElemUIntAt(this.index(x, y));
            return BitSetter.isFlagSet((long)sample, (int)bitIndex);
        }

        public void setSample(int x, int y, int bitIndex, boolean sample) {
            long longSample = this.dataBuffer.getElemUIntAt(this.index(x, y));
            long newSample = BitSetter.setFlag((long)longSample, (int)bitIndex, (boolean)sample);
            this.dataBuffer.setElemUIntAt(this.index(x, y), newSample);
        }

        public Iterator<Tile.Pos> iterator() {
            return new DefaultTileIterator(this.getRectangle());
        }

        private int index(int x, int y) {
            return (y - this.minY) * (this.maxY - this.minY + 1) + x - this.minX;
        }
    }

    public static class MyOp
    extends Operator {
        @SourceProduct
        Product sourceProduct;
        @TargetProduct
        Product targetProduct;

        public void initialize() throws OperatorException {
            this.targetProduct = new Product("N", "T", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            this.targetProduct.addBand("c", 30);
        }

        public void computeTile(Band targetBand, Tile tileC, ProgressMonitor pm) throws OperatorException {
            Tile tileA = this.getSourceTile((RasterDataNode)this.getSourceProduct().getBand("a"), tileC.getRectangle());
            Tile tileB = this.getSourceTile((RasterDataNode)this.getSourceProduct().getBand("b"), tileC.getRectangle());
            for (Tile.Pos pos : tileC) {
                float a = tileA.getSampleFloat(pos.x, pos.y);
                float b = tileB.getSampleFloat(pos.x, pos.y);
                float c = a + b;
                tileC.setSample(pos.x, pos.y, c);
            }
        }
    }
}

