/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

public class AreaOperatorTest
extends TestCase {
    public void testBasicOperatorStates() throws OperatorException {
        Product sourceProduct = new Product("foo", "grunt", 4, 4);
        Band band = sourceProduct.addBand("bar", 30);
        band.setRasterData(ProductData.createInstance((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 2.0f, 3.0f, 4.0f, 5.0f, 3.0f, 4.0f, 5.0f, 6.0f, 4.0f, 5.0f, 6.0f, 7.0f}));
        SomeAreaOp op = new SomeAreaOp();
        op.setSourceProduct(sourceProduct);
        op.bandName = band.getName();
        op.kernelSize = 3;
        Product targetProduct = op.getTargetProduct();
        Raster data = targetProduct.getBand(op.bandName).getSourceImage().getData();
        float X = Float.NaN;
        float[] expectedSamples = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, 1.0f, 2.0f, Float.NaN, Float.NaN, 2.0f, 3.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        for (int i = 0; i < expectedSamples.length; ++i) {
            float expectedSample = expectedSamples[i];
            AreaOperatorTest.assertEquals((Object)Float.valueOf(expectedSample), (Object)Float.valueOf(data.getSampleFloat(i % 4, i / 4, 0)));
        }
    }

    private static class SomeAreaOp
    extends Operator {
        @SourceProduct
        private Product sourceProduct;
        @TargetProduct
        private Product targetProduct;
        @Parameter
        String bandName;
        @Parameter(defaultValue="3")
        int kernelSize;
        private Band sourceBand;
        private Band targetBand;

        private SomeAreaOp() {
        }

        public void initialize() throws OperatorException {
            this.sourceBand = this.sourceProduct.getBand(this.bandName);
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            this.targetBand = this.targetProduct.addBand(this.bandName, this.sourceBand.getDataType());
        }

        public void computeTile(Band band, Tile tile, ProgressMonitor pm) throws OperatorException {
            if (band == this.targetBand) {
                int border = this.kernelSize / 2;
                Rectangle sourceRegion = tile.getRectangle();
                sourceRegion.grow(border, border);
                Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceBand, sourceRegion, (BorderExtender)new BorderExtenderConstant(new double[]{Double.NaN}));
                for (int y = tile.getMinY(); y <= tile.getMaxY(); ++y) {
                    for (int x = tile.getMinX(); x <= tile.getMaxX(); ++x) {
                        tile.setSample(x, y, this.computeMin(sourceTile, x, y, border));
                    }
                }
            }
        }

        private double computeMin(Tile sourceTile, int x, int y, int border) {
            double min = Double.MAX_VALUE;
            for (int j = y - border; j <= y + border; ++j) {
                for (int i = x - border; i <= x + border; ++i) {
                    min = Math.min(min, sourceTile.getSampleDouble(i, j));
                }
            }
            return min;
        }
    }
}

