/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.pointop;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.text.ParseException;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SampleOperator;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.ProductUtils;
import org.junit.Assert;
import org.junit.Test;

public class PointOperatorTest {
    private static final int M = 0x100000;
    private static final int W = 1121;
    private static final int H = 2242;
    private static final long[] CACHE_SIZES = new long[]{0L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, Runtime.getRuntime().maxMemory() / 0x100000L * 0x100000L};

    public static void main(String[] args) throws ParseException {
        new PointOperatorTest().runTestsWithDifferentTileCacheCapacities();
    }

    private void runTestsWithDifferentTileCacheCapacities() throws ParseException {
        for (long cacheSize : CACHE_SIZES) {
            this.testPointOp(new NdviTileOp(), cacheSize);
        }
        for (long cacheSize : CACHE_SIZES) {
            this.testPointOp((Operator)new NdviSampleOp(), cacheSize);
        }
        for (long cacheSize : CACHE_SIZES) {
            this.testPointOp(new NdviTileStackOp(), cacheSize);
        }
        for (long cacheSize : CACHE_SIZES) {
            this.testPointOp((Operator)new NdviPixelOp(), cacheSize);
        }
    }

    @Test
    public void testNdviSampleOp() throws ParseException {
        this.testPointOp((Operator)new NdviSampleOp(), 0x8000000L);
    }

    @Test
    public void testNdviPixelOp() throws ParseException {
        this.testPointOp((Operator)new NdviPixelOp(), 0x8000000L);
    }

    @Test
    public void testNdviPixelOpWithGaps() throws ParseException {
        this.testPointOp((Operator)new NdviPixelOpWithGaps(), 0x8000000L);
    }

    private void testPointOp(Operator op, long cacheSize) throws ParseException {
        if (cacheSize <= 0L) {
            JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0L);
            JAI.disableDefaultTileCache();
        } else {
            JAI.getDefaultInstance().getTileCache().setMemoryCapacity(cacheSize);
            JAI.enableDefaultTileCache();
        }
        Product sourceProduct = this.createSourceProduct(1121, 2242);
        op.setSourceProduct(sourceProduct);
        Product targetProduct = op.getTargetProduct();
        Assert.assertEquals((Object)sourceProduct.getStartTime(), (Object)targetProduct.getStartTime());
        Assert.assertEquals((Object)sourceProduct.getEndTime(), (Object)targetProduct.getEndTime());
        Assert.assertNotNull((Object)targetProduct.getTiePointGrid("latitude"));
        Assert.assertNotNull((Object)targetProduct.getTiePointGrid("longitude"));
        Assert.assertTrue((boolean)(targetProduct.getSceneGeoCoding() instanceof TiePointGeoCoding));
        Assert.assertNotNull((Object)targetProduct.getBand("ndvi"));
        Assert.assertNotNull((Object)targetProduct.getBand("ndvi_flags"));
        long t0 = System.nanoTime();
        Raster ndviData = targetProduct.getBand("ndvi").getGeophysicalImage().getData();
        Raster ndviFlagsData = targetProduct.getBand("ndvi_flags").getGeophysicalImage().getData();
        long t1 = System.nanoTime();
        double time = (double)(t1 - t0) * 1.0E-9;
        double mpixels = 2513282.0 / time / 1000000.0;
        System.out.println(op.getClass().getSimpleName() + ":");
        System.out.println("  Cache size: " + JAI.getDefaultInstance().getTileCache().getMemoryCapacity() / 0x100000L + " M");
        System.out.println("  Total time: " + time + " s");
        System.out.println("  Throughput: " + mpixels + " mega-pixels/s");
        Assert.assertEquals((float)0.2f, (float)ndviData.getSampleFloat(0, 0, 0), (float)1.0E-5f);
        Assert.assertEquals((float)0.2f, (float)ndviData.getSampleFloat(0, 1, 0), (float)1.0E-5f);
        Assert.assertEquals((float)0.2f, (float)ndviData.getSampleFloat(1, 0, 0), (float)1.0E-5f);
        Assert.assertEquals((float)0.2f, (float)ndviData.getSampleFloat(1, 1, 0), (float)1.0E-5f);
        Assert.assertEquals((long)0L, (long)ndviFlagsData.getSample(0, 0, 0));
        Assert.assertEquals((long)0L, (long)ndviFlagsData.getSample(0, 1, 0));
        Assert.assertEquals((long)0L, (long)ndviFlagsData.getSample(1, 0, 0));
        Assert.assertEquals((long)0L, (long)ndviFlagsData.getSample(1, 1, 0));
    }

    private Product createSourceProduct(int w, int h) throws ParseException {
        Product sourceProduct = new Product("TEST.N1", "MER_RR__1P", w, h);
        sourceProduct.setStartTime(ProductData.UTC.parse((String)"17-Jan-2008 12:13:27"));
        sourceProduct.setEndTime(ProductData.UTC.parse((String)"17-Jan-2008 13:16:28"));
        Band rad08 = sourceProduct.addBand("radiance_8", 11);
        Band rad10 = sourceProduct.addBand("radiance_10", 11);
        rad08.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(1.0f * (float)w), (Float)Float.valueOf(1.0f * (float)h), (Number[])new Short[]{(short)2000}, null));
        rad10.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(1.0f * (float)w), (Float)Float.valueOf(1.0f * (float)h), (Number[])new Short[]{(short)3000}, null));
        rad08.setScalingFactor(0.01);
        rad10.setScalingFactor(0.01);
        TiePointGrid lat = new TiePointGrid("latitude", w, h, 0.0, 0.0, 1.0, 1.0, new float[w * h]);
        TiePointGrid lon = new TiePointGrid("longitude", w, h, 0.0, 0.0, 1.0, 1.0, new float[w * h]);
        sourceProduct.addTiePointGrid(lat);
        sourceProduct.addTiePointGrid(lon);
        sourceProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(lat, lon));
        return sourceProduct;
    }

    public static class NdviTileOp
    extends NdviStdOp {
        public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            Product product = this.getSourceProduct();
            Rectangle targetRectangle = targetTile.getRectangle();
            Tile sourceTile1 = this.getSourceTile((RasterDataNode)product.getBand("radiance_10"), targetRectangle);
            Tile sourceTile2 = this.getSourceTile((RasterDataNode)product.getBand("radiance_8"), targetRectangle);
            for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                for (int x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    float upper = sourceTile1.getSampleFloat(x, y);
                    float lower = sourceTile2.getSampleFloat(x, y);
                    float ndviValue = (upper - lower) / (upper + lower);
                    if ("ndvi".equals(targetBand.getName())) {
                        targetTile.setSample(x, y, ndviValue);
                        continue;
                    }
                    if (!"ndvi_flags".equals(targetBand.getName())) continue;
                    int ndviFlags = (ndviValue < 0.0f ? 1 : 0) | (ndviValue > 1.0f ? 2 : 0);
                    targetTile.setSample(x, y, ndviFlags);
                }
            }
        }
    }

    public static class NdviTileStackOp
    extends NdviStdOp {
        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
            Product product = this.getSourceProduct();
            Tile sourceTile1 = this.getSourceTile((RasterDataNode)product.getBand("radiance_10"), targetRectangle);
            Tile sourceTile2 = this.getSourceTile((RasterDataNode)product.getBand("radiance_8"), targetRectangle);
            Tile ndviTile = targetTiles.get(this.getTargetProduct().getBand("ndvi"));
            Tile ndviFlagsTile = targetTiles.get(this.getTargetProduct().getBand("ndvi_flags"));
            for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                for (int x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    float lower;
                    float upper = sourceTile1.getSampleFloat(x, y);
                    float ndviValue = (upper - (lower = sourceTile2.getSampleFloat(x, y))) / (upper + lower);
                    int ndviFlags = (ndviValue < 0.0f ? 1 : 0) | (ndviValue > 1.0f ? 2 : 0);
                    ndviTile.setSample(x, y, ndviValue);
                    ndviFlagsTile.setSample(x, y, ndviFlags);
                }
            }
        }
    }

    public static class NdviStdOp
    extends Operator {
        public void initialize() throws OperatorException {
            Product inputProduct = this.getSourceProduct();
            int sceneWidth = inputProduct.getSceneRasterWidth();
            int sceneHeight = this.getSourceProduct().getSceneRasterHeight();
            Product targetProduct = new Product("ndvi", "NDVI_TYPE", sceneWidth, sceneHeight);
            targetProduct.setStartTime(inputProduct.getStartTime());
            targetProduct.setEndTime(inputProduct.getEndTime());
            ProductUtils.copyTiePointGrids((Product)inputProduct, (Product)targetProduct);
            ProductUtils.copyGeoCoding((Product)inputProduct, (Product)targetProduct);
            Band ndviOutputBand = new Band("ndvi", 30, sceneWidth, sceneHeight);
            targetProduct.addBand(ndviOutputBand);
            Band ndviFlagsOutputBand = new Band("ndvi_flags", 11, sceneWidth, sceneHeight);
            ndviFlagsOutputBand.setDescription("NDVI specific flags");
            targetProduct.addBand(ndviFlagsOutputBand);
            this.setTargetProduct(targetProduct);
        }
    }

    public static class NdviPixelOpWithGaps
    extends PixelOperator {
        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            productConfigurer.addBand("ndvi", 30);
            productConfigurer.addBand("ndvi_flags", 11);
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(86, "radiance_10");
            sampleConfigurer.defineSample(423, "radiance_8");
        }

        public void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(34, "ndvi");
            sampleConfigurer.defineSample(687, "ndvi_flags");
        }

        protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
            double rad2;
            double rad1 = sourceSamples[86].getDouble();
            double ndvi = (rad1 - (rad2 = sourceSamples[423].getDouble())) / (rad1 + rad2);
            int ndviFlags = (ndvi < 0.0 ? 1 : 0) | (ndvi > 1.0 ? 2 : 0);
            targetSamples[34].set(ndvi);
            targetSamples[687].set(ndviFlags);
        }
    }

    public static class NdviPixelOp
    extends PixelOperator {
        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            productConfigurer.addBand("ndvi", 30);
            productConfigurer.addBand("ndvi_flags", 11);
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(0, "radiance_10");
            sampleConfigurer.defineSample(1, "radiance_8");
        }

        public void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(0, "ndvi");
            sampleConfigurer.defineSample(1, "ndvi_flags");
        }

        protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
            double rad2;
            double rad1 = sourceSamples[0].getDouble();
            double ndvi = (rad1 - (rad2 = sourceSamples[1].getDouble())) / (rad1 + rad2);
            int ndviFlags = (ndvi < 0.0 ? 1 : 0) | (ndvi > 1.0 ? 2 : 0);
            targetSamples[0].set(ndvi);
            targetSamples[1].set(ndviFlags);
        }
    }

    public static class NdviSampleOp
    extends SampleOperator {
        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            productConfigurer.addBand("ndvi", 30);
            productConfigurer.addBand("ndvi_flags", 11);
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(0, "radiance_10");
            sampleConfigurer.defineSample(1, "radiance_8");
        }

        public void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(0, "ndvi");
            sampleConfigurer.defineSample(1, "ndvi_flags");
        }

        protected void computeSample(int x, int y, Sample[] sourceSamples, WritableSample targetSample) {
            double rad1 = sourceSamples[0].getDouble();
            double rad2 = sourceSamples[1].getDouble();
            double ndvi = (rad1 - rad2) / (rad1 + rad2);
            if (targetSample.getIndex() == 0) {
                targetSample.set(ndvi);
            } else if (targetSample.getIndex() == 1) {
                int ndviFlags = (ndvi < 0.0 ? 1 : 0) | (ndvi > 1.0 ? 2 : 0);
                targetSample.set(ndviFlags);
            }
        }
    }
}

