/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.pointop;

import java.awt.image.RenderedImage;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.PointOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SampleOperator;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.junit.Assert;
import org.junit.Test;

public class PointOperatorInitialiseTest {
    @Test
    public void testInitialiseSequenceOfSampleOperator() throws Exception {
        TracingSampleOperator operator = new TracingSampleOperator();
        operator.setSourceProduct(new Product("N", "T", 200, 100));
        operator.getTargetProduct();
        Assert.assertEquals((Object)"12345", (Object)operator.trace);
    }

    @Test
    public void testInitialiseSequenceOfPixelOperator() throws Exception {
        TracingPixelOperator operator = new TracingPixelOperator();
        operator.setSourceProduct(new Product("N", "T", 200, 100));
        operator.getTargetProduct();
        Assert.assertEquals((Object)"12345", (Object)operator.trace);
    }

    @Test
    public void testDefaultValidateInputShallNotFail() throws Exception {
        EmptyPointOperator operator = new EmptyPointOperator();
        operator.setSourceProducts(new Product[]{new Product("N1", "T", 200, 100), new Product("N2", "T", 200, 100), new Product("N3", "T", 200, 100)});
        try {
            operator.getTargetProduct();
        }
        catch (OperatorException e) {
            Assert.fail((String)"OperatorException not expected.");
        }
    }

    @Test
    public void testDefaultValidateInputShallFail() throws Exception {
        EmptyPointOperator operator = new EmptyPointOperator();
        operator.setSourceProducts(new Product[]{new Product("N1", "T", 200, 100), new Product("N2", "T", 200, 100), new Product("N3", "T", 200, 101)});
        try {
            operator.getTargetProduct();
            Assert.fail((String)"OperatorException expected.");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    @Test
    public void testThatOnlyExistingBandsCanProvideSourceSamples() throws Exception {
        BadSourceSamplePointOperator operator = new BadSourceSamplePointOperator();
        operator.setSourceProducts(new Product[]{new Product("N1", "T", 200, 100)});
        try {
            operator.getTargetProduct();
            Assert.fail((String)"OperatorException expected, because only existing bands can provide source samples.");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"Product 'N1' does not contain a raster with name 'missing_band'", (Object)e.getMessage());
        }
    }

    @Test
    public void testThatOnlySourcelessBandsCanProvideTargetSamples() throws Exception {
        BadTargetSamplePointOperator operator = new BadTargetSamplePointOperator();
        operator.setSourceProducts(new Product[]{new Product("N1", "T", 200, 100)});
        try {
            operator.getTargetProduct();
            Assert.fail((String)"OperatorException expected, because only sourceless bands can provide target samples.");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"Raster 'const_7' must be sourceless, since it is a computed target", (Object)e.getMessage());
        }
    }

    private static class BadTargetSamplePointOperator
    extends PointOperator {
        private BadTargetSamplePointOperator() {
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            Band band = productConfigurer.addBand("const_7", 30);
            band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(productConfigurer.getTargetProduct().getSceneRasterWidth()), (Float)Float.valueOf(productConfigurer.getTargetProduct().getSceneRasterHeight()), (Number[])new Float[]{Float.valueOf(7.0f)}, null));
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineSample(0, "const_7");
        }
    }

    private static class BadSourceSamplePointOperator
    extends PointOperator {
        private BadSourceSamplePointOperator() {
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineSample(0, "missing_band");
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        }
    }

    private static class EmptyPointOperator
    extends PointOperator {
        private EmptyPointOperator() {
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        }
    }

    private static class TracingSampleOperator
    extends SampleOperator {
        String trace = "";

        private TracingSampleOperator() {
        }

        protected void prepareInputs() throws OperatorException {
            this.trace = this.trace + "1";
        }

        protected Product createTargetProduct() throws OperatorException {
            this.trace = this.trace + "2";
            return super.createTargetProduct();
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            this.trace = this.trace + "3";
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            this.trace = this.trace + "4";
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            this.trace = this.trace + "5";
        }

        protected void computeSample(int x, int y, Sample[] sourceSamples, WritableSample targetSample) {
        }
    }

    private static class TracingPixelOperator
    extends PixelOperator {
        String trace = "";

        private TracingPixelOperator() {
        }

        protected void prepareInputs() throws OperatorException {
            this.trace = this.trace + "1";
        }

        protected Product createTargetProduct() throws OperatorException {
            this.trace = this.trace + "2";
            return super.createTargetProduct();
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            this.trace = this.trace + "3";
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            this.trace = this.trace + "4";
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            this.trace = this.trace + "5";
        }

        protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        }
    }
}

