/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.pointop;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SampleOperator;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.junit.Assert;
import org.junit.Test;

public class PixelOperatorWithComputedSourcesTest {
    @Test
    public void testOp() throws Exception {
        Product sp = new Product("N", "T", 2, 2);
        sp.addBand("input", "0.1", 31);
        OpWithComputedSources op = new OpWithComputedSources();
        op.setSourceProduct(sp);
        Product tp = op.getTargetProduct();
        double[] output = new double[4];
        tp.getBand("output").readPixels(0, 0, 2, 2, output);
        Assert.assertEquals((double)22.0, (double)output[0], (double)1.0E-5);
        Assert.assertEquals((double)999.0, (double)output[1], (double)1.0E-5);
        Assert.assertEquals((double)0.2, (double)output[2], (double)1.0E-5);
        Assert.assertEquals((double)999.0, (double)output[3], (double)1.0E-5);
    }

    @Test
    public void testOpWith2Products() throws Exception {
        Product sp1 = new Product("N", "T", 2, 2);
        sp1.addBand("input", "0.1", 31);
        Product sp2 = new Product("O", "T", 2, 2);
        sp2.addBand("input", "0.2", 31);
        OpWithComputedSourcesFrom2Products op = new OpWithComputedSourcesFrom2Products();
        op.setSourceProduct(sp1);
        op.setSourceProduct("source2", sp2);
        Product tp = op.getTargetProduct();
        double[] output = new double[4];
        tp.getBand("output").readPixels(0, 0, 2, 2, output);
        Assert.assertEquals((double)1.0, (double)output[0], (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)output[1], (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)output[2], (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)output[3], (double)1.0E-5);
    }

    @Test
    public void testOpWith2ProductsWithoutRefNo() throws Exception {
        Product sp1 = new Product("N", "T", 2, 2);
        sp1.addBand("input", "0.1", 31);
        Product sp2 = new Product("O", "T", 2, 2);
        sp2.addBand("input", "0.2", 31);
        OpWithoutRefNo op = new OpWithoutRefNo();
        op.setSourceProduct(sp1);
        op.setSourceProduct("source2", sp2);
        try {
            op.getTargetProduct();
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            Assert.assertNotNull((Object)iae);
            Assert.assertEquals((Object)"Product 'N' has no assigned reference number.", (Object)iae.getMessage());
        }
    }

    static class OpWithoutRefNo
    extends SampleOperator {
        OpWithoutRefNo() {
        }

        protected void computeSample(int x, int y, Sample[] sourceSamples, WritableSample targetSample) {
            targetSample.set(sourceSamples[0].getDouble());
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineComputedSample(0, 20, "$1.Y < 1 AND $2.X > 0", this.getSourceProducts());
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineSample(0, "output");
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            productConfigurer.addBand("output", 20);
        }
    }

    static class OpWithComputedSourcesFrom2Products
    extends SampleOperator {
        OpWithComputedSourcesFrom2Products() {
        }

        protected void computeSample(int x, int y, Sample[] sourceSamples, WritableSample targetSample) {
            targetSample.set(sourceSamples[0].getDouble());
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            this.getSourceProduct().setRefNo(1);
            this.getSourceProduct("source2").setRefNo(2);
            sampleConfigurer.defineComputedSample(0, 20, "$1.Y < 1 AND $2.X > 0", this.getSourceProducts());
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineSample(0, "output");
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            productConfigurer.addBand("output", 20);
        }
    }

    static class OpWithComputedSources
    extends SampleOperator {
        OpWithComputedSources() {
        }

        protected void computeSample(int x, int y, Sample[] sourceSamples, WritableSample targetSample) {
            if (sourceSamples[0].getBoolean()) {
                targetSample.set(sourceSamples[2].getDouble());
            } else {
                targetSample.set(sourceSamples[1].getDouble());
            }
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.setValidPixelMask("X < 1");
            sampleConfigurer.defineComputedSample(0, 20, "Y < 1", new Product[0]);
            sampleConfigurer.defineComputedSample(1, 31, "2 * input", new Product[0]);
            sampleConfigurer.defineComputedSample(2, 1, new Kernel(2, 2, new double[]{10.0, 0.0, 100.0, 0.0}));
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
            sampleConfigurer.defineSample(0, "output");
        }

        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            Band output = productConfigurer.addBand("output", 31);
            output.setNoDataValue(999.0);
            output.setNoDataValueUsed(true);
        }
    }
}

