/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.multisize;

import com.bc.ceres.glevel.MultiLevelModel;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.gpf.common.reproject.ReprojectionOp;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MultiSizeSupportTest {
    private OperatorSpi bandMathsSpi;
    private Product product;
    private SubsetOp.Spi subsetOpSpi;
    private ReprojectionOp.Spi reprojectionOpSpi;

    @Before
    public void setUp() {
        this.product = new Product("dummyProduct", "dummyType", 5, 5);
        this.bandMathsSpi = new BandMathsOp.Spi();
        this.subsetOpSpi = new SubsetOp.Spi();
        this.reprojectionOpSpi = new ReprojectionOp.Spi();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(this.bandMathsSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.subsetOpSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.reprojectionOpSpi);
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi(this.bandMathsSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.subsetOpSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.reprojectionOpSpi);
    }

    @Test
    @Ignore
    public void testSubset() {
        AffineTransform imageToModelTransform = Product.findImageToModelTransform((GeoCoding)this.product.getSceneGeoCoding());
        int height = this.product.getSceneRasterHeight();
        int width = this.product.getSceneRasterWidth();
        double xCoord1 = (double)width * 0.25;
        double xCoord2 = (double)width * 0.75;
        double yCoord1 = (double)height * 0.75;
        double yCoord2 = (double)height * 0.75;
        Point2D subsetCoordinate1 = imageToModelTransform.transform((Point2D)new PixelPos(xCoord1, yCoord1), null);
        Point2D subsetCoordinate2 = imageToModelTransform.transform((Point2D)new PixelPos(xCoord1, yCoord2), null);
        Point2D subsetCoordinate3 = imageToModelTransform.transform((Point2D)new PixelPos(xCoord2, yCoord1), null);
        Point2D subsetCoordinate4 = imageToModelTransform.transform((Point2D)new PixelPos(xCoord2, yCoord2), null);
        Rectangle2D.Double subsetImageBounds = new Rectangle2D.Double(xCoord1, yCoord1, xCoord2 - xCoord1, yCoord2 - yCoord1);
        Rectangle2D subsetModelBounds = imageToModelTransform.createTransformedShape(subsetImageBounds).getBounds2D();
        GeometryFactory gf = new GeometryFactory();
        Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(subsetCoordinate1.getX(), subsetCoordinate1.getY()), new Coordinate(subsetCoordinate2.getX(), subsetCoordinate2.getY()), new Coordinate(subsetCoordinate3.getX(), subsetCoordinate3.getY()), new Coordinate(subsetCoordinate4.getX(), subsetCoordinate4.getY()), new Coordinate(subsetCoordinate1.getX(), subsetCoordinate1.getY())}), null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("geoRegion", polygon.toText());
        Product subset = GPF.createProduct((String)"Subset", parameters, (Product)this.product);
        Assert.assertEquals((int)(width / 2), (int)subset.getSceneRasterWidth());
        Assert.assertEquals((int)(height / 2), (int)subset.getSceneRasterHeight());
        ProductNodeGroup productBandGroup = this.product.getBandGroup();
        Rectangle2D[] expectedImageSizes = new Rectangle2D[productBandGroup.getNodeCount()];
        for (int i = 0; i < productBandGroup.getNodeCount(); ++i) {
            Band band = (Band)productBandGroup.get(i);
            MultiLevelModel multiLevelModel = band.getMultiLevelModel();
            Rectangle2D modelBounds = multiLevelModel.getModelBounds();
            Rectangle2D intersection = modelBounds.createIntersection(subsetModelBounds);
            expectedImageSizes[i] = multiLevelModel.getModelToImageTransform(0).createTransformedShape(intersection).getBounds2D();
        }
        ProductNodeGroup subsetBandGroup = subset.getBandGroup();
        for (int i = 0; i < subsetBandGroup.getNodeCount(); ++i) {
            Assert.assertEquals((Object)expectedImageSizes[i].getWidth(), (Object)((Band)subsetBandGroup.get(i)).getRasterWidth());
            Assert.assertEquals((Object)expectedImageSizes[i].getHeight(), (Object)((Band)subsetBandGroup.get(i)).getRasterHeight());
        }
    }

    @Test
    @Ignore
    public void testReprojection() {
        String WGS84_CODE = "EPSG:4326";
        HashMap<String, String> parameterMap = new HashMap<String, String>(5);
        parameterMap.put("crs", "EPSG:4326");
        Product reprojectedProduct = GPF.createProduct((String)"Reproject", parameterMap, (Product)this.product);
        Assert.assertNotNull((Object)reprojectedProduct.getSceneGeoCoding());
        ProductNodeGroup productBandGroup = this.product.getBandGroup();
        ProductNodeGroup reprojectedProductBandGroup = reprojectedProduct.getBandGroup();
        for (int i = 0; i < productBandGroup.getNodeCount() - 1; ++i) {
            Band band1 = (Band)productBandGroup.get(i);
            CoordinateReferenceSystem modelCrs1 = Product.findModelCRS((GeoCoding)band1.getGeoCoding());
            Band reprojectedBand1 = (Band)reprojectedProductBandGroup.get(band1.getName());
            CoordinateReferenceSystem reprojectedModelCrs1 = Product.findModelCRS((GeoCoding)reprojectedBand1.getGeoCoding());
            for (int j = i + 1; j < productBandGroup.getNodeCount(); ++j) {
                Band band2 = (Band)productBandGroup.get(j);
                CoordinateReferenceSystem modelCrs2 = Product.findModelCRS((GeoCoding)band2.getGeoCoding());
                Band reprojectedBand2 = (Band)reprojectedProductBandGroup.get(band2.getName());
                CoordinateReferenceSystem reprojectedModelCrs2 = Product.findModelCRS((GeoCoding)reprojectedBand2.getGeoCoding());
                Assert.assertEquals((boolean)band1.getRasterSize().equals(band2.getRasterSize()), (boolean)reprojectedBand1.getRasterSize().equals(reprojectedBand2.getRasterSize()));
                Assert.assertEquals((modelCrs1 == modelCrs2 ? 1 : 0) != 0, (reprojectedModelCrs1 == reprojectedModelCrs2 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    @Ignore
    public void testBandMaths() {
        ProductNodeGroup bandGroup = this.product.getBandGroup();
        for (int i = 0; i < bandGroup.getNodeCount() - 1; ++i) {
            Band band1 = (Band)bandGroup.get(i);
            for (int j = i; j < bandGroup.getNodeCount(); ++j) {
                Band band2 = (Band)bandGroup.get(j);
                HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
                BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[]{MultiSizeSupportTest.createBandDescription("aBandName", band1.getName() + " + " + band2.getName(), "float32", "bigUnits", null, null)};
                parameters.put("targetBands", bandDescriptors);
                try {
                    GPF.createProduct((String)"BandMaths", parameters, (Product)this.product);
                    if (band1.getRasterSize().equals(band2.getRasterSize())) continue;
                    TestCase.fail((String)"Could create band maths for differently sized bands");
                    continue;
                }
                catch (OperatorException oe) {
                    if (!band1.getRasterSize().equals(band2.getRasterSize())) continue;
                    TestCase.fail((String)("Could not create band maths for equally sized bands: " + oe.getMessage()));
                }
            }
        }
    }

    private static BandMathsOp.BandDescriptor createBandDescription(String bandName, String expression, String type, String unit, Double scalingFactor, Double scalingOffset) {
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = bandName;
        bandDescriptor.description = "aDescription";
        bandDescriptor.expression = expression;
        bandDescriptor.type = type;
        bandDescriptor.unit = unit;
        bandDescriptor.scalingFactor = scalingFactor;
        bandDescriptor.scalingOffset = scalingOffset;
        return bandDescriptor;
    }
}

