/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.SnapFileFilter;

public class TestProductIOPlugIn
implements ProductReaderPlugIn,
ProductWriterPlugIn {
    public static final Class<Object> PARAMETER_TYPE = Object.class;
    public static final String FORMAT_NAME = "TESTDATA";
    public static final String FILE_EXT = ".testdata";
    public static final String FORMAT_DESCRIPTION = "Testdata format for unit-level testing";
    public static final TestProductIOPlugIn INSTANCE = new TestProductIOPlugIn();
    private final Map<Object, Product> sourceProducts = Collections.synchronizedMap(new HashMap());
    private final Map<Object, Product> targetProducts = Collections.synchronizedMap(new HashMap());

    public Map<Object, Product> getSourceProducts() {
        return this.sourceProducts;
    }

    public Map<Object, Product> getTargetProducts() {
        return this.targetProducts;
    }

    public void clear() {
        this.sourceProducts.clear();
        this.targetProducts.clear();
    }

    public EncodeQualification getEncodeQualification(Product product) {
        return EncodeQualification.FULL;
    }

    public DecodeQualification getDecodeQualification(Object input) {
        return this.sourceProducts.containsKey(input) ? DecodeQualification.INTENDED : DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{PARAMETER_TYPE};
    }

    public Class[] getOutputTypes() {
        return new Class[]{PARAMETER_TYPE};
    }

    public ProductReader createReaderInstance() {
        return new TestProductReader(this);
    }

    public ProductWriter createWriterInstance() {
        return new TestProductWriter(this);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{FILE_EXT};
    }

    public String getDescription(Locale locale) {
        return FORMAT_DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return null;
    }

    static {
        ProductIOPlugInManager.getInstance().addReaderPlugIn((ProductReaderPlugIn)INSTANCE);
        ProductIOPlugInManager.getInstance().addWriterPlugIn((ProductWriterPlugIn)INSTANCE);
    }

    public static class TestProductWriter
    extends AbstractProductWriter {
        public TestProductWriter(TestProductIOPlugIn writerPlugIn) {
            super((ProductWriterPlugIn)writerPlugIn);
        }

        public TestProductIOPlugIn getWriterPlugIn() {
            return (TestProductIOPlugIn)super.getWriterPlugIn();
        }

        protected void writeProductNodesImpl() throws IOException {
            this.getWriterPlugIn().getTargetProducts().put(this.getOutput(), this.getSourceProduct());
        }

        public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void deleteOutput() throws IOException {
            this.getWriterPlugIn().getTargetProducts().remove(this.getOutput());
        }
    }

    public static class TestProductReader
    extends AbstractProductReader {
        public TestProductReader(TestProductIOPlugIn readerPlugIn) {
            super((ProductReaderPlugIn)readerPlugIn);
        }

        public TestProductIOPlugIn getReaderPlugIn() {
            return (TestProductIOPlugIn)super.getReaderPlugIn();
        }

        protected Product readProductNodesImpl() throws IOException {
            return this.getReaderPlugIn().getSourceProducts().get(this.getInput());
        }

        protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        }
    }
}

