/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.sun.media.jai.util.SunTileScheduler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.TileScheduler;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.main.CommandLineContext;
import org.esa.snap.core.gpf.main.CommandLineTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommandLineToolOperatorTest {
    private OpCommandLineContext context;
    private CommandLineTool clTool;
    private static final TestOps.Op3.Spi OP3_SPI = new TestOps.Op3.Spi();
    private static final TestOps.Op4.Spi OP4_SPI = new TestOps.Op4.Spi();
    private static final TestOps.Op5.Spi OP5_SPI = new TestOps.Op5.Spi();
    private static final TestOps.OpImplementingOutput.Spi OUTPUT_OP_SPI = new TestOps.OpImplementingOutput.Spi();
    private TileScheduler jaiTileScheduler;

    @Before
    public void setUp() throws Exception {
        this.context = new OpCommandLineContext();
        this.clTool = new CommandLineTool((CommandLineContext)this.context);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP3_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP4_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP5_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OUTPUT_OP_SPI);
        JAI jai = JAI.getDefaultInstance();
        this.jaiTileScheduler = jai.getTileScheduler();
        SunTileScheduler tileScheduler = new SunTileScheduler();
        tileScheduler.setParallelism(Runtime.getRuntime().availableProcessors());
        jai.setTileScheduler((TileScheduler)tileScheduler);
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP3_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP4_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP5_SPI);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OUTPUT_OP_SPI);
        JAI.getDefaultInstance().setTileScheduler(this.jaiTileScheduler);
    }

    @Test
    public void testPrintUsage() throws Exception {
        Assert.assertTrue((this.context.output.length() == 0 ? 1 : 0) != 0);
        this.clTool.run(new String[]{"-h"});
        Assert.assertTrue((boolean)this.context.output.startsWith("Usage:\n  gpt <op>|<graph-file> [options] "));
    }

    @Test
    public void testPrintOp3Usage() throws Exception {
        Assert.assertTrue((this.context.output.length() == 0 ? 1 : 0) != 0);
        this.clTool.run(new String[]{"Op3", "-h"});
        Assert.assertTrue((boolean)this.context.output.startsWith("Usage:\n  gpt Op3 [options] "));
    }

    @Test
    public void testPrintOp4Usage() throws Exception {
        Assert.assertTrue((this.context.output.length() == 0 ? 1 : 0) != 0);
        this.clTool.run(new String[]{"Op4", "-h"});
        Assert.assertTrue((boolean)this.context.output.startsWith("Usage:\n  gpt Op4 [options] \n\nComputed Properties:\nString[] names\ndouble PI         The ratio of any circle's circumference to its diameter"));
    }

    @Test
    public void testOperatorImplementingOutputInterface() throws Exception {
        this.clTool.run(new String[]{"OutputOp"});
        Assert.assertEquals((long)0L, (long)this.context.writeProductCounter);
    }

    @Test
    public void testFailureNoReaderFound() {
        CommandLineTool tool = new CommandLineTool((CommandLineContext)new OpCommandLineContext(){

            @Override
            public Product readProduct(String productFilepath) {
                return null;
            }
        });
        try {
            tool.run(new String[]{"Op3", "-Sinput1=vercingetorix.dim", "-Sinput2=asterix.N1"});
            Assert.fail((String)"Exception expected for reason: No reader found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSystemProperty() throws Exception {
        Assert.assertTrue((this.context.output.length() == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)System.getProperty("foo"));
        int originalSize = System.getProperties().size();
        this.clTool.run(new String[]{"Op4", "-Dfoo=bar"});
        Assert.assertEquals((Object)"bar", (Object)System.getProperty("foo"));
        Assert.assertEquals((long)(originalSize + 1), (long)System.getProperties().size());
    }

    private static class OpCommandLineContext
    implements CommandLineContext {
        private int writeProductCounter;
        private String output = "";

        private OpCommandLineContext() {
        }

        public Product readProduct(String productFilepath) throws IOException {
            return new Product("S", "ST", 10, 10);
        }

        public void writeProduct(Product targetProduct, String filePath, String formatName, boolean clearCacheAfterRowWrite) throws IOException {
            ++this.writeProductCounter;
        }

        public Graph readGraph(String filepath, Map<String, String> templateVariables) throws IOException {
            Assert.fail((String)"did not expect to come here");
            return null;
        }

        public void executeGraph(Graph graph, GraphProcessingObserver observer) throws GraphException {
            Assert.fail((String)"did not expect to come here");
        }

        public Writer createWriter(String fileName) throws IOException {
            return new StringWriter();
        }

        public String[] list(String path) throws IOException {
            return new String[0];
        }

        public boolean isFile(String path) {
            return true;
        }

        public Reader createReader(String fileName) throws FileNotFoundException {
            switch (fileName) {
                case "testOperatorWithParametersFromFile": {
                    return new StringReader("expression = log(2+radiance_13)\nignoreSign = true\nfactor = -0.035");
                }
                case "testOperatorWithParametersFromXMLFile": {
                    return new StringReader("<parameters><expression>log(2+radiance_13)</expression><ignoreSign>true</ignoreSign><factor>-0.035</factor></parameters>");
                }
            }
            return new StringReader("expression = sqrt(x*x + y*y)\nthreshold = -0.5125");
        }

        public void print(String m) {
            this.output = this.output + m;
        }

        public Logger getLogger() {
            return Logger.getLogger("test");
        }

        public boolean fileExists(String fileName) {
            return false;
        }
    }
}

