/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.bc.ceres.binding.dom.DomElement;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.main.CommandLineContext;
import org.esa.snap.core.gpf.main.CommandLineTool;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CommandLineToolMultiSourceGraphTest {
    private static final TestOps.Op5.Spi OP5_SPI = new TestOps.Op5.Spi();
    private GraphCommandLineContext context;
    private CommandLineTool clTool;

    @BeforeClass
    public static void setupTest() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)OP5_SPI);
    }

    @AfterClass
    public static void tearDownTest() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)OP5_SPI);
    }

    @Before
    public void setUp() throws Exception {
        this.context = new GraphCommandLineContext();
        this.clTool = new CommandLineTool((CommandLineContext)this.context);
    }

    @Test
    public void testGraphWithTwoSources() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ReadOp@sourceProduct", "ernie.dim");
        map.put("ReadOp@sourceProduct.2", "idefix.dim");
        this.testGraph(new String[]{"graph.xml", "ernie.dim", "idefix.dim"}, 4, "g=graph.xml;e=chain1;", map, "WriteOp@node1", "target.dim", "BEAM-DIMAP");
    }

    @Test
    public void testGraphWithWith3Sources() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ReadOp@sourceProduct", "ernie.dim");
        map.put("ReadOp@sourceProduct.2", "idefix.dim");
        map.put("ReadOp@sourceProduct.3", "obelix.dim");
        this.testGraph(new String[]{"graph.xml", "ernie.dim", "idefix.dim", "obelix.dim"}, 5, "g=graph.xml;e=chain1;", map, "WriteOp@node1", "target.dim", "BEAM-DIMAP");
    }

    @Test
    public void testGraphWith2SourcesAndOneNamedSource() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ReadOp@Vincent", "vincent.dim");
        map.put("ReadOp@sourceProduct", "ernie.dim");
        map.put("ReadOp@sourceProduct.2", "idefix.dim");
        this.testGraph(new String[]{"graph.xml", "-SVincent=vincent.dim", "ernie.dim", "idefix.dim"}, 5, "g=graph.xml;e=chain1;", map, "WriteOp@node1", "target.dim", "BEAM-DIMAP");
    }

    @Test
    public void testGraphWithOnlyNamedSources() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ReadOp@Vincent", "vincent.dim");
        map.put("ReadOp@ernie", "ernie.dim");
        map.put("ReadOp@idefix", "idefix.dim");
        this.testGraph(new String[]{"graph.xml", "-SVincent=vincent.dim", "-Sernie=ernie.dim", "-Sidefix=idefix.dim"}, 5, "g=graph.xml;e=chain1;", map, "WriteOp@node1", "target.dim", "BEAM-DIMAP");
    }

    private void testGraph(String[] args, int expectedNodeCount, String expectedLog, Map<String, String> expectedSourceNodeIdFilePathMap, String expectedTargetNodeId, String expectedTargetFilepath, String expectedTargetFormat) throws Exception {
        this.clTool.run(args);
        Assert.assertEquals((Object)expectedLog, (Object)this.context.logString);
        Graph executedGraph = this.context.executedGraph;
        Assert.assertNotNull((Object)executedGraph);
        Assert.assertEquals((long)expectedNodeCount, (long)executedGraph.getNodeCount());
        for (Map.Entry<String, String> entry : expectedSourceNodeIdFilePathMap.entrySet()) {
            String expectedSourceFilePath = entry.getValue();
            if (expectedSourceFilePath == null) continue;
            String key = entry.getKey();
            Node generatedReaderNode1 = executedGraph.getNode(key);
            Assert.assertNotNull((String)("Source ID not found: " + key), (Object)generatedReaderNode1);
            Assert.assertEquals((Object)expectedSourceFilePath, (Object)((DomElement)generatedReaderNode1.getConfiguration().getChild("file")).getValue());
        }
        Node generatedWriterNode = executedGraph.getNode(expectedTargetNodeId);
        Assert.assertNotNull((Object)generatedWriterNode);
        Assert.assertEquals((Object)"node1", (Object)generatedWriterNode.getSource(0).getSourceNodeId());
        DomElement parameters = generatedWriterNode.getConfiguration();
        Assert.assertNotNull((Object)parameters);
        Assert.assertNotNull((String)expectedTargetFilepath, (Object)((DomElement)parameters.getChild("file")).getValue());
        Assert.assertNotNull((String)expectedTargetFormat, (Object)((DomElement)parameters.getChild("formatName")).getValue());
    }

    private static class GraphCommandLineContext
    implements CommandLineContext {
        private String logString = "";
        private int readProductCounter;
        private int writeProductCounter;
        private Graph executedGraph;

        private GraphCommandLineContext() {
        }

        public Product readProduct(String productFilepath) throws IOException {
            this.logString = this.logString + "s" + this.readProductCounter + "=" + productFilepath + ";";
            ++this.readProductCounter;
            return new Product("P", "T", 10, 10);
        }

        public void writeProduct(Product targetProduct, String filePath, String formatName, boolean clearCacheAfterRowWrite) throws IOException {
            this.logString = this.logString + "t" + this.writeProductCounter + "=" + filePath + ";";
            ++this.writeProductCounter;
        }

        public Graph readGraph(String filepath, Map<String, String> templateVariables) throws IOException, GraphException {
            this.logString = this.logString + "g=" + filepath + ";";
            String xml = "<graph id=\"chain1\"><version>1.0</version>\n<node id=\"node1\">  <operator>org.esa.snap.core.gpf.TestOps$Op5$Spi</operator>\n  <sources>\n    <sourceProducts>${sourceProducts}</sourceProducts>\n  </sources>\n</node></graph>";
            return GraphIO.read((Reader)new StringReader(xml), templateVariables);
        }

        public void executeGraph(Graph graph, GraphProcessingObserver observer) throws GraphException {
            this.logString = this.logString + "e=" + graph.getId() + ";";
            this.executedGraph = graph;
        }

        public void print(String m) {
        }

        public Logger getLogger() {
            return Logger.getLogger("test");
        }

        public Reader createReader(String fileName) throws FileNotFoundException {
            return new StringReader(fileName);
        }

        public Writer createWriter(String fileName) throws IOException {
            return new StringWriter();
        }

        public String[] list(String path) throws IOException {
            return new String[0];
        }

        public boolean isFile(String path) {
            return true;
        }

        public boolean fileExists(String fileName) {
            return false;
        }
    }
}

