/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import java.util.Map;
import java.util.SortedMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.main.CommandLineArgs;
import org.esa.snap.core.gpf.main.CommandLineUsage;
import org.esa.snap.runtime.Config;
import org.junit.Assert;
import org.junit.Test;

public class CommandLineArgsTest {
    private static final int K = 1024;
    private static final int M = 0x100000;

    @Test
    public void testSystemProperties() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-Dfoo=bar", "-Dbeam.performance=lightning"});
        Map systemPropertiesMap = lineArgs.getSystemPropertiesMap();
        Assert.assertNotNull((Object)systemPropertiesMap);
        Assert.assertEquals((long)2L, (long)systemPropertiesMap.size());
        Assert.assertEquals((Object)"bar", systemPropertiesMap.get("foo"));
        Assert.assertEquals((Object)"lightning", systemPropertiesMap.get("beam.performance"));
    }

    @Test
    public void testArgsCloned() throws Exception {
        Object[] args = new String[]{"Reproject", "ProjTarget.dim", "UnProjSource.dim"};
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])args);
        Assert.assertTrue((args != lineArgs.getArgs() ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])args, (Object[])lineArgs.getArgs());
    }

    @Test
    public void testNoArgsRequestsHelp() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[0]);
        Assert.assertEquals((Object)true, (Object)lineArgs.isHelpRequested());
    }

    @Test
    public void testHelpOption() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-h"});
        Assert.assertEquals((Object)true, (Object)lineArgs.isHelpRequested());
        Assert.assertEquals((Object)"Reproject", (Object)lineArgs.getOperatorName());
        Assert.assertEquals(null, (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"target.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap map = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testOpOnly() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject"});
        Assert.assertEquals((Object)false, (Object)lineArgs.isHelpRequested());
        Assert.assertEquals((Object)"Reproject", (Object)lineArgs.getOperatorName());
        Assert.assertEquals(null, (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"target.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap map = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testOpWithSource() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim"});
        Assert.assertEquals((Object)"Reproject", (Object)lineArgs.getOperatorName());
        Assert.assertEquals(null, (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"target.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap sourceMap = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)sourceMap);
        Assert.assertEquals((long)3L, (long)sourceMap.size());
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct.1"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct1"));
    }

    @Test
    public void testOpWithTargetAndSource() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-t", "output.dim", "source.dim"});
        Assert.assertEquals((Object)"Reproject", (Object)lineArgs.getOperatorName());
        Assert.assertEquals(null, (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"output.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap sourceMap = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)sourceMap);
        Assert.assertEquals((long)3L, (long)sourceMap.size());
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct.1"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct1"));
    }

    @Test
    public void testMinimumGraph() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"./map-proj.xml", "source.dim"});
        Assert.assertEquals(null, (Object)lineArgs.getOperatorName());
        Assert.assertEquals((Object)"./map-proj.xml", (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"target.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap map = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)"source.dim", map.get("sourceProduct"));
        Assert.assertEquals((Object)"source.dim", map.get("sourceProduct.1"));
        Assert.assertEquals((Object)"source.dim", map.get("sourceProduct1"));
    }

    @Test
    public void testGraphOnly() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"./map-proj.xml"});
        Assert.assertEquals(null, (Object)lineArgs.getOperatorName());
        Assert.assertEquals((Object)"./map-proj.xml", (Object)lineArgs.getGraphFilePath());
        Assert.assertEquals((Object)"target.dim", (Object)lineArgs.getTargetFilePath());
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        SortedMap map = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)map);
    }

    @Test
    public void testFormatDetection() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-t", "target.dim", "source.dim"});
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
        String[] args = new String[]{"Reproject", "source.dim"};
        lineArgs = CommandLineArgs.parseArgs((String[])args);
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
    }

    @Test
    public void testFormatOption() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-t", "target.h5", "-f", "HDF-5", "source.dim"});
        Assert.assertEquals((Object)"HDF-5", (Object)lineArgs.getTargetFormatName());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-f", "GeoTIFF", "-t", "target.tif", "source.dim"});
        Assert.assertEquals((Object)"GeoTIFF", (Object)lineArgs.getTargetFormatName());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-f", "BEAM-DIMAP", "-t", "target.dim", "source.dim"});
        Assert.assertEquals((Object)"BEAM-DIMAP", (Object)lineArgs.getTargetFormatName());
    }

    @Test
    public void testParameterOptions() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-PpixelSizeX=0.02", "-PpixelSizeY=0.03", "-PpixelOffsetX=0.5", "-PpixelOffsetY=1.0", "source.dim"});
        SortedMap parameterMap = lineArgs.getParameterMap();
        Assert.assertEquals((Object)"0.02", parameterMap.get("pixelSizeX"));
        Assert.assertEquals((Object)"0.03", parameterMap.get("pixelSizeY"));
        Assert.assertEquals((Object)"0.5", parameterMap.get("pixelOffsetX"));
        Assert.assertEquals((Object)"1.0", parameterMap.get("pixelOffsetY"));
    }

    @Test
    public void testParametersFileOption() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-p", "param.properties"});
        Assert.assertEquals((Object)"param.properties", (Object)lineArgs.getParameterFilePath());
    }

    @Test
    public void testMetadataFileOption() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject"});
        Assert.assertEquals(null, (Object)lineArgs.getMetadataFilePath());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-m", "metadata/reproject-md.properties"});
        Assert.assertEquals((Object)"metadata/reproject-md.properties", (Object)lineArgs.getMetadataFilePath());
    }

    @Test
    public void testVelocityDirOption() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject"});
        Assert.assertEquals(null, (Object)lineArgs.getVelocityTemplateDirPath());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-v", "metadata/vml"});
        Assert.assertEquals((Object)"metadata/vml", (Object)lineArgs.getVelocityTemplateDirPath());
    }

    @Test
    public void testClearCacheAfterRowWrite() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-x"});
        Assert.assertEquals((Object)true, (Object)lineArgs.isClearCacheAfterRowWrite());
    }

    @Test
    public void testJAIOptions() throws Exception {
        int configuredDefaultCapacity = Config.instance().load().preferences().getInt("snap.jai.tileCacheSize", 512);
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim"});
        Assert.assertEquals((long)(configuredDefaultCapacity * 0x100000), (long)lineArgs.getTileCacheCapacity());
        Assert.assertEquals((long)CommandLineArgs.DEFAULT_TILE_SCHEDULER_PARALLELISM, (long)lineArgs.getTileSchedulerParallelism());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-c", "16M"});
        Assert.assertEquals((long)0x1000000L, (long)lineArgs.getTileCacheCapacity());
        Assert.assertEquals((long)CommandLineArgs.DEFAULT_TILE_SCHEDULER_PARALLELISM, (long)lineArgs.getTileSchedulerParallelism());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-q", "1", "-c", "16000K"});
        Assert.assertEquals((long)0xFA0000L, (long)lineArgs.getTileCacheCapacity());
        Assert.assertEquals((long)1L, (long)lineArgs.getTileSchedulerParallelism());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-c", "16000002", "-q", "3"});
        Assert.assertEquals((long)16000002L, (long)lineArgs.getTileCacheCapacity());
        Assert.assertEquals((long)3L, (long)lineArgs.getTileSchedulerParallelism());
        lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-c", "0", "-q", "10"});
        Assert.assertEquals((long)0L, (long)lineArgs.getTileCacheCapacity());
        Assert.assertEquals((long)10L, (long)lineArgs.getTileSchedulerParallelism());
        try {
            CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "source.dim", "-c", "-6"});
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("negative"));
        }
    }

    @Test
    public void testSourceOptions() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-SndviProduct=./inp/NDVI.dim", "-ScloudProduct=./inp/cloud-mask.dim", "-Pthreshold=5.0", "source.dim"});
        SortedMap sourceMap = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)sourceMap);
        Assert.assertEquals((Object)"./inp/NDVI.dim", sourceMap.get("ndviProduct"));
        Assert.assertEquals((Object)"./inp/cloud-mask.dim", sourceMap.get("cloudProduct"));
    }

    @Test
    public void testMultiSourceOptions() throws Exception {
        CommandLineArgs lineArgs = CommandLineArgs.parseArgs((String[])new String[]{"Reproject", "-Sndvi=./inp/NDVI.dim", "./inp/cloud-mask.dim", "source.dim", "input.dim"});
        SortedMap sourceMap = lineArgs.getSourceFilePathMap();
        Assert.assertNotNull((Object)sourceMap);
        Assert.assertEquals((Object)"./inp/cloud-mask.dim", sourceMap.get("sourceProduct"));
        Assert.assertEquals((Object)"./inp/cloud-mask.dim", sourceMap.get("sourceProduct.1"));
        Assert.assertEquals((Object)"./inp/cloud-mask.dim", sourceMap.get("sourceProduct1"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct.2"));
        Assert.assertEquals((Object)"source.dim", sourceMap.get("sourceProduct2"));
        Assert.assertEquals((Object)"input.dim", sourceMap.get("sourceProduct.3"));
        Assert.assertEquals((Object)"input.dim", sourceMap.get("sourceProduct3"));
        Assert.assertEquals((Object)"./inp/NDVI.dim", sourceMap.get("ndvi"));
    }

    @Test
    public void testUsageText() throws Exception {
        String usageText = CommandLineUsage.getUsageText();
        Assert.assertNotNull((Object)usageText);
        Assert.assertTrue((usageText.length() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void testUsageTextForOperator() throws Exception {
        String opName = "TestOpName";
        String opDesc = "Creates a thing";
        String srcProdAlias = "wasweissich";
        String paramDefaultValue = "24.5";
        String paramUnit = "Zwetschgen";
        String paramDesc = "Wert Beschreibung";
        class TestSpi
        extends OperatorSpi {
            public TestSpi() {
                @OperatorMetadata(alias="TestOpName", description="Creates a thing")
                class TestOp
                extends Operator {
                    @Parameter(defaultValue="24.5", unit="Zwetschgen", description="Wert Beschreibung")
                    double value;
                    @SourceProduct(alias="wasweissich")
                    Product sourceProduct;
                    @TargetProduct
                    Product targetProduct;

                    TestOp() {
                    }

                    public void initialize() throws OperatorException {
                    }
                }
                super(TestOp.class);
            }
        }
        TestSpi testSpi = new TestSpi();
        GPF gpf = GPF.getDefaultInstance();
        OperatorSpiRegistry spiRegistry = gpf.getOperatorSpiRegistry();
        spiRegistry.addOperatorSpi((OperatorSpi)testSpi);
        Assert.assertSame((Object)((Object)testSpi), (Object)spiRegistry.getOperatorSpi("TestOpName"));
        String usageText = CommandLineUsage.getUsageTextForOperator((String)"TestOpName");
        Assert.assertEquals((Object)"Usage:\n  gpt TestOpName [options] \n\nDescription:\n  Creates a thing\n\n\nSource Options:\n  -Swasweissich=<file>    Sets source 'wasweissich' to <filepath>.\n                          This is a mandatory source.\n\nParameter Options:\n  -Pvalue=<double>    Wert Beschreibung\n                      Default value is '24.5'.\n                      Parameter unit is 'Zwetschgen'.\n\nGraph XML Format:\n  <graph id=\"someGraphId\">\n    <version>1.0</version>\n    <node id=\"someNodeId\">\n      <operator>TestOpName</operator>\n      <sources>\n        <wasweissich>${wasweissich}</wasweissich>\n      </sources>\n      <parameters>\n        <value>double</value>\n      </parameters>\n    </node>\n  </graph>\n", (Object)usageText);
    }

    @Test
    public void testFailures() {
        this.testFailure(new String[]{"Reproject", "-p"}, "Option argument missing");
        this.testFailure(new String[]{"Reproject", "-f"}, "Option argument missing");
        this.testFailure(new String[]{"Reproject", "-t", "out.tammomat"}, "Output format unknown");
        this.testFailure(new String[]{"Reproject", "-\u00f6"}, "Unknown option '-\u00f6'");
        this.testFailure(new String[]{"Reproject", "-P=9"}, "Empty identifier");
        this.testFailure(new String[]{"Reproject", "-Pobelix10"}, "Missing '='");
        this.testFailure(new String[]{"Reproject", "-Tsubset=subset.dim"}, "Only valid with a given graph XML");
    }

    private void testFailure(String[] args, String reason) {
        try {
            CommandLineArgs.parseArgs((String[])args);
            Assert.fail((String)("Exception expected for reason: " + reason));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

