/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TileImplTest {
    private static final int W = 16;
    private static final int H = 8;
    private static final int N = 128;
    private static final int N05 = 64;

    @Test
    public void testSignedAndUnsignedByteScaledSamples() {
        Tile tile = TileImplTest.createIntTile(10, -64, 0.1);
        float[] samples = tile.getSamplesFloat();
        Assert.assertEquals((float)-6.4f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)-6.3f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((float)-0.1f, (float)samples[63], (float)1.0E-5f);
        Assert.assertEquals((float)0.0f, (float)samples[64], (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)samples[65], (float)1.0E-5f);
        Assert.assertEquals((float)6.2000003f, (float)samples[126], (float)1.0E-5f);
        Assert.assertEquals((float)6.3f, (float)samples[127], (float)1.0E-5f);
        Assert.assertEquals((float)-6.4f, (float)tile.getSampleFloat(0, 0), (float)1.0E-5f);
        Assert.assertEquals((float)-6.3f, (float)tile.getSampleFloat(1, 0), (float)1.0E-5f);
        Assert.assertEquals((float)-0.1f, (float)tile.getSampleFloat(15, 3), (float)1.0E-5f);
        Assert.assertEquals((float)0.0f, (float)tile.getSampleFloat(0, 4), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)tile.getSampleFloat(1, 4), (float)1.0E-5f);
        Assert.assertEquals((float)6.2000003f, (float)tile.getSampleFloat(14, 7), (float)1.0E-5f);
        Assert.assertEquals((float)6.3f, (float)tile.getSampleFloat(15, 7), (float)1.0E-5f);
        tile = TileImplTest.createIntTile(20, 0, 0.1);
        samples = tile.getSamplesFloat();
        Assert.assertEquals((float)0.0f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((float)6.3f, (float)samples[63], (float)1.0E-5f);
        Assert.assertEquals((float)6.4f, (float)samples[64], (float)1.0E-5f);
        Assert.assertEquals((float)6.5f, (float)samples[65], (float)1.0E-5f);
        Assert.assertEquals((float)12.6f, (float)samples[126], (float)1.0E-5f);
        Assert.assertEquals((float)12.7f, (float)samples[127], (float)1.0E-5f);
        Assert.assertEquals((float)0.0f, (float)tile.getSampleFloat(0, 0), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)tile.getSampleFloat(1, 0), (float)1.0E-5f);
        Assert.assertEquals((float)6.3f, (float)tile.getSampleFloat(15, 3), (float)1.0E-5f);
        Assert.assertEquals((float)6.4f, (float)tile.getSampleFloat(0, 4), (float)1.0E-5f);
        Assert.assertEquals((float)6.5f, (float)tile.getSampleFloat(1, 4), (float)1.0E-5f);
        Assert.assertEquals((float)12.6f, (float)tile.getSampleFloat(14, 7), (float)1.0E-5f);
        Assert.assertEquals((float)12.7f, (float)tile.getSampleFloat(15, 7), (float)1.0E-5f);
    }

    @Test
    public void testSignedAndUnsignedByteUnscaledSamples() {
        Tile tile = TileImplTest.createIntTile(10, -64, 1.0);
        int[] samples = tile.getSamplesInt();
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((long)-64L, (long)samples[0]);
        Assert.assertEquals((long)-63L, (long)samples[1]);
        Assert.assertEquals((long)-1L, (long)samples[63]);
        Assert.assertEquals((long)0L, (long)samples[64]);
        Assert.assertEquals((long)1L, (long)samples[65]);
        Assert.assertEquals((long)62L, (long)samples[126]);
        Assert.assertEquals((long)63L, (long)samples[127]);
        Assert.assertEquals((long)-64L, (long)tile.getSampleInt(0, 0));
        Assert.assertEquals((long)-63L, (long)tile.getSampleInt(1, 0));
        Assert.assertEquals((long)-1L, (long)tile.getSampleInt(15, 3));
        Assert.assertEquals((long)0L, (long)tile.getSampleInt(0, 4));
        Assert.assertEquals((long)1L, (long)tile.getSampleInt(1, 4));
        Assert.assertEquals((long)62L, (long)tile.getSampleInt(14, 7));
        Assert.assertEquals((long)63L, (long)tile.getSampleInt(15, 7));
        tile = TileImplTest.createIntTile(20, 0, 1.0);
        samples = tile.getSamplesInt();
        Assert.assertEquals((long)0L, (long)samples[0]);
        Assert.assertEquals((long)1L, (long)samples[1]);
        Assert.assertEquals((long)63L, (long)samples[63]);
        Assert.assertEquals((long)64L, (long)samples[64]);
        Assert.assertEquals((long)65L, (long)samples[65]);
        Assert.assertEquals((long)126L, (long)samples[126]);
        Assert.assertEquals((long)127L, (long)samples[127]);
        Assert.assertEquals((long)0L, (long)tile.getSampleInt(0, 0));
        Assert.assertEquals((long)1L, (long)tile.getSampleInt(1, 0));
        Assert.assertEquals((long)63L, (long)tile.getSampleInt(15, 3));
        Assert.assertEquals((long)64L, (long)tile.getSampleInt(0, 4));
        Assert.assertEquals((long)65L, (long)tile.getSampleInt(1, 4));
        Assert.assertEquals((long)126L, (long)tile.getSampleInt(14, 7));
        Assert.assertEquals((long)127L, (long)tile.getSampleInt(15, 7));
    }

    @Ignore
    @Test
    public void testSetSamplePreventsOverflow() {
        Product product = new Product("n", "t", 1, 1);
        Band band = product.addBand("x", 10);
        band.setRasterData(band.createCompatibleRasterData());
        double scalingFactor = 2.5;
        band.setScalingFactor(scalingFactor);
        TileImpl scaledTile = new TileImpl((RasterDataNode)band, band.getSourceImage().getData());
        int maxRawValue = 127;
        double geoPhysicalValueOutOfRawRange = (double)(maxRawValue + 1) * scalingFactor;
        scaledTile.setSample(0, 0, geoPhysicalValueOutOfRawRange);
        Assert.assertEquals((double)((double)maxRawValue * scalingFactor), (double)scaledTile.getSampleDouble(0, 0), (double)1.0E-6);
        int minRawValue = -128;
        geoPhysicalValueOutOfRawRange = (double)(minRawValue - 1) * scalingFactor;
        scaledTile.setSample(0, 0, geoPhysicalValueOutOfRawRange);
        Assert.assertEquals((double)((double)minRawValue * scalingFactor), (double)scaledTile.getSampleDouble(0, 0), (double)1.0E-6);
    }

    @Test
    public void testGetSamplesFloat() {
        Tile tile = TileImplTest.createRawTile(30);
        Assert.assertNotNull((Object)tile.getDataBufferFloat());
        Assert.assertNull((Object)tile.getDataBufferDouble());
        float[] samples = tile.getSamplesFloat();
        Assert.assertSame((Object)samples, (Object)tile.getDataBufferFloat());
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((float)1.1f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)2.1f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((float)3.1f, (float)samples[2], (float)1.0E-5f);
        Assert.assertEquals((float)128.1f, (float)samples[127], (float)1.0E-5f);
        tile = TileImplTest.createRawTile(31);
        Assert.assertNull((Object)tile.getDataBufferFloat());
        Assert.assertNotNull((Object)tile.getDataBufferDouble());
        samples = tile.getSamplesFloat();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((float)1.1f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)2.1f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((float)3.1f, (float)samples[2], (float)1.0E-5f);
        Assert.assertEquals((float)128.1f, (float)samples[127], (float)1.0E-5f);
        tile = TileImplTest.createScaledTile(21, 2.5);
        Assert.assertNull((Object)tile.getDataBufferDouble());
        samples = tile.getSamplesFloat();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((float)2.5f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)5.0f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((float)7.5f, (float)samples[2], (float)1.0E-5f);
        Assert.assertEquals((float)320.0f, (float)samples[127], (float)1.0E-5f);
        tile = TileImplTest.createScaledTileWithNaNs(21, 2.5, 7.5);
        Assert.assertNull((Object)tile.getDataBufferDouble());
        samples = tile.getSamplesFloat();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((float)2.5f, (float)samples[0], (float)1.0E-5f);
        Assert.assertEquals((float)5.0f, (float)samples[1], (float)1.0E-5f);
        Assert.assertEquals((Object)true, (Object)Float.isNaN(samples[2]));
        Assert.assertEquals((float)320.0f, (float)samples[127], (float)1.0E-5f);
    }

    @Test
    public void testGetSamplesDouble() {
        Tile tile = TileImplTest.createScaledTileWithNaNs(21, 2.5, 7.5);
        Assert.assertNull((Object)tile.getDataBufferDouble());
        double[] samples = tile.getSamplesDouble();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((double)2.5, (double)samples[0], (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)samples[1], (double)1.0E-10);
        Assert.assertEquals((Object)true, (Object)Double.isNaN(samples[2]));
        Assert.assertEquals((double)320.0, (double)samples[127], (double)1.0E-10);
        tile = TileImplTest.createRawTile(30);
        Assert.assertNull((Object)tile.getDataBufferDouble());
        samples = tile.getSamplesDouble();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((double)1.1, (double)samples[0], (double)1.0E-5f);
        Assert.assertEquals((double)2.1, (double)samples[1], (double)1.0E-5f);
        Assert.assertEquals((double)128.1f, (double)samples[127], (double)1.0E-5f);
    }

    @Test
    public void testSetSamples() {
        Tile tile = TileImplTest.createScaledTileWithNaNs(21, 2.5, 7.5);
        float[] newSamplesF = new float[128];
        Arrays.fill(newSamplesF, 5.1f);
        tile.setSamples(newSamplesF);
        double[] samples = tile.getSamplesDouble();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((double)5.0, (double)samples[0], (double)1.0E-5f);
        Assert.assertEquals((double)5.0, (double)samples[127], (double)1.0E-5f);
        double[] newSamplesD = new double[128];
        Arrays.fill(newSamplesD, 12.2);
        tile.setSamples(newSamplesD);
        samples = tile.getSamplesDouble();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)128L, (long)samples.length);
        Assert.assertEquals((double)10.0, (double)samples[0], (double)1.0E-10);
        Assert.assertEquals((double)10.0, (double)samples[127], (double)1.0E-10);
    }

    static Tile createRawTile(int type) {
        return TileImplTest.createScaledTile(type, 1.0);
    }

    static Tile createScaledTile(int type, double scalingFactor) {
        return TileImplTest._createTile(type, scalingFactor, false, 0.0);
    }

    static Tile createScaledTileWithNaNs(int type, double scalingFactor, double noDataValue) {
        return TileImplTest._createTile(type, scalingFactor, true, noDataValue);
    }

    private static Tile _createTile(int type, double scalingFactor, boolean dataValueUsed, double noDataValue) {
        Product product = new Product("n", "t", 16, 8);
        Band band = product.addBand("x", type);
        band.setScalingFactor(scalingFactor);
        band.setGeophysicalNoDataValue(noDataValue);
        band.setNoDataValueUsed(dataValueUsed);
        ProductData rasterData = band.createCompatibleRasterData();
        for (int i = 0; i < 128; ++i) {
            rasterData.setElemDoubleAt(i, (double)(i + 1) + 0.1);
        }
        band.setRasterData(rasterData);
        return new TileImpl((RasterDataNode)band, band.getSourceImage().getData());
    }

    private static Tile createIntTile(int type, int i0, double scalingFactor) {
        Product product = new Product("n", "t", 16, 8);
        Band band = product.addBand("x", type);
        band.setScalingFactor(scalingFactor);
        ProductData rasterData = band.createCompatibleRasterData();
        for (int i = 0; i < 128; ++i) {
            rasterData.setElemDoubleAt(i, (double)(i0 + i));
        }
        band.setRasterData(rasterData);
        return new TileImpl((RasterDataNode)band, band.getSourceImage().getData());
    }
}

