/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.internal.SampleConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SampleConverterFactoryUINT8Test {
    private static Band band;

    @Before
    public void beforeTest() {
        band = new Band("n", 20, 1, 1);
        band.setRasterData(band.createCompatibleRasterData());
    }

    @Test
    public void testToGeoPhysical_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)255.0, (double)sampleConverter.toGeoPhysical(255.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)16.0, (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)128.0, (double)sampleConverter.toGeoPhysical(128.0), (double)1.0E-6);
    }

    @Test
    public void testToGeoPhysical_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)(255.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(255.0), (double)1.0E-6);
        Assert.assertEquals((double)(0.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)(16.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)(128.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(128.0), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)255.0, (double)sampleConverter.toRaw(255.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)10.8, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)128.0, (double)sampleConverter.toRaw(128.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(-1.0), (double)1.0E-6);
        Assert.assertEquals((double)255.0, (double)sampleConverter.toRaw(256.0), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)231.8181818181818, (double)sampleConverter.toRaw(255.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)9.818181818181818, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)116.36363636363636, (double)sampleConverter.toRaw(128.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(-1.1), (double)1.0E-6);
        Assert.assertEquals((double)255.0, (double)sampleConverter.toRaw(281.6), (double)1.0E-6);
    }
}

