/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.internal.SampleConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SampleConverterFactoryINT16Test {
    private static Band band;

    @Before
    public void beforeTest() {
        band = new Band("n", 11, 1, 1);
        band.setRasterData(band.createCompatibleRasterData());
    }

    @Test
    public void testToGeoPhysical_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)32767.0, (double)sampleConverter.toGeoPhysical(32767.0), (double)1.0E-6);
        Assert.assertEquals((double)-356.0, (double)sampleConverter.toGeoPhysical(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)16.0, (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)-32768.0, (double)sampleConverter.toGeoPhysical(-32768.0), (double)1.0E-6);
    }

    @Test
    public void testToGeoPhysical_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)(32767.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(32767.0), (double)1.0E-6);
        Assert.assertEquals((double)(-356.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)(0.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(0.0), (double)1.0E-6);
        Assert.assertEquals((double)(16.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(16.0), (double)1.0E-6);
        Assert.assertEquals((double)(-32768.0 * scalingFactor), (double)sampleConverter.toGeoPhysical(-32768.0), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Unscaled() {
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)32767.0, (double)sampleConverter.toRaw(32767.0), (double)1.0E-6);
        Assert.assertEquals((double)-356.0, (double)sampleConverter.toRaw(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)10.8, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)-32768.0, (double)sampleConverter.toRaw(-32768.0), (double)1.0E-6);
        Assert.assertEquals((double)-32768.0, (double)sampleConverter.toRaw(-32769.0), (double)1.0E-6);
        Assert.assertEquals((double)32767.0, (double)sampleConverter.toRaw(32768.0), (double)1.0E-6);
    }

    @Test
    public void testToRaw_Scaled() {
        double scalingFactor = 1.1;
        band.setScalingFactor(scalingFactor);
        SampleConverterFactory.SampleConverter sampleConverter = SampleConverterFactory.createConverter((RasterDataNode)band);
        Assert.assertNotNull((Object)sampleConverter);
        Assert.assertEquals((double)29788.181818181816, (double)sampleConverter.toRaw(32767.0), (double)1.0E-6);
        Assert.assertEquals((double)-323.6363636363636, (double)sampleConverter.toRaw(-356.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampleConverter.toRaw(0.0), (double)1.0E-6);
        Assert.assertEquals((double)9.818181818181818, (double)sampleConverter.toRaw(10.8), (double)1.0E-6);
        Assert.assertEquals((double)-29789.090909090908, (double)sampleConverter.toRaw(-32768.0), (double)1.0E-6);
        Assert.assertEquals((double)-32768.0, (double)sampleConverter.toRaw(-36045.9), (double)1.0E-6);
        Assert.assertEquals((double)32767.0, (double)sampleConverter.toRaw(36044.8), (double)1.0E-6);
    }
}

