/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ServiceRegistry;
import java.util.Set;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.internal.OperatorSpiRegistryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperatorSpiRegistryImplTest {
    private OperatorSpiRegistry registry;

    @Before
    public void setUp() throws Exception {
        this.registry = new OperatorSpiRegistryImpl();
        Set alreadyRegisteredSpis = this.registry.getOperatorSpis();
        for (OperatorSpi alreadyRegisteredSpi : alreadyRegisteredSpis) {
            this.registry.removeOperatorSpi(alreadyRegisteredSpi);
        }
    }

    @Test
    public void testAddRemoveWithAndWithoutAlias() {
        DummyOp.Spi spi = new DummyOp.Spi();
        Assert.assertTrue((boolean)this.registry.addOperatorSpi((OperatorSpi)spi));
        Assert.assertFalse((boolean)this.registry.addOperatorSpi((OperatorSpi)spi));
        Assert.assertSame((Object)((Object)spi), (Object)this.registry.getOperatorSpi(DummyOp.Spi.class.getName()));
        Assert.assertSame((Object)((Object)spi), (Object)this.registry.getOperatorSpi("Heino"));
        Set operatorSpis = this.registry.getOperatorSpis();
        Assert.assertEquals((long)1L, (long)operatorSpis.size());
        Assert.assertTrue((boolean)operatorSpis.contains((Object)spi));
        Assert.assertTrue((boolean)this.registry.removeOperatorSpi((OperatorSpi)spi));
        Assert.assertFalse((boolean)this.registry.removeOperatorSpi((OperatorSpi)spi));
        Assert.assertNull((Object)this.registry.getOperatorSpi(DummyOp.Spi.class.getName()));
        Assert.assertNull((Object)this.registry.getOperatorSpi("Heino"));
    }

    @Test
    public void testMultipleSpiInstanceOfSameClass() {
        DummyOp.Spi heino1 = new DummyOp.Spi();
        DummyOp.Spi heino2 = new DummyOp.Spi();
        DummyOp.Spi heino3 = new DummyOp.Spi();
        Assert.assertTrue((boolean)this.registry.addOperatorSpi("Heino1", (OperatorSpi)heino1));
        Assert.assertTrue((boolean)this.registry.addOperatorSpi("Heino2", (OperatorSpi)heino2));
        Assert.assertTrue((boolean)this.registry.addOperatorSpi("Heino3", (OperatorSpi)heino3));
        Assert.assertFalse((boolean)this.registry.addOperatorSpi("Heino1", (OperatorSpi)heino1));
        Assert.assertFalse((boolean)this.registry.addOperatorSpi("Heino2", (OperatorSpi)heino2));
        Assert.assertFalse((boolean)this.registry.addOperatorSpi("Heino3", (OperatorSpi)heino3));
        Assert.assertSame((Object)((Object)heino1), (Object)this.registry.getOperatorSpi("Heino1"));
        Assert.assertSame((Object)((Object)heino2), (Object)this.registry.getOperatorSpi("Heino2"));
        Assert.assertSame((Object)((Object)heino3), (Object)this.registry.getOperatorSpi("Heino3"));
        ServiceRegistry serviceRegistry = this.registry.getServiceRegistry();
        Set services = serviceRegistry.getServices();
        Assert.assertFalse((boolean)services.contains((Object)heino1));
        Assert.assertFalse((boolean)services.contains((Object)heino2));
        Assert.assertFalse((boolean)services.contains((Object)heino3));
        Set operatorSpis = this.registry.getOperatorSpis();
        Assert.assertEquals((long)3L, (long)operatorSpis.size());
        Assert.assertTrue((boolean)operatorSpis.contains((Object)heino1));
        Assert.assertTrue((boolean)operatorSpis.contains((Object)heino2));
        Assert.assertTrue((boolean)operatorSpis.contains((Object)heino3));
    }

    @Test
    public void testRemovalWhenSpiRegisteredWithAlias() throws InterruptedException {
        DummyOp.Spi heino1 = new DummyOp.Spi();
        Assert.assertTrue((boolean)this.registry.addOperatorSpi("Heino1", (OperatorSpi)heino1));
        Assert.assertTrue((boolean)this.registry.removeOperatorSpi((OperatorSpi)heino1));
        Assert.assertTrue((boolean)this.registry.getAliases().isEmpty());
    }

    @OperatorMetadata(alias="Heino")
    public static class DummyOp
    extends TestOps.Op1 {

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(DummyOp.class);
            }
        }
    }
}

