/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.sun.media.jai.util.SunTileCache;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.OperatorImageTileStack;

public class OperatorImageTileStackTest
extends TestCase {
    public void testIsBandComputedByThisOperator() {
        OperatorImageTileStackTest.assertTrue((boolean)true);
    }

    public void testTileStackImage() throws Exception {
        final SunTileCache tileCache = (SunTileCache)JAI.getDefaultInstance().getTileCache();
        tileCache.flush();
        long cacheTileCount = tileCache.getCacheTileCount();
        OperatorImageTileStackTest.assertEquals((long)0L, (long)cacheTileCount);
        Operator operator = new Operator(){

            public void initialize() throws OperatorException {
                Product product = new Product("name", "desc", 1, 1);
                RenderedOp d = ConstantDescriptor.create((Float)Float.valueOf(product.getSceneRasterWidth()), (Float)Float.valueOf(product.getSceneRasterHeight()), (Number[])new Float[]{Float.valueOf(0.5f)}, null);
                product.addBand("a", 12);
                product.addBand("b", 12);
                product.addBand("c", 12);
                product.addBand("d", 30).setSourceImage((RenderedImage)d);
                this.setTargetProduct(product);
            }

            public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
                TestCase.assertEquals((int)3, (int)targetTiles.size());
                for (Tile tt : targetTiles.values()) {
                    ProductData dataBuffer = tt.getDataBuffer();
                    int numElems = dataBuffer.getNumElems();
                    for (int i = 0; i < numElems; ++i) {
                        dataBuffer.setElemIntAt(i, i);
                    }
                }
                TestCase.assertEquals((long)0L, (long)tileCache.getCacheTileCount());
            }
        };
        Product targetProduct = operator.getTargetProduct();
        OperatorImageTileStackTest.assertNotNull((Object)targetProduct);
        OperatorImageTileStackTest.assertEquals((int)4, (int)targetProduct.getNumBands());
        MultiLevelImage sourceImage = targetProduct.getBandAt(0).getSourceImage();
        RenderedImage image = sourceImage.getImage(0);
        OperatorImageTileStackTest.assertNotNull((Object)image);
        OperatorImageTileStackTest.assertEquals(OperatorImageTileStack.class, image.getClass());
        image.getData();
        cacheTileCount = tileCache.getCacheTileCount();
        OperatorImageTileStackTest.assertEquals((long)3L, (long)cacheTileCount);
    }
}

