/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.junit.Assert;
import org.junit.Test;

public class OperatorContextTest {
    @Test
    public void testSourceProductAnnotations() {
        TestOperator testOp = new TestOperator();
        OperatorContext opContext = new OperatorContext((Operator)testOp);
        Product productP1Bibo = new Product("p1-bibo", "T", 10, 10);
        Product productP2Bert = new Product("p2-bert", "T", 10, 10);
        Product productUnnamed = new Product("unnamed", "T", 10, 10);
        Product[] products = new Product[]{new Product("John Doe", "T", 10, 10), new Product("Jane Doe", "T", 10, 10)};
        opContext.setSourceProducts(products);
        opContext.setSourceProduct("bibo", productP1Bibo);
        opContext.setSourceProduct("p2", productP2Bert);
        opContext.setSourceProduct("sourceProduct", productUnnamed);
        opContext.getTargetProduct();
        Assert.assertNotNull((Object)testOp.p1);
        Assert.assertSame((Object)testOp.p1, (Object)productP1Bibo);
        Assert.assertNotNull((Object)testOp.p2);
        Assert.assertSame((Object)testOp.p2, (Object)productP2Bert);
        Assert.assertNotNull((Object)testOp.products);
        Assert.assertEquals((long)3L, (long)testOp.products.length);
        Assert.assertEquals((Object)"sourceProduct.1", (Object)opContext.getSourceProductId(products[0]));
        Assert.assertEquals((Object)"sourceProduct.2", (Object)opContext.getSourceProductId(products[1]));
        Assert.assertEquals((Object)"sourceProduct", (Object)opContext.getSourceProductId(productUnnamed));
        Assert.assertEquals((Object)"bibo", (Object)opContext.getSourceProductId(productP1Bibo));
        Assert.assertEquals((Object)"p2", (Object)opContext.getSourceProductId(productP2Bert));
    }

    @Test
    public void testWithSourceProductsAlreadySet() {
        TestOperator testOp = new TestOperator();
        Product[] products = new Product[]{new Product("John Doe", "T", 10, 10), new Product("Jane Doe", "T", 10, 10)};
        testOp.products = products;
        OperatorContext opContext = new OperatorContext((Operator)testOp);
        Product productP1Bibo = new Product("p1-bibo", "T", 10, 10);
        Product productP2Bert = new Product("p2-bert", "T", 10, 10);
        Product productUnnamed = new Product("unnamed", "T", 10, 10);
        opContext.setSourceProduct("bibo", productP1Bibo);
        opContext.setSourceProduct("p2", productP2Bert);
        opContext.setSourceProduct("xyz", productUnnamed);
        opContext.getTargetProduct();
        Assert.assertNotNull((Object)testOp.p1);
        Assert.assertSame((Object)testOp.p1, (Object)productP1Bibo);
        Assert.assertNotNull((Object)testOp.p2);
        Assert.assertSame((Object)testOp.p2, (Object)productP2Bert);
        Assert.assertNotNull((Object)testOp.products);
        Assert.assertEquals((long)3L, (long)testOp.products.length);
        Assert.assertEquals((Object)"sourceProduct.1", (Object)opContext.getSourceProductId(products[0]));
        Assert.assertEquals((Object)"sourceProduct.2", (Object)opContext.getSourceProductId(products[1]));
        Assert.assertSame((Object)products[0], (Object)opContext.getSourceProduct("sourceProduct.1"));
        Assert.assertSame((Object)products[1], (Object)opContext.getSourceProduct("sourceProduct.2"));
        Assert.assertSame((Object)products[0], (Object)opContext.getSourceProduct("sourceProduct1"));
        Assert.assertSame((Object)products[1], (Object)opContext.getSourceProduct("sourceProduct2"));
        Assert.assertEquals((Object)"bibo", (Object)opContext.getSourceProductId(productP1Bibo));
        Assert.assertEquals((Object)"p2", (Object)opContext.getSourceProductId(productP2Bert));
        Assert.assertEquals((Object)"xyz", (Object)opContext.getSourceProductId(productUnnamed));
    }

    @Test
    public void testProcessingGraphInMetadata() {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        if (operatorSpiRegistry.getOperatorSpi("Subset") == null) {
            operatorSpiRegistry.addOperatorSpi((OperatorSpi)new SubsetOp.Spi());
        }
        Operator testOp = operatorSpiRegistry.getOperatorSpi("Subset").createOperator();
        testOp.setSourceProduct(new Product("dummy", "T", 10, 10));
        Product targetProduct = testOp.getTargetProduct();
        MetadataElement metadataRoot = targetProduct.getMetadataRoot();
        MetadataElement elementPG = metadataRoot.getElement("Processing_Graph");
        Assert.assertNotNull((Object)elementPG);
        MetadataElement node0Element = elementPG.getElement("node.0");
        Assert.assertNotNull((Object)node0Element);
        Assert.assertEquals((long)9L, (long)node0Element.getNumAttributes());
        Assert.assertNotNull((Object)node0Element.getAttribute("id"));
        Assert.assertNotNull((Object)node0Element.getAttribute("operator"));
        Assert.assertNotNull((Object)node0Element.getAttribute("moduleName"));
        Assert.assertEquals((Object)"SNAP Graph Processing Framework (GPF)", (Object)node0Element.getAttributeString("moduleName"));
        Assert.assertNotNull((Object)node0Element.getAttribute("moduleVersion"));
        Assert.assertNotNull((Object)node0Element.getAttribute("processingTime"));
    }

    @Test
    public void testInitOfRasterDataNodeTypeParameter() {
        OperatorContext context = new OperatorContext((Operator)new TestOperator());
        Product productBibo = new Product("bibo", "T", 10, 10);
        productBibo.addBand("Bibo1", 10);
        productBibo.addBand("Bibo2", 10);
        productBibo.addBand("Bibo3", 10);
        Product productBert = new Product("bert", "T", 10, 10);
        productBibo.addBand("Bert1", 10);
        context.setSourceProduct("bibo", productBibo);
        context.setSourceProduct("bert", productBert);
        context.updatePropertyDescriptors();
        context.setParameter("bandNames", (Object)new String[]{"Bibo1", "Bibo2"});
        context.getTargetProduct();
    }

    private static class TestOperator
    extends Operator {
        @SourceProduct(alias="bibo")
        Product p1;
        @SourceProduct(alias="bert")
        Product p2;
        @SourceProducts
        Product[] products;
        @TargetProduct
        Product targetProduct;
        @Parameter(rasterDataNodeType=Band.class)
        String[] bandNames;

        private TestOperator() {
        }

        public void initialize() throws OperatorException {
            this.targetProduct = new Product("target", "T", 10, 10);
        }
    }
}

