/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.TileImpl;

public class IterableTileTest
extends TestCase {
    public void testNumberOfLoops() {
        int numLoops = 0;
        TileImpl tile = IterableTileTest.createIterableTile(0, 0, 512, 384);
        for (Tile.Pos pos : tile) {
            ++numLoops;
        }
        IterableTileTest.assertEquals((int)196608, (int)numLoops);
    }

    public void testStateAfterLoop() {
        TileImpl tile = IterableTileTest.createIterableTile(0, 0, 512, 384);
        Tile.Pos lastPos = null;
        Iterator iterator = tile.iterator();
        while (iterator.hasNext()) {
            Tile.Pos pos;
            lastPos = pos = (Tile.Pos)iterator.next();
        }
        IterableTileTest.assertNotNull(lastPos);
        IterableTileTest.assertEquals((int)511, (int)lastPos.x);
        IterableTileTest.assertEquals((int)383, (int)lastPos.y);
    }

    static TileImpl createIterableTile(int x0, int y0, int w, int h) {
        Band band = new Band("x", 12, w, h);
        WritableRaster raster = WritableRaster.createBandedRaster(3, w, h, 1, new Point(x0, y0));
        return new TileImpl((RasterDataNode)band, (Raster)raster);
    }
}

