/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.Rectangle;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.DefaultTileIterator;

public class DefaultTileIteratorTest
extends TestCase {
    public void testNextWithOnePixel() {
        DefaultTileIterator tileIterator = new DefaultTileIterator(new Rectangle(0, 0, 1, 1));
        DefaultTileIteratorTest.assertTrue((boolean)tileIterator.hasNext());
        tileIterator.next();
        DefaultTileIteratorTest.assertFalse((boolean)tileIterator.hasNext());
    }

    public void testNextWith3x3Pixels() {
        DefaultTileIterator tileIterator = new DefaultTileIterator(new Rectangle(2, 5, 3, 3));
        int[][] expected = new int[][]{{2, 5}, {3, 5}, {4, 5}, {2, 6}, {3, 6}, {4, 6}, {2, 7}, {3, 7}, {4, 7}};
        for (int i = 0; i < expected.length; ++i) {
            int[] ep = expected[i];
            DefaultTileIteratorTest.assertTrue((boolean)tileIterator.hasNext());
            Tile.Pos p = tileIterator.next();
            DefaultTileIteratorTest.assertEquals((String)("i=" + i), (Object)new Tile.Pos(ep[0], ep[1]), (Object)p);
        }
        DefaultTileIteratorTest.assertFalse((boolean)tileIterator.hasNext());
        try {
            tileIterator.next();
            DefaultTileIteratorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        DefaultTileIterator tileIterator = new DefaultTileIterator(new Rectangle(0, 0, 9, 4));
        try {
            tileIterator.remove();
            DefaultTileIteratorTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

